/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.text.StringKt;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0010H\u0007\u001a\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\nH\u0007\u001a\u0010\u0010\u0016\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a*\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0007\u001a\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0001\u001a2\u0010\u001c\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0002\u001a\u0010\u0010 \u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0007\u001a\u0010\u0010 \u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001H\u0007\u001a\u0010\u0010!\u001a\u00020\u000e2\b\u0010\"\u001a\u0004\u0018\u00010#\u001a\u001c\u0010$\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0012\u0010'\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\u000e\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\f\u001a\u000e\u0010*\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f\u001a \u0010+\u001a\u00020\u00142\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140-H\u0086\b\u00f8\u0001\u0000\u001a\u0016\u0010.\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010/\u001a\u000200\u001a=\u0010.\u001a\u00020\u00142\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2#\b\u0004\u0010/\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b1\u0012\b\b\u0019\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00140-H\u0086\b\u00f8\u0001\u0000\u001a\"\u0010.\u001a\u00020\u00142\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000e02H\u0007\u001a\n\u00103\u001a\u00020\u0001*\u00020\u000e\u001a*\u0010\u001c\u001a\u00020\n*\u00020\u000e2\b\b\u0002\u0010\u001f\u001a\u00020\u00102\b\b\u0002\u0010\u001a\u001a\u00020\n2\b\b\u0002\u0010\u001b\u001a\u00020\nH\u0007\u001a(\u00104\u001a\u00020\u0001*\u00020\u000e2\u0006\u00105\u001a\u00020\u00012\b\b\u0002\u00106\u001a\u00020\u00102\b\b\u0002\u0010\u001a\u001a\u00020\nH\u0007\u001a*\u00104\u001a\u00020\u0001*\u00020\u000e2\b\b\u0001\u00107\u001a\u00020\n2\b\b\u0002\u0010\u001f\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\nH\u0007\u001a\u0016\u00108\u001a\u00020\u0001*\u00020\u000e2\b\b\u0001\u0010\u0015\u001a\u00020\nH\u0007\u001a\f\u00109\u001a\u0004\u0018\u00010\f*\u00020\u0006\u001a\f\u0010:\u001a\u0004\u0018\u00010\f*\u00020\u000e\u001a6\u0010;\u001a\u0002H<\"\u0004\b\u0000\u0010<*\u00020\u000e2\u0019\b\u0004\u0010=\u001a\u0013\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u0002H<0-\u00a2\u0006\u0002\b?H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006A"}, d2={"projectsDataDir", "Ljava/nio/file/Path;", "getProjectsDataDir", "()Ljava/nio/file/Path;", "rootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "Lcom/intellij/openapi/module/Module;", "getRootManager", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/roots/ModuleRootManager;", "calcRelativeToProjectPath", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "includeFilePath", "", "includeUniqueFilePath", "keepModuleAlwaysOnTheLeft", "clearCachesForAllProjects", "", "dataDirName", "currentOrDefaultProject", "doGetProjectFileName", "presentableUrl", "name", "hashSeparator", "extensionWithDot", "getProjectCacheFileName", "projectPath", "projectName", "isForceNameUse", "getProjectDataPathRoot", "guessCurrentProject", "component", "Ljavax/swing/JComponent;", "guessProjectForContentFile", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "guessProjectForFile", "isProjectDirectoryExistsUsingIo", "parent", "isProjectOrWorkspaceFile", "processOpenedProjects", "processor", "Lkotlin/Function1;", "runWhenProjectOpened", "handler", "Ljava/lang/Runnable;", "Lkotlin/ParameterName;", "Ljava/util/function/Consumer;", "getExternalConfigurationDir", "getProjectCachePath", "baseDir", "forceNameUse", "cacheDirName", "getProjectDataPath", "guessModuleDir", "guessProjectDir", "modifyModules", "T", "task", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.platform.ide"})
@JvmName(name="ProjectUtil")
public final class ProjectUtil {
    @NotNull
    public static final ModuleRootManager getRootManager(@NotNull Module $this$rootManager) {
        Intrinsics.checkNotNullParameter((Object)$this$rootManager, (String)"$this$rootManager");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance($this$rootManager);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
        return moduleRootManager;
    }

    @JvmOverloads
    @NlsSafe
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath, boolean includeUniqueFilePath, boolean keepModuleAlwaysOnTheLeft) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file instanceof VirtualFilePathWrapper && ((VirtualFilePathWrapper)((Object)file)).enforcePresentableName()) {
            String string;
            if (includeFilePath) {
                String string2 = ((VirtualFilePathWrapper)((Object)file)).getPresentablePath();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.presentablePath");
            } else {
                String string3 = file.getName();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
            }
            return string;
        }
        String string = includeFilePath ? file.getPresentableUrl() : (includeUniqueFilePath && project != null ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file) : file.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when {\n    includeFilePa\u2026    else -> file.name\n  }");
        String url = string;
        return project == null ? url : ProjectUtilCore.displayUrlRelativeToProject(file, url, project, includeFilePath, keepModuleAlwaysOnTheLeft);
    }

    public static /* synthetic */ String calcRelativeToProjectPath$default(VirtualFile virtualFile2, Project project, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return ProjectUtil.calcRelativeToProjectPath(virtualFile2, project, bl, bl2, bl3);
    }

    @JvmOverloads
    @NlsSafe
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath, boolean includeUniqueFilePath) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, includeFilePath, includeUniqueFilePath, false, 16, null);
    }

    @JvmOverloads
    @NlsSafe
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, includeFilePath, false, false, 24, null);
    }

    @JvmOverloads
    @NlsSafe
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, false, false, false, 28, null);
    }

    @Nullable
    public static final Project guessProjectForFile(@Nullable VirtualFile file) {
        return ProjectLocator.getInstance().guessProjectForFile(file);
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    @Nullable
    public static final Project guessProjectForContentFile(@NotNull VirtualFile file, @NotNull FileType fileType) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
            if (ProjectCoreUtil.isProjectOrWorkspaceFile(file, fileType)) {
                return null;
            }
            v0 = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ProjectManager.getInstance()");
            v1 = v0.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"ProjectManager.getInstance().openProjects");
            $this$filter$iv = v1;
            $i$f$filter = false;
            var5_4 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var8_8 = $this$filterTo$iv$iv;
            var9_10 = ((void)var8_8).length;
            for (var10_11 = 0; var10_11 < var9_10; ++var10_11) {
                it = element$iv$iv = var8_8[var10_11];
                $i$a$-filter-ProjectUtil$guessProjectForContentFile$list$1 = false;
                v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                if (v2.isDefault() || !it.isInitialized() || it.isDisposed()) ** GOTO lbl-1000
                v3 = ProjectRootManager.getInstance((Project)it);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"ProjectRootManager.getInstance(it)");
                if (v3.getFileIndex().isInContent(file)) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            $this$firstOrNull$iv = list;
            $i$f$firstOrNull = false;
            for (E element$iv : $this$firstOrNull$iv) {
                it = (Project)element$iv;
                $i$a$-firstOrNull-ProjectUtil$guessProjectForContentFile$1 = false;
                v5 = WindowManager.getInstance().getFrame(it);
                if (!(v5 != null ? v5.isActive() : false)) continue;
                v6 = element$iv;
                break block6;
            }
            v6 = null;
        }
        if ((v7 = (Project)v6) == null) {
            v7 = (Project)CollectionsKt.firstOrNull((List)list);
        }
        return v7;
    }

    public static /* synthetic */ Project guessProjectForContentFile$default(VirtualFile virtualFile2, FileType fileType, int n, Object object) {
        if ((n & 2) != 0) {
            FileType fileType2 = FileTypeManager.getInstance().getFileTypeByFileName(virtualFile2.getNameSequence());
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"FileTypeManager.getInsta\u2026leName(file.nameSequence)");
            fileType = fileType2;
        }
        return ProjectUtil.guessProjectForContentFile(virtualFile2, fileType);
    }

    @JvmOverloads
    @Nullable
    public static final Project guessProjectForContentFile(@NotNull VirtualFile file) {
        return ProjectUtil.guessProjectForContentFile$default(file, null, 2, null);
    }

    public static final boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file);
    }

    @NotNull
    public static final Project guessCurrentProject(@Nullable JComponent component) {
        Project project;
        Project project2;
        Project project3;
        Project project4 = null;
        if (component != null) {
            project4 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(component));
        }
        if ((project3 = project4) == null) {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Object[] objectArray = projectManager.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ProjectManager.getInstance().openProjects");
            project3 = project2 = (Project)ArraysKt.firstOrNull((Object[])objectArray);
        }
        if (project3 == null) {
            DataManager dataManager = DataManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)dataManager, (String)"DataManager.getInstance()");
            project2 = project = (Project)CommonDataKeys.PROJECT.getData(dataManager.getDataContext());
        }
        if (project2 == null) {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project project5 = projectManager.getDefaultProject();
            project = project5;
            Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"ProjectManager.getInstance().defaultProject");
        }
        return project;
    }

    @NotNull
    public static final Project currentOrDefaultProject(@Nullable Project project) {
        Project project2 = project;
        if (project2 == null) {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project project3 = projectManager.getDefaultProject();
            project2 = project3;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"ProjectManager.getInstance().defaultProject");
        }
        return project2;
    }

    public static final <T> T modifyModules(@NotNull Project $this$modifyModules, @NotNull Function1<? super ModifiableModuleModel, ? extends T> task) {
        int $i$f$modifyModules = 0;
        Intrinsics.checkNotNullParameter((Object)$this$modifyModules, (String)"$this$modifyModules");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        ModuleManager moduleManager = ModuleManager.getInstance($this$modifyModules);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(this)");
        ModifiableModuleModel modifiableModuleModel = moduleManager.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModuleModel, (String)"ModuleManager.getInstance(this).modifiableModel");
        ModifiableModuleModel model = modifiableModuleModel;
        Object result = task.invoke((Object)model);
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(model){
            final /* synthetic */ ModifiableModuleModel $model$inlined;
            {
                this.$model$inlined = modifiableModuleModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        return (T)result;
    }

    public static final boolean isProjectDirectoryExistsUsingIo(@NotNull VirtualFile parent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        try {
            Path path2 = Paths.get(FileUtil.toSystemDependentName((String)parent.getPath()), ".idea");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(FileUtil.toSys\u2026t.DIRECTORY_STORE_FOLDER)");
            bl = PathKt.exists((Path)path2);
        }
        catch (InvalidPathException e) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final VirtualFile guessProjectDir(@NotNull Project $this$guessProjectDir) {
        Module module;
        Object object;
        Object object2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$guessProjectDir, (String)"$this$guessProjectDir");
            if ($this$guessProjectDir.isDefault()) {
                return null;
            }
            ModuleManager moduleManager = ModuleManager.getInstance($this$guessProjectDir);
            Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(this)");
            Object[] modules = moduleManager.getModules();
            if (modules.length == 1) {
                Intrinsics.checkNotNullExpressionValue((Object)modules, (String)"modules");
                object2 = (Module)ArraysKt.first((Object[])modules);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)modules, (String)"modules");
                Object[] $this$firstOrNull$iv = modules;
                boolean $i$f$firstOrNull = false;
                Object[] objectArray = $this$firstOrNull$iv;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object element$iv;
                    Object it = element$iv = objectArray[i];
                    boolean bl = false;
                    Object object3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it");
                    if (!Intrinsics.areEqual((Object)object3.getName(), (Object)$this$guessProjectDir.getName())) continue;
                    object2 = element$iv;
                    break block5;
                }
                object2 = null;
            }
        }
        if ((object = (module = object2)) != null && (object = ProjectUtil.guessModuleDir((Module)object)) != null) {
            Object object4 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object4;
            boolean bl3 = false;
            return it;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        String string = $this$guessProjectDir.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        return localFileSystem.findFileByPath(string);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile guessModuleDir(@NotNull Module $this$guessModuleDir) {
        VirtualFile virtualFile2;
        VirtualFile virtualFile3;
        Object v3;
        List contentRoots;
        block4: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$guessModuleDir, (String)"$this$guessModuleDir");
            VirtualFile[] virtualFileArray = ProjectUtil.getRootManager($this$guessModuleDir).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"rootManager.contentRoots");
            VirtualFile[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object object = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Object t = $this$filterTo$iv$iv;
            int n = ((void)t).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = t[i];
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                if (!v1.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            contentRoots = (List)destination$iv$iv;
            Iterable iterable = contentRoots;
            boolean bl = false;
            object = iterable;
            boolean bl2 = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                t = iterator.next();
                VirtualFile it = (VirtualFile)t;
                boolean bl3 = false;
                VirtualFile virtualFile4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"it");
                if (!Intrinsics.areEqual((Object)virtualFile4.getName(), (Object)$this$guessModuleDir.getName())) continue;
                v3 = t;
                break block4;
            }
            v3 = null;
        }
        if ((virtualFile3 = (VirtualFile)v3) == null) {
            virtualFile3 = virtualFile2 = (VirtualFile)CollectionsKt.firstOrNull((List)contentRoots);
        }
        if (virtualFile3 == null) {
            VirtualFile virtualFile5 = $this$guessModuleDir.getModuleFile();
            virtualFile2 = virtualFile5 != null ? virtualFile5.getParent() : null;
        }
        return virtualFile2;
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $this$getProjectCacheFileName, boolean isForceNameUse, @NotNull String hashSeparator, @NotNull String extensionWithDot) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectCacheFileName, (String)"$this$getProjectCacheFileName");
        Intrinsics.checkNotNullParameter((Object)hashSeparator, (String)"hashSeparator");
        Intrinsics.checkNotNullParameter((Object)extensionWithDot, (String)"extensionWithDot");
        String string = $this$getProjectCacheFileName.getPresentableUrl();
        String string2 = $this$getProjectCacheFileName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        return ProjectUtil.getProjectCacheFileName(string, string2, isForceNameUse, hashSeparator, extensionWithDot);
    }

    public static /* synthetic */ String getProjectCacheFileName$default(Project project, boolean bl, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            string = ".";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        return ProjectUtil.getProjectCacheFileName(project, bl, string, string2);
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $this$getProjectCacheFileName, boolean isForceNameUse, @NotNull String hashSeparator) {
        return ProjectUtil.getProjectCacheFileName$default($this$getProjectCacheFileName, isForceNameUse, hashSeparator, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $this$getProjectCacheFileName, boolean isForceNameUse) {
        return ProjectUtil.getProjectCacheFileName$default($this$getProjectCacheFileName, isForceNameUse, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $this$getProjectCacheFileName) {
        return ProjectUtil.getProjectCacheFileName$default($this$getProjectCacheFileName, false, null, null, 7, null);
    }

    @NotNull
    public static final String getProjectCacheFileName(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return ProjectUtil.getProjectCacheFileName(PathKt.getSystemIndependentPath((Path)projectPath), ((Object)projectPath.getFileName()).toString(), false, ".", "");
    }

    private static final String getProjectCacheFileName(String presentableUrl, String projectName, boolean isForceNameUse, String hashSeparator, String extensionWithDot) {
        String string;
        if (isForceNameUse || presentableUrl == null) {
            string = projectName;
        } else {
            String string2 = PathUtilRt.getFileName((String)presentableUrl);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PathUtilRt.getFileName(presentableUrl)");
            String string3 = string2;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            string = StringsKt.removeSuffix((String)string5, (CharSequence)".ipr");
        }
        String name = string;
        return ProjectUtil.doGetProjectFileName(presentableUrl, PathKt.sanitizeFileName$default((String)name, null, (boolean)false, null, (int)10, null), hashSeparator, extensionWithDot);
    }

    @ApiStatus.Internal
    @NotNull
    public static final String doGetProjectFileName(@Nullable String presentableUrl, @NotNull String name, @NotNull String hashSeparator, @NotNull String extensionWithDot) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)hashSeparator, (String)"hashSeparator");
        Intrinsics.checkNotNullParameter((Object)extensionWithDot, (String)"extensionWithDot");
        String string = presentableUrl;
        if (string == null) {
            string = name;
        }
        String locationHash = Integer.toHexString(string.hashCode());
        return StringKt.trimMiddle(name, RangesKt.coerceAtMost((int)name.length(), (int)(255 - hashSeparator.length() - locationHash.length())), false) + hashSeparator + locationHash + extensionWithDot;
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NonNls @NotNull String cacheDirName, boolean isForceNameUse, @NotNull String extensionWithDot) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectCachePath, (String)"$this$getProjectCachePath");
        Intrinsics.checkNotNullParameter((Object)cacheDirName, (String)"cacheDirName");
        Intrinsics.checkNotNullParameter((Object)extensionWithDot, (String)"extensionWithDot");
        Path path2 = PathManagerEx.getAppSystemDir().resolve(cacheDirName).resolve(ProjectUtil.getProjectCacheFileName$default($this$getProjectCachePath, isForceNameUse, null, extensionWithDot, 2, null));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"appSystemDir.resolve(cac\u2026hDot = extensionWithDot))");
        return path2;
    }

    public static /* synthetic */ Path getProjectCachePath$default(Project project, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        return ProjectUtil.getProjectCachePath(project, string, bl, string2);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NonNls @NotNull String cacheDirName, boolean isForceNameUse) {
        return ProjectUtil.getProjectCachePath$default($this$getProjectCachePath, cacheDirName, isForceNameUse, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NonNls @NotNull String cacheDirName) {
        return ProjectUtil.getProjectCachePath$default($this$getProjectCachePath, cacheDirName, false, null, 6, null);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final Path getProjectDataPath(@NotNull Project $this$getProjectDataPath, @NonNls @NotNull String dataDirName) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectDataPath, (String)"$this$getProjectDataPath");
        Intrinsics.checkNotNullParameter((Object)dataDirName, (String)"dataDirName");
        Path path2 = ProjectUtil.getProjectDataPathRoot($this$getProjectDataPath).resolve(dataDirName);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getProjectDataPathRoot(this).resolve(dataDirName)");
        return path2;
    }

    private static final Path getProjectsDataDir() {
        Path path2 = PathManagerEx.getAppSystemDir().resolve("projects");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"appSystemDir.resolve(\"projects\")");
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Experimental
    public static final void clearCachesForAllProjects(@NonNls @NotNull String dataDirName) {
        Intrinsics.checkNotNullParameter((Object)dataDirName, (String)"dataDirName");
        Path $this$directoryStreamIfExists$iv = ProjectUtil.getProjectsDataDir();
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                DirectoryStream dirs = (DirectoryStream)closeable;
                boolean bl3 = false;
                List filesToDelete2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)dirs), (Function1)((Function1)new Function1<Path, Path>(dataDirName){
                    final /* synthetic */ String $dataDirName$inlined;
                    {
                        this.$dataDirName$inlined = string;
                        super(1);
                    }

                    public final Path invoke(Path it) {
                        return it.resolve(this.$dataDirName$inlined);
                    }
                })), (Function1)clearCachesForAllProjects.1.filesToDelete.2.INSTANCE), (Function1)clearCachesForAllProjects.1.filesToDelete.3.INSTANCE));
                Future future = FileUtil.asyncDelete((Collection)filesToDelete2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final Path getProjectDataPathRoot(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path2 = ProjectUtil.getProjectsDataDir().resolve(ProjectUtil.getProjectCacheFileName$default(project, false, null, null, 7, null));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectsDataDir.resolve(\u2026etProjectCacheFileName())");
        return path2;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Path getProjectDataPathRoot(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Path path2 = ProjectUtil.getProjectsDataDir().resolve(ProjectUtil.getProjectCacheFileName(projectPath));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectsDataDir.resolve(\u2026cheFileName(projectPath))");
        return path2;
    }

    @NotNull
    public static final Path getExternalConfigurationDir(@NotNull Project $this$getExternalConfigurationDir) {
        Intrinsics.checkNotNullParameter((Object)$this$getExternalConfigurationDir, (String)"$this$getExternalConfigurationDir");
        return ProjectUtil.getProjectCachePath$default($this$getExternalConfigurationDir, "external_build_system", false, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NotNull Path baseDir, boolean forceNameUse, @NotNull String hashSeparator) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectCachePath, (String)"$this$getProjectCachePath");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)hashSeparator, (String)"hashSeparator");
        Path path2 = baseDir.resolve(ProjectUtil.getProjectCacheFileName$default($this$getProjectCachePath, forceNameUse, hashSeparator, null, 4, null));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"baseDir.resolve(getProje\u2026eNameUse, hashSeparator))");
        return path2;
    }

    public static /* synthetic */ Path getProjectCachePath$default(Project project, Path path2, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string = ".";
        }
        return ProjectUtil.getProjectCachePath(project, path2, bl, string);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NotNull Path baseDir, boolean forceNameUse) {
        return ProjectUtil.getProjectCachePath$default($this$getProjectCachePath, baseDir, forceNameUse, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NotNull Path baseDir) {
        return ProjectUtil.getProjectCachePath$default($this$getProjectCachePath, baseDir, false, null, 6, null);
    }

    public static final void runWhenProjectOpened(@NotNull Project project, @NotNull Runnable handler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        boolean $i$f$runWhenProjectOpened = false;
        SimpleMessageBusConnection simpleMessageBusConnection = ((ComponentManager)project).getMessageBus().simpleConnect();
        Intrinsics.checkNotNullExpressionValue((Object)simpleMessageBusConnection, (String)"(project ?: ApplicationM\u2026essageBus.simpleConnect()");
        SimpleMessageBusConnection connection$iv = simpleMessageBusConnection;
        connection$iv.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(project, connection$iv, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ SimpleMessageBusConnection $connection;
            final /* synthetic */ Runnable $handler$inlined;
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler$inlined = runnable;
            }

            public void projectOpened(@NotNull Project eventProject) {
                Intrinsics.checkNotNullParameter((Object)eventProject, (String)"eventProject");
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    Project it = eventProject;
                    boolean bl = false;
                    this.$handler$inlined.run();
                }
            }
        });
    }

    @JvmOverloads
    public static final void runWhenProjectOpened(@Nullable Project project, @NotNull Consumer<Project> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$runWhenProjectOpened = false;
        Project project2 = project;
        ComponentManager componentManager = project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)componentManager, (String)"(project ?: ApplicationManager.getApplication())");
        SimpleMessageBusConnection simpleMessageBusConnection = componentManager.getMessageBus().simpleConnect();
        Intrinsics.checkNotNullExpressionValue((Object)simpleMessageBusConnection, (String)"(project ?: ApplicationM\u2026essageBus.simpleConnect()");
        SimpleMessageBusConnection connection$iv = simpleMessageBusConnection;
        connection$iv.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(project, connection$iv, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ SimpleMessageBusConnection $connection;
            final /* synthetic */ Consumer $handler$inlined;
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler$inlined = consumer;
            }

            public void projectOpened(@NotNull Project eventProject) {
                Intrinsics.checkNotNullParameter((Object)eventProject, (String)"eventProject");
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    Project it = eventProject;
                    boolean bl = false;
                    this.$handler$inlined.accept(it);
                }
            }
        });
    }

    public static /* synthetic */ void runWhenProjectOpened$default(Project project, Consumer consumer, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        ProjectUtil.runWhenProjectOpened(project, consumer);
    }

    @JvmOverloads
    public static final void runWhenProjectOpened(@NotNull Consumer<Project> handler) {
        ProjectUtil.runWhenProjectOpened$default(null, handler, 1, null);
    }

    public static final void runWhenProjectOpened(@Nullable Project project, @NotNull Function1<? super Project, Unit> handler) {
        int $i$f$runWhenProjectOpened = 0;
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Project project2 = project;
        ComponentManager componentManager = project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)componentManager, (String)"(project ?: ApplicationManager.getApplication())");
        SimpleMessageBusConnection simpleMessageBusConnection = componentManager.getMessageBus().simpleConnect();
        Intrinsics.checkNotNullExpressionValue((Object)simpleMessageBusConnection, (String)"(project ?: ApplicationM\u2026essageBus.simpleConnect()");
        SimpleMessageBusConnection connection = simpleMessageBusConnection;
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(project, connection, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ SimpleMessageBusConnection $connection;
            final /* synthetic */ Function1 $handler;

            public void projectOpened(@NotNull Project eventProject) {
                Intrinsics.checkNotNullParameter((Object)eventProject, (String)"eventProject");
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    this.$handler.invoke((Object)eventProject);
                }
            }
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler = $captured_local_variable$2;
            }
        });
    }

    public static /* synthetic */ void runWhenProjectOpened$default(Project project, Function1 handler, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        boolean $i$f$runWhenProjectOpened = false;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Project project2 = project;
        ComponentManager componentManager = project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)componentManager, (String)"(project ?: ApplicationManager.getApplication())");
        SimpleMessageBusConnection simpleMessageBusConnection = componentManager.getMessageBus().simpleConnect();
        Intrinsics.checkNotNullExpressionValue((Object)simpleMessageBusConnection, (String)"(project ?: ApplicationM\u2026essageBus.simpleConnect()");
        SimpleMessageBusConnection connection = simpleMessageBusConnection;
        connection.subscribe(ProjectManager.TOPIC, (Object)new /* invalid duplicate definition of identical inner class */);
    }

    public static final void processOpenedProjects(@NotNull Function1<? super Project, Unit> processor) {
        int $i$f$processOpenedProjects = 0;
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Project[] projectArray = ProjectManager.getInstanceIfCreated();
        if (projectArray == null || (projectArray = projectArray.getOpenProjects()) == null) {
            return;
        }
        Project[] projectArray2 = projectArray;
        int n = projectArray2.length;
        for (int i = 0; i < n; ++i) {
            Project project;
            Project project2 = project = projectArray2[i];
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            if (project2.isDisposed() || !project.isInitialized()) continue;
            processor.invoke((Object)project);
        }
    }
}

