/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.util.BooleanFunction;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JTextField;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JBTextField
extends JTextField
implements ComponentWithEmptyText,
TextAccessor {
    private TextComponentEmptyText myEmptyText;

    public JBTextField() {
        this.init();
    }

    public JBTextField(int columns) {
        super(columns);
        this.init();
    }

    public JBTextField(@Nls String text) {
        super(text);
        this.init();
    }

    public JBTextField(@Nls String text, int columns) {
        super(text, columns);
        this.init();
    }

    private void init() {
        UIUtil.addUndoRedoActions((JTextComponent)this);
        this.myEmptyText = new TextComponentEmptyText(this){

            @Override
            protected boolean isStatusVisible() {
                Object function = JBTextField.this.getClientProperty("StatusVisibleFunction");
                if (function instanceof BooleanFunction) {
                    return ((BooleanFunction)function).fun((Object)JBTextField.this);
                }
                return super.isStatusVisible();
            }

            @Override
            protected Rectangle getTextComponentBound() {
                return JBTextField.this.getEmptyTextComponentBounds(super.getTextComponentBound());
            }
        };
    }

    protected Rectangle getEmptyTextComponentBounds(Rectangle bounds) {
        return bounds;
    }

    public void setTextToTriggerEmptyTextStatus(String t) {
        this.myEmptyText.setTextToTriggerStatus(t);
    }

    @Override
    public void setText(String t) {
        if (Objects.equals(t, this.getText())) {
            return;
        }
        super.setText(t);
        UIUtil.resetUndoRedoActions((JTextComponent)this);
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        TextComponentEmptyText textComponentEmptyText = this.myEmptyText;
        if (textComponentEmptyText == null) {
            JBTextField.$$$reportNull$$$0(0);
        }
        return textComponentEmptyText;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.myEmptyText.getStatusTriggerText().isEmpty() && this.myEmptyText.isStatusVisible()) {
            g.setColor(this.getBackground());
            Rectangle rect = new Rectangle(this.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)this.getInsets());
            JBInsets.removeFrom((Rectangle)rect, (Insets)this.getMargin());
            ((Graphics2D)g).fill(rect);
            g.setColor(this.getForeground());
        }
        this.myEmptyText.paintStatusText(g);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TextUI ui = this.getUI();
        String text = ui == null ? null : ui.getToolTipText(this, event.getPoint());
        return text != null ? text : this.getToolTipText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/JBTextField", "getEmptyText"));
    }
}

