/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.panels;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class ValidatingComponent<T extends JComponent>
extends NonOpaquePanel {
    private static final Font ERROR_FONT = UIUtil.getLabelFont().deriveFont(0, 10.0f);
    private JLabel myErrorLabel;
    private T myMainComponent;
    private JLabel myLabel;

    protected ValidatingComponent() {
        this.setLayout(new BorderLayout());
    }

    public final void doInitialize() {
        this.myErrorLabel = this.createErrorLabel();
        this.myMainComponent = this.createMainComponent();
        this.add((Component)this.myMainComponent, "Center");
        this.add((Component)this.myErrorLabel, "South");
    }

    protected abstract T createMainComponent();

    public void setErrorText(@NlsContexts.Label String errorText) {
        if ("".equals(errorText) || errorText == null) {
            errorText = " ";
        }
        this.myErrorLabel.setText(errorText);
    }

    public JLabel getErrorLabel() {
        return this.myErrorLabel;
    }

    public T getMainComponent() {
        return this.myMainComponent;
    }

    public String getErrorText() {
        String text = this.myErrorLabel.getText();
        return " ".equals(text) ? "" : text;
    }

    public void setLabel(JLabel label) {
        this.myLabel = label;
        this.myLabel.setLabelFor((Component)this.myMainComponent);
        this.add((Component)label, "West");
    }

    protected JLabel createErrorLabel() {
        JLabel label = new JLabel(" ");
        label.setForeground((Color)JBColor.red);
        label.setFont(ERROR_FONT);
        return label;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.myLabel != null) {
            this.myErrorLabel.setBorder(BorderFactory.createEmptyBorder(0, this.myLabel.getSize().width, 0, 0));
        }
    }
}

