/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.mtc;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import junit.framework.Assert;

public abstract class MultithreadedTestCase
extends Assert {
    int clock;
    Object lock = new Object();
    private boolean trace = Boolean.getBoolean("tunit.trace");
    boolean failed;
    IdentityHashMap<Thread, Integer> threads = new IdentityHashMap();
    static ThreadLocal<MultithreadedTestCase> currentTestCase = new ThreadLocal();
    HashMap<String, Thread> methodThreads = new HashMap();
    final ReentrantReadWriteLock clockLock = new ReentrantReadWriteLock();
    private static ThreadLocal<Boolean> skipNextWait = new ThreadLocal<Boolean>(){

        @Override
        public Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static ThreadLocal<Random> mtcRandomizer = new ThreadLocal<Random>(){

        @Override
        public Random initialValue() {
            return new Random();
        }
    };

    public void initialize() {
    }

    public void finish() {
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean getTrace() {
        return this.trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hello() {
        currentTestCase.set(this);
        Object object = this.lock;
        synchronized (object) {
            Thread currentThread = Thread.currentThread();
            this.threads.put(currentThread, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void goodbye() {
        Object object = this.lock;
        synchronized (object) {
            Thread currentThread = Thread.currentThread();
            this.threads.remove(currentThread);
        }
        currentTestCase.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThreadByName(String methodName) {
        Object object = this.lock;
        synchronized (object) {
            return this.methodThreads.get(methodName);
        }
    }

    public Thread getThread(int index) {
        return this.getThreadByName("thread" + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread putThread(String methodName, Thread t) {
        Object object = this.lock;
        synchronized (object) {
            return this.methodThreads.put(methodName, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTick(int c) {
        Object object = this.lock;
        synchronized (object) {
            this.threads.put(Thread.currentThread(), c);
            while (!this.failed && this.clock < c) {
                try {
                    if (this.getTrace()) {
                        System.out.println(String.valueOf(Thread.currentThread().getName()) + " is waiting for time " + c);
                    }
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (this.failed) {
                throw new IllegalStateException("Clock never reached " + c);
            }
            if (this.getTrace()) {
                System.out.println("Releasing " + Thread.currentThread().getName() + " at time " + this.clock);
            }
        }
    }

    public void waitForTick(Enum e) {
        this.waitForTick(e.ordinal() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTick() {
        Object object = this.lock;
        synchronized (object) {
            return this.clock;
        }
    }

    public void assertTick(int tick) {
        MultithreadedTestCase.assertEquals((int)tick, (int)this.getTick());
    }

    public void freezeClock() {
        this.clockLock.readLock().lock();
    }

    public void unfreezeClock() {
        this.clockLock.readLock().unlock();
    }

    public boolean isClockFrozen() {
        return this.clockLock.getReadLockCount() > 0;
    }

    public static void skipNextWait() {
        skipNextWait.set(true);
    }

    public static void waitOn(Object o) {
        MultithreadedTestCase thisTestCase = currentTestCase.get();
        if (thisTestCase != null && thisTestCase.failed) {
            throw new RuntimeException("Test case has failed");
        }
        if (skipNextWait.get().booleanValue()) {
            skipNextWait.set(false);
            return;
        }
        try {
            o.wait(3000L);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalMonitorStateException e) {
            System.out.println("Got illegal monitor state exception");
        }
        if (thisTestCase != null && thisTestCase.failed) {
            throw new RuntimeException("Test case has failed");
        }
    }

    public static void awaitOn(Condition c) {
        MultithreadedTestCase thisTestCase = currentTestCase.get();
        if (thisTestCase != null && thisTestCase.failed) {
            throw new RuntimeException("Test case has failed");
        }
        if (skipNextWait.get().booleanValue()) {
            skipNextWait.set(false);
            return;
        }
        try {
            c.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            if (thisTestCase != null && thisTestCase.failed) {
                throw new RuntimeException("Test case has failed");
            }
            throw new AssertionError((Object)e);
        }
        if (thisTestCase != null && thisTestCase.failed) {
            throw new RuntimeException("Test case has failed");
        }
    }

    public void mayYield() {
        this.mayYield(0.5);
    }

    public void mayYield(double probability) {
        if (mtcRandomizer.get().nextDouble() < probability) {
            Thread.yield();
        }
    }
}

