/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.impl.stores.DirectoryStorageUtil;
import com.intellij.util.SmartList;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J,\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00022\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010$\u001a\u00020\u0002H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorageBase;", "Lcom/intellij/configurationStore/StateStorageBase;", "Lcom/intellij/configurationStore/StateMap;", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "(Lcom/intellij/openapi/components/StateSplitter;Lcom/intellij/openapi/components/PathMacroSubstitutor;)V", "componentName", "", "getComponentName", "()Ljava/lang/String;", "setComponentName", "(Ljava/lang/String;)V", "dir", "Ljava/nio/file/Path;", "getDir", "()Ljava/nio/file/Path;", "getPathMacroSubstitutor", "()Lcom/intellij/openapi/components/PathMacroSubstitutor;", "getSplitter", "()Lcom/intellij/openapi/components/StateSplitter;", "analyzeExternalChangesAndUpdateIfNeeded", "", "componentNames", "", "createSaveSessionProducer", "Lcom/intellij/configurationStore/SaveSessionProducer;", "getSerializedState", "Lorg/jdom/Element;", "storageData", "component", "", "archive", "", "hasState", "loadData", "intellij.platform.configurationStore.impl"})
public abstract class DirectoryBasedStorageBase
extends StateStorageBase<StateMap> {
    @Nullable
    private String componentName;
    @NotNull
    private final StateSplitter splitter;
    @Nullable
    private final PathMacroSubstitutor pathMacroSubstitutor;

    @Nullable
    protected final String getComponentName() {
        return this.componentName;
    }

    protected final void setComponentName(@Nullable String string) {
        this.componentName = string;
    }

    @NotNull
    protected abstract Path getDir();

    @NotNull
    public StateMap loadData() {
        Map map = DirectoryStorageUtil.loadFrom((Path)this.getDir(), (PathMacroSubstitutor)this.pathMacroSubstitutor);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"DirectoryStorageUtil.loa\u2026ir, pathMacroSubstitutor)");
        return StateMap.Companion.fromMap(map);
    }

    @Nullable
    public SaveSessionProducer createSaveSessionProducer() {
        return null;
    }

    public void analyzeExternalChangesAndUpdateIfNeeded(@NotNull Set<String> componentNames) {
        Intrinsics.checkNotNullParameter(componentNames, (String)"componentNames");
        StateMap newData = this.loadData();
        this.getStorageDataRef().set(newData);
        if (this.componentName != null) {
            String string = this.componentName;
            Intrinsics.checkNotNull((Object)string);
            componentNames.add(string);
        }
    }

    @Nullable
    public Element getSerializedState(@NotNull StateMap storageData, @Nullable Object component, @NotNull String componentName, boolean archive) {
        Intrinsics.checkNotNullParameter((Object)storageData, (String)"storageData");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.componentName = componentName;
        if (storageData.isEmpty()) {
            return null;
        }
        Element state = new Element("component").setAttribute("name", componentName);
        if (this.splitter instanceof StateSplitterEx) {
            for (String fileName : storageData.keys()) {
                Element subState;
                if (storageData.getState(fileName, archive) == null) {
                    return null;
                }
                ((StateSplitterEx)this.splitter).mergeStateInto(state, subState.clone());
            }
        } else {
            SmartList subElements = new SmartList();
            for (String fileName : storageData.keys()) {
                Element subState;
                if (storageData.getState(fileName, archive) == null) {
                    return null;
                }
                subElements.add((Object)subState.clone());
            }
            if (!subElements.isEmpty()) {
                Collection $this$toTypedArray$iv = (Collection)subElements;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Element[] elementArray = thisCollection$iv.toArray(new Element[0]);
                if (elementArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                this.splitter.mergeStatesInto(state, elementArray);
            }
        }
        return state;
    }

    protected boolean hasState(@NotNull StateMap storageData, @NotNull String componentName) {
        Intrinsics.checkNotNullParameter((Object)storageData, (String)"storageData");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        return storageData.hasStates();
    }

    @NotNull
    protected final StateSplitter getSplitter() {
        return this.splitter;
    }

    @Nullable
    protected final PathMacroSubstitutor getPathMacroSubstitutor() {
        return this.pathMacroSubstitutor;
    }

    public DirectoryBasedStorageBase(@NotNull StateSplitter splitter, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        Intrinsics.checkNotNullParameter((Object)splitter, (String)"splitter");
        this.splitter = splitter;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
    }

    public /* synthetic */ DirectoryBasedStorageBase(StateSplitter stateSplitter, PathMacroSubstitutor pathMacroSubstitutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pathMacroSubstitutor = null;
        }
        this(stateSplitter, pathMacroSubstitutor);
    }
}

