/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.statistic.eventLog;

import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventsKt;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/configurationStore/statistic/eventLog/SettingsComponentNameValidator;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "()V", "acceptRuleId", "", "ruleId", "", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "isComponentName", "intellij.platform.configurationStore.impl"})
public final class SettingsComponentNameValidator
extends CustomValidationRule {
    public boolean acceptRuleId(@Nullable String ruleId) {
        return Intrinsics.areEqual((Object)"component_name", (Object)ruleId) || Intrinsics.areEqual((Object)"option_name", (Object)ruleId);
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isComponentName(data, context)) {
            return FeatureUsageSettingsEventsKt.isComponentNameWhitelisted(data) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
        }
        return FeatureUsageSettingsEventsKt.isComponentOptionNameWhitelisted(data) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
    }

    private final boolean isComponentName(String data, EventContext context) {
        return context.eventData.containsKey("component") && Intrinsics.areEqual((Object)data, context.eventData.get("component"));
    }
}

