/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ArrayReferenceImpl;
import com.jetbrains.jdi.ArrayTypeImpl;
import com.jetbrains.jdi.BooleanTypeImpl;
import com.jetbrains.jdi.BooleanValueImpl;
import com.jetbrains.jdi.ByteTypeImpl;
import com.jetbrains.jdi.ByteValueImpl;
import com.jetbrains.jdi.CharTypeImpl;
import com.jetbrains.jdi.CharValueImpl;
import com.jetbrains.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.jdi.ClassObjectReferenceImpl;
import com.jetbrains.jdi.ClassTypeImpl;
import com.jetbrains.jdi.CommandSender;
import com.jetbrains.jdi.DoubleTypeImpl;
import com.jetbrains.jdi.DoubleValueImpl;
import com.jetbrains.jdi.EventQueueImpl;
import com.jetbrains.jdi.EventRequestManagerImpl;
import com.jetbrains.jdi.FloatTypeImpl;
import com.jetbrains.jdi.FloatValueImpl;
import com.jetbrains.jdi.IntegerTypeImpl;
import com.jetbrains.jdi.IntegerValueImpl;
import com.jetbrains.jdi.InterfaceTypeImpl;
import com.jetbrains.jdi.InternalEventHandler;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.JNITypeParser;
import com.jetbrains.jdi.LongTypeImpl;
import com.jetbrains.jdi.LongValueImpl;
import com.jetbrains.jdi.MirrorImpl;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.Packet;
import com.jetbrains.jdi.PacketStream;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.ShortTypeImpl;
import com.jetbrains.jdi.ShortValueImpl;
import com.jetbrains.jdi.StringReferenceImpl;
import com.jetbrains.jdi.TargetVM;
import com.jetbrains.jdi.ThreadAction;
import com.jetbrains.jdi.ThreadGroupReferenceImpl;
import com.jetbrains.jdi.ThreadListener;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.VMState;
import com.jetbrains.jdi.VirtualMachineManagerImpl;
import com.jetbrains.jdi.VoidTypeImpl;
import com.jetbrains.jdi.VoidValueImpl;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.DoubleType;
import com.sun.jdi.FloatType;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InternalException;
import com.sun.jdi.LongType;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.VoidType;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class VirtualMachineImpl
extends MirrorImpl
implements PathSearchingVirtualMachine,
ThreadListener {
    public final int sizeofFieldRef;
    public final int sizeofMethodRef;
    public final int sizeofObjectRef;
    public final int sizeofClassRef;
    public final int sizeofFrameRef;
    public final int sizeofModuleRef;
    final int sequenceNumber;
    private final TargetVM target;
    private final EventQueueImpl eventQueue;
    private final EventRequestManagerImpl internalEventRequestManager;
    private final EventRequestManagerImpl eventRequestManager;
    final VirtualMachineManagerImpl vmManager;
    private final ThreadGroup threadGroupForJDI;
    int traceFlags = 0;
    static final int TRACE_RAW_SENDS = 0x1000000;
    static final int TRACE_RAW_RECEIVES = 0x2000000;
    boolean traceReceives = false;
    private final AtomicInteger sentPackets = new AtomicInteger();
    private final AtomicInteger waitPackets = new AtomicInteger();
    private final Map<Long, ReferenceType> typesByID = new LinkedHashMap<Long, ReferenceType>(300);
    private final Map<String, List<ReferenceType>> typesBySignature = new HashMap<String, List<ReferenceType>>(300);
    private boolean retrievedAllTypes = false;
    private String defaultStratum = null;
    private final Map<Long, SoftObjectReference> objectsByID = new HashMap<Long, SoftObjectReference>();
    private final ReferenceQueue<ObjectReferenceImpl> referenceQueue = new ReferenceQueue();
    private static final int DISPOSE_THRESHOLD = 50;
    private final List<SoftObjectReference> batchedDisposeRequests = Collections.synchronizedList(new ArrayList(60));
    private JDWP.VirtualMachine.Version versionInfo;
    private JDWP.VirtualMachine.ClassPaths pathInfo;
    private JDWP.VirtualMachine.Capabilities capabilities = null;
    private JDWP.VirtualMachine.CapabilitiesNew capabilitiesNew = null;
    private final BooleanType theBooleanType;
    private final ByteType theByteType;
    private final CharType theCharType;
    private final ShortType theShortType;
    private final IntegerType theIntegerType;
    private final LongType theLongType;
    private final FloatType theFloatType;
    private final DoubleType theDoubleType;
    private final VoidType theVoidType;
    private final VoidValueImpl voidVal;
    private final BooleanValueImpl trueValue;
    private final BooleanValueImpl falseValue;
    private final ByteValueImpl[] byteValues = new ByteValueImpl[256];
    private final Process process;
    private final VMState state = new VMState(this);
    private final Object initMonitor = new Object();
    private boolean initComplete = false;
    private boolean shutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInitCompletion() {
        Object object = this.initMonitor;
        synchronized (object) {
            this.initComplete = true;
            this.initMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitInitCompletion() {
        Object object = this.initMonitor;
        synchronized (object) {
            while (!this.initComplete) {
                try {
                    this.initMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    VMState state() {
        return this.state;
    }

    @Override
    public boolean threadResumable(ThreadAction action) {
        this.state.thaw(action.thread());
        return true;
    }

    VirtualMachineImpl(VirtualMachineManager manager, Connection connection, Process process, int sequenceNumber) {
        super(null);
        JDWP.VirtualMachine.IDSizes idSizes;
        this.vm = this;
        this.vmManager = (VirtualMachineManagerImpl)manager;
        this.process = process;
        this.sequenceNumber = sequenceNumber;
        this.threadGroupForJDI = new ThreadGroup(this.vmManager.mainGroupForJDI(), "JDI [" + this.hashCode() + "]");
        this.target = new TargetVM(this, connection);
        EventQueueImpl internalEventQueue = new EventQueueImpl(this, this.target);
        new InternalEventHandler(this, internalEventQueue);
        this.eventQueue = new EventQueueImpl(this, this.target);
        this.eventRequestManager = new EventRequestManagerImpl(this);
        this.target.start();
        try {
            idSizes = JDWP.VirtualMachine.IDSizes.process(this.vm);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        this.sizeofFieldRef = idSizes.fieldIDSize;
        this.sizeofMethodRef = idSizes.methodIDSize;
        this.sizeofObjectRef = idSizes.objectIDSize;
        this.sizeofClassRef = idSizes.referenceTypeIDSize;
        this.sizeofFrameRef = idSizes.frameIDSize;
        this.sizeofModuleRef = idSizes.objectIDSize;
        this.internalEventRequestManager = new EventRequestManagerImpl(this);
        EventRequest er = this.internalEventRequestManager.createClassPrepareRequest();
        er.setSuspendPolicy(0);
        er.enable();
        er = this.internalEventRequestManager.createClassUnloadRequest();
        er.setSuspendPolicy(0);
        er.enable();
        this.theBooleanType = new BooleanTypeImpl(this);
        this.theByteType = new ByteTypeImpl(this);
        this.theCharType = new CharTypeImpl(this);
        this.theShortType = new ShortTypeImpl(this);
        this.theIntegerType = new IntegerTypeImpl(this);
        this.theLongType = new LongTypeImpl(this);
        this.theFloatType = new FloatTypeImpl(this);
        this.theDoubleType = new DoubleTypeImpl(this);
        this.theVoidType = new VoidTypeImpl(this);
        this.voidVal = new VoidValueImpl(this);
        this.trueValue = new BooleanValueImpl(this, true);
        this.falseValue = new BooleanValueImpl(this, false);
        this.notifyInitCompletion();
    }

    VirtualMachineImpl(Packet idSizesPacket) {
        super(null);
        JDWP.VirtualMachine.IDSizes idSizes;
        this.vm = this;
        this.vmManager = null;
        this.process = null;
        this.sequenceNumber = -1;
        this.threadGroupForJDI = null;
        this.target = null;
        this.eventQueue = null;
        this.eventRequestManager = null;
        this.internalEventRequestManager = null;
        assert (idSizesPacket.cmdSet == 1 && idSizesPacket.cmd == 7);
        try {
            idSizes = JDWP.VirtualMachine.IDSizes.waitForReply(this, new PacketStream(null, idSizesPacket));
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        this.sizeofFieldRef = idSizes.fieldIDSize;
        this.sizeofMethodRef = idSizes.methodIDSize;
        this.sizeofObjectRef = idSizes.objectIDSize;
        this.sizeofClassRef = idSizes.referenceTypeIDSize;
        this.sizeofFrameRef = idSizes.frameIDSize;
        this.sizeofModuleRef = idSizes.objectIDSize;
        this.theBooleanType = new BooleanTypeImpl(this);
        this.theByteType = new ByteTypeImpl(this);
        this.theCharType = new CharTypeImpl(this);
        this.theShortType = new ShortTypeImpl(this);
        this.theIntegerType = new IntegerTypeImpl(this);
        this.theLongType = new LongTypeImpl(this);
        this.theFloatType = new FloatTypeImpl(this);
        this.theDoubleType = new DoubleTypeImpl(this);
        this.theVoidType = new VoidTypeImpl(this);
        this.voidVal = new VoidValueImpl(this);
        this.trueValue = new BooleanValueImpl(this, true);
        this.falseValue = new BooleanValueImpl(this, false);
    }

    EventRequestManagerImpl getInternalEventRequestManager() {
        return this.internalEventRequestManager;
    }

    void validateVM() {
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public List<ReferenceType> classesByName(String className) {
        this.validateVM();
        return this.classesBySignature(JNITypeParser.typeNameToSignature(className));
    }

    List<ReferenceType> classesBySignature(String signature) {
        this.validateVM();
        List<ReferenceType> list = this.retrievedAllTypes ? this.findReferenceTypes(signature) : this.retrieveClassesBySignature(signature);
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReferenceType> allClasses() {
        ArrayList<ReferenceType> a;
        this.validateVM();
        if (!this.retrievedAllTypes) {
            this.retrieveAllClasses();
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            a = new ArrayList<ReferenceType>(this.typesByID.values());
        }
        return Collections.unmodifiableList(a);
    }

    public void forEachClass(Consumer<ReferenceType> action) {
        for (ReferenceType type : this.allClasses()) {
            try {
                action.accept(type);
            }
            catch (ObjectCollectedException ex) {
                if ((this.vm.traceFlags & 0x10) == 0) continue;
                this.vm.printTrace("ObjectCollectedException was thrown while accessing unloaded class " + type.name());
            }
        }
    }

    @Override
    public void redefineClasses(Map<? extends ReferenceType, byte[]> classToBytes) {
        int cnt = classToBytes.size();
        JDWP.VirtualMachine.RedefineClasses.ClassDef[] defs = new JDWP.VirtualMachine.RedefineClasses.ClassDef[cnt];
        this.validateVM();
        if (!this.canRedefineClasses()) {
            throw new UnsupportedOperationException();
        }
        Iterator<Object> it = classToBytes.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<? extends ReferenceType, byte[]> entry = it.next();
            ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)entry.getKey();
            this.validateMirror(referenceTypeImpl);
            defs[i] = new JDWP.VirtualMachine.RedefineClasses.ClassDef(referenceTypeImpl, entry.getValue());
            ++i;
        }
        this.vm.state().thaw();
        try {
            JDWP.VirtualMachine.RedefineClasses.process(this.vm, defs);
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 60: {
                    throw new ClassFormatError("class not in class file format");
                }
                case 61: {
                    throw new ClassCircularityError("circularity has been detected while initializing a class");
                }
                case 62: {
                    throw new VerifyError("verifier detected internal inconsistency or security problem");
                }
                case 68: {
                    throw new UnsupportedClassVersionError("version numbers of class are not supported");
                }
                case 63: {
                    throw new UnsupportedOperationException("add method not implemented");
                }
                case 64: {
                    throw new UnsupportedOperationException("schema change not implemented");
                }
                case 66: {
                    throw new UnsupportedOperationException("hierarchy change not implemented");
                }
                case 67: {
                    throw new UnsupportedOperationException("delete method not implemented");
                }
                case 70: {
                    throw new UnsupportedOperationException("changes to class modifiers not implemented");
                }
                case 71: {
                    throw new UnsupportedOperationException("changes to method modifiers not implemented");
                }
                case 72: {
                    throw new UnsupportedOperationException("changes to class attribute not implemented");
                }
                case 69: {
                    throw new NoClassDefFoundError("class names do not match");
                }
            }
            throw exc.toJDIException();
        }
        ArrayList<BreakpointRequest> toDelete = new ArrayList<BreakpointRequest>();
        EventRequestManager erm = this.eventRequestManager();
        for (BreakpointRequest breakpointRequest : erm.breakpointRequests()) {
            if (!classToBytes.containsKey(breakpointRequest.location().declaringType())) continue;
            toDelete.add(breakpointRequest);
        }
        erm.deleteEventRequests(toDelete);
        for (ReferenceTypeImpl referenceTypeImpl : classToBytes.keySet()) {
            referenceTypeImpl.noticeRedefineClass();
        }
    }

    @Override
    public List<ThreadReference> allThreads() {
        this.validateVM();
        return this.state.allThreads();
    }

    @Override
    public List<ThreadGroupReference> topLevelThreadGroups() {
        this.validateVM();
        return this.state.topLevelThreadGroups();
    }

    PacketStream sendResumingCommand(CommandSender sender) {
        return this.state.thawCommand(sender);
    }

    void notifySuspend() {
        this.state.freeze();
    }

    @Override
    public void suspend() {
        this.validateVM();
        try {
            JDWP.VirtualMachine.Suspend.process(this.vm);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        this.notifySuspend();
    }

    @Override
    public void resume() {
        this.validateVM();
        try {
            PacketStream stream = this.state.thawCommand(() -> JDWP.VirtualMachine.Resume.enqueueCommand(this.vm));
            JDWP.VirtualMachine.Resume.waitForReply(this.vm, stream);
        }
        catch (VMDisconnectedException stream) {
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 112: {
                    return;
                }
            }
            throw exc.toJDIException();
        }
    }

    @Override
    public EventQueue eventQueue() {
        return this.eventQueue;
    }

    @Override
    public EventRequestManager eventRequestManager() {
        this.validateVM();
        return this.eventRequestManager;
    }

    EventRequestManagerImpl eventRequestManagerImpl() {
        return this.eventRequestManager;
    }

    @Override
    public BooleanValueImpl mirrorOf(boolean value) {
        this.validateVM();
        return value ? this.trueValue : this.falseValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteValueImpl mirrorOf(byte value) {
        this.validateVM();
        ByteValueImpl[] byteValueImplArray = this.byteValues;
        synchronized (this.byteValues) {
            ByteValueImpl res = this.byteValues[value & 0xFF];
            if (res == null) {
                this.byteValues[value & 0xFF] = res = new ByteValueImpl(this, value);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return res;
        }
    }

    @Override
    public CharValueImpl mirrorOf(char value) {
        this.validateVM();
        return new CharValueImpl(this, value);
    }

    @Override
    public ShortValueImpl mirrorOf(short value) {
        this.validateVM();
        return new ShortValueImpl(this, value);
    }

    @Override
    public IntegerValueImpl mirrorOf(int value) {
        this.validateVM();
        return new IntegerValueImpl(this, value);
    }

    @Override
    public LongValueImpl mirrorOf(long value) {
        this.validateVM();
        return new LongValueImpl(this, value);
    }

    @Override
    public FloatValueImpl mirrorOf(float value) {
        this.validateVM();
        return new FloatValueImpl(this, value);
    }

    @Override
    public DoubleValueImpl mirrorOf(double value) {
        this.validateVM();
        return new DoubleValueImpl(this, value);
    }

    @Override
    public StringReferenceImpl mirrorOf(String value) {
        this.validateVM();
        try {
            return JDWP.VirtualMachine.CreateString.process((VirtualMachineImpl)this.vm, (String)value).stringObject;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public VoidValueImpl mirrorOfVoid() {
        return this.voidVal;
    }

    @Override
    public long[] instanceCounts(List<? extends ReferenceType> classes) {
        long[] retValue;
        if (!this.canGetInstanceInfo()) {
            throw new UnsupportedOperationException("target does not support getting instances");
        }
        ReferenceTypeImpl[] rtArray = new ReferenceTypeImpl[classes.size()];
        int ii = 0;
        for (ReferenceType referenceType : classes) {
            this.validateMirror(referenceType);
            rtArray[ii++] = (ReferenceTypeImpl)referenceType;
        }
        try {
            retValue = JDWP.VirtualMachine.InstanceCounts.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl[])rtArray).counts;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return retValue;
    }

    @Override
    public void dispose() {
        this.validateVM();
        this.shutdown = true;
        try {
            JDWP.VirtualMachine.Dispose.process(this.vm);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        this.target.stopListening();
    }

    @Override
    public void exit(int exitCode) {
        this.validateVM();
        this.shutdown = true;
        try {
            JDWP.VirtualMachine.Exit.process(this.vm, exitCode);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        this.target.stopListening();
    }

    @Override
    public Process process() {
        this.validateVM();
        return this.process;
    }

    private JDWP.VirtualMachine.Version versionInfo() {
        try {
            if (this.versionInfo == null) {
                this.versionInfo = JDWP.VirtualMachine.Version.process(this.vm);
            }
            return this.versionInfo;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public String description() {
        this.validateVM();
        return MessageFormat.format(this.vmManager.getString("version_format"), "" + this.vmManager.majorInterfaceVersion(), "" + this.vmManager.minorInterfaceVersion(), this.versionInfo().description);
    }

    @Override
    public String version() {
        this.validateVM();
        return this.versionInfo().vmVersion;
    }

    @Override
    public String name() {
        this.validateVM();
        return this.versionInfo().vmName;
    }

    @Override
    public boolean canWatchFieldModification() {
        this.validateVM();
        return this.capabilities().canWatchFieldModification;
    }

    @Override
    public boolean canWatchFieldAccess() {
        this.validateVM();
        return this.capabilities().canWatchFieldAccess;
    }

    @Override
    public boolean canGetBytecodes() {
        this.validateVM();
        return this.capabilities().canGetBytecodes;
    }

    @Override
    public boolean canGetSyntheticAttribute() {
        this.validateVM();
        return this.capabilities().canGetSyntheticAttribute;
    }

    @Override
    public boolean canGetOwnedMonitorInfo() {
        this.validateVM();
        return this.capabilities().canGetOwnedMonitorInfo;
    }

    @Override
    public boolean canGetCurrentContendedMonitor() {
        this.validateVM();
        return this.capabilities().canGetCurrentContendedMonitor;
    }

    @Override
    public boolean canGetMonitorInfo() {
        this.validateVM();
        return this.capabilities().canGetMonitorInfo;
    }

    private boolean hasNewCapabilities() {
        return this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 4;
    }

    boolean canGet1_5LanguageFeatures() {
        return this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 5;
    }

    @Override
    public boolean canUseInstanceFilters() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canUseInstanceFilters;
    }

    @Override
    public boolean canRedefineClasses() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canRedefineClasses;
    }

    @Override
    @Deprecated
    public boolean canAddMethod() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canAddMethod;
    }

    @Override
    @Deprecated
    public boolean canUnrestrictedlyRedefineClasses() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canUnrestrictedlyRedefineClasses;
    }

    @Override
    public boolean canPopFrames() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canPopFrames;
    }

    @Override
    public boolean canGetMethodReturnValues() {
        return this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 6;
    }

    @Override
    public boolean canGetInstanceInfo() {
        if (this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 6) {
            this.validateVM();
            return this.hasNewCapabilities() && this.capabilitiesNew().canGetInstanceInfo;
        }
        return false;
    }

    @Override
    public boolean canUseSourceNameFilters() {
        return this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 6;
    }

    @Override
    public boolean canForceEarlyReturn() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canForceEarlyReturn;
    }

    @Override
    public boolean canBeModified() {
        return true;
    }

    @Override
    public boolean canGetSourceDebugExtension() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canGetSourceDebugExtension;
    }

    @Override
    public boolean canGetClassFileVersion() {
        return this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 6;
    }

    @Override
    public boolean canGetConstantPool() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canGetConstantPool;
    }

    @Override
    public boolean canRequestVMDeathEvent() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canRequestVMDeathEvent;
    }

    @Override
    public boolean canRequestMonitorEvents() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canRequestMonitorEvents;
    }

    @Override
    public boolean canGetMonitorFrameInfo() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canGetMonitorFrameInfo;
    }

    @Override
    public boolean canGetModuleInfo() {
        this.validateVM();
        return this.versionInfo().jdwpMajor >= 9;
    }

    @Override
    public void setDebugTraceMode(int traceFlags) {
        this.validateVM();
        this.traceFlags = traceFlags;
        this.traceReceives = (traceFlags & 2) != 0;
    }

    void printTrace(String string) {
        System.err.println("[JDI: " + string + "]");
    }

    void printReceiveTrace(int depth, String string) {
        StringBuilder sb = new StringBuilder("Receiving:");
        for (int i = depth; i > 0; --i) {
            sb.append("    ");
        }
        sb.append(string);
        this.printTrace(sb.toString());
    }

    private synchronized ReferenceTypeImpl addReferenceType(long id, int tag, String signature) {
        ReferenceTypeImpl type;
        switch (tag) {
            case 1: {
                type = new ClassTypeImpl(this.vm, id);
                break;
            }
            case 2: {
                type = new InterfaceTypeImpl(this.vm, id);
                break;
            }
            case 3: {
                type = new ArrayTypeImpl(this.vm, id);
                break;
            }
            default: {
                throw new InternalException("Invalid reference type tag");
            }
        }
        if (signature == null && this.retrievedAllTypes) {
            return type;
        }
        this.typesByID.put(id, type);
        if (signature != null) {
            type.setSignature(signature);
        }
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Caching new ReferenceType, sig=" + signature + ", id=" + id);
        }
        return type;
    }

    void cacheTypeBySignature(ReferenceTypeImpl type, String signature) {
        this.typesBySignature.computeIfAbsent(signature, s -> new ArrayList(1)).add(type);
    }

    synchronized void removeReferenceType(String signature) {
        List<ReferenceType> referenceTypes = this.typesBySignature.remove(signature);
        if (referenceTypes != null) {
            for (ReferenceType t : referenceTypes) {
                ReferenceTypeImpl type = (ReferenceTypeImpl)t;
                this.typesByID.remove(type.ref());
                this.state.referenceTypeRemoved(type);
                if ((this.vm.traceFlags & 8) == 0) continue;
                this.vm.printTrace("Uncaching ReferenceType, sig=" + signature + ", id=" + type.ref());
            }
            if (referenceTypes.size() > 1) {
                this.retrieveClassesBySignature(signature);
            }
        }
    }

    private synchronized List<ReferenceType> findReferenceTypes(String signature) {
        List<ReferenceType> res = this.typesBySignature.get(signature);
        return res != null ? res : Collections.emptyList();
    }

    ReferenceTypeImpl referenceType(long ref, byte tag) {
        return this.referenceType(ref, tag, null);
    }

    ClassTypeImpl classType(long ref) {
        return (ClassTypeImpl)this.referenceType(ref, 1, null);
    }

    InterfaceTypeImpl interfaceType(long ref) {
        return (InterfaceTypeImpl)this.referenceType(ref, 2, null);
    }

    ArrayTypeImpl arrayType(long ref) {
        return (ArrayTypeImpl)this.referenceType(ref, 3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceTypeImpl referenceType(long id, int tag, String signature) {
        ReferenceTypeImpl retType;
        if ((this.vm.traceFlags & 8) != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Looking up ");
            if (tag == 1) {
                sb.append("Class");
            } else if (tag == 2) {
                sb.append("Interface");
            } else if (tag == 3) {
                sb.append("ArrayType");
            } else {
                sb.append("UNKNOWN TAG: ").append(tag);
            }
            if (signature != null) {
                sb.append(", signature='").append(signature).append('\'');
            }
            sb.append(", id=").append(id);
            this.vm.printTrace(sb.toString());
        }
        if (id == 0L) {
            return null;
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            retType = (ReferenceTypeImpl)this.typesByID.get(id);
            if (retType == null) {
                retType = this.addReferenceType(id, tag, signature);
            } else if (signature != null) {
                retType.setSignature(signature);
            }
        }
        return retType;
    }

    private JDWP.VirtualMachine.Capabilities capabilities() {
        if (this.capabilities == null) {
            try {
                this.capabilities = JDWP.VirtualMachine.Capabilities.process(this.vm);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.capabilities;
    }

    private JDWP.VirtualMachine.CapabilitiesNew capabilitiesNew() {
        if (this.capabilitiesNew == null) {
            try {
                this.capabilitiesNew = JDWP.VirtualMachine.CapabilitiesNew.process(this.vm);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.capabilitiesNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReferenceType> retrieveClassesBySignature(String signature) {
        JDWP.VirtualMachine.ClassesBySignature.ClassInfo[] cinfos;
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Retrieving matching ReferenceTypes, sig=" + signature);
        }
        try {
            cinfos = JDWP.VirtualMachine.ClassesBySignature.process((VirtualMachineImpl)this.vm, (String)signature).classes;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        int count = cinfos.length;
        ArrayList<ReferenceType> list = new ArrayList<ReferenceType>(count);
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            for (JDWP.VirtualMachine.ClassesBySignature.ClassInfo ci : cinfos) {
                ReferenceTypeImpl type = this.referenceType(ci.typeID, ci.refTypeTag, signature);
                type.setStatus(ci.status);
                list.add(type);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveAllClasses1_4() {
        JDWP.VirtualMachine.AllClasses.ClassInfo[] cinfos;
        try {
            cinfos = JDWP.VirtualMachine.AllClasses.process((VirtualMachineImpl)this.vm).classes;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (!this.retrievedAllTypes) {
                int count = cinfos.length;
                for (JDWP.VirtualMachine.AllClasses.ClassInfo ci : cinfos) {
                    ReferenceTypeImpl type = this.referenceType(ci.typeID, ci.refTypeTag, ci.signature);
                    type.setStatus(ci.status);
                }
                this.retrievedAllTypes = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveAllClasses() {
        JDWP.VirtualMachine.AllClassesWithGeneric.ClassInfo[] cinfos;
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Retrieving all ReferenceTypes");
        }
        if (!this.vm.canGet1_5LanguageFeatures()) {
            this.retrieveAllClasses1_4();
            return;
        }
        try {
            cinfos = JDWP.VirtualMachine.AllClassesWithGeneric.process((VirtualMachineImpl)this.vm).classes;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (!this.retrievedAllTypes) {
                int count = cinfos.length;
                for (JDWP.VirtualMachine.AllClassesWithGeneric.ClassInfo ci : cinfos) {
                    ReferenceTypeImpl type = this.referenceType(ci.typeID, ci.refTypeTag, ci.signature);
                    type.setGenericSignature(ci.genericSignature);
                    type.setStatus(ci.status);
                }
                this.retrievedAllTypes = true;
            }
        }
    }

    void sendToTarget(Packet packet) {
        this.sentPackets.incrementAndGet();
        this.target.send(packet);
    }

    void waitForTargetReply(Packet packet) {
        this.waitPackets.incrementAndGet();
        this.target.waitForReply(packet);
        this.processBatchedDisposes();
    }

    Type findBootType(String signature) throws ClassNotLoadedException {
        for (ReferenceType type : this.classesBySignature(signature)) {
            if (type.classLoader() != null) continue;
            return type;
        }
        for (ReferenceType type : this.retrieveClassesBySignature(signature)) {
            if (type.classLoader() != null) continue;
            return type;
        }
        JNITypeParser parser = new JNITypeParser(signature);
        throw new ClassNotLoadedException(parser.typeName(), "Type " + parser.typeName() + " not loaded");
    }

    BooleanType theBooleanType() {
        return this.theBooleanType;
    }

    ByteType theByteType() {
        return this.theByteType;
    }

    CharType theCharType() {
        return this.theCharType;
    }

    ShortType theShortType() {
        return this.theShortType;
    }

    IntegerType theIntegerType() {
        return this.theIntegerType;
    }

    LongType theLongType() {
        return this.theLongType;
    }

    FloatType theFloatType() {
        return this.theFloatType;
    }

    DoubleType theDoubleType() {
        return this.theDoubleType;
    }

    VoidType theVoidType() {
        return this.theVoidType;
    }

    PrimitiveType primitiveTypeMirror(byte tag) {
        switch (tag) {
            case 90: {
                return this.theBooleanType();
            }
            case 66: {
                return this.theByteType();
            }
            case 67: {
                return this.theCharType();
            }
            case 83: {
                return this.theShortType();
            }
            case 73: {
                return this.theIntegerType();
            }
            case 74: {
                return this.theLongType();
            }
            case 70: {
                return this.theFloatType();
            }
            case 68: {
                return this.theDoubleType();
            }
        }
        throw new IllegalArgumentException("Unrecognized primitive tag " + tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBatchedDisposes() {
        if (this.shutdown) {
            return;
        }
        JDWP.VirtualMachine.DisposeObjects.Request[] requests = null;
        List<SoftObjectReference> list = this.batchedDisposeRequests;
        synchronized (list) {
            int size = this.batchedDisposeRequests.size();
            if (size >= 50) {
                if ((this.traceFlags & 0x10) != 0) {
                    this.printTrace("Dispose threashold reached. Will dispose " + size + " object references...");
                }
                requests = new JDWP.VirtualMachine.DisposeObjects.Request[size];
                for (int i = 0; i < requests.length; ++i) {
                    SoftObjectReference ref = this.batchedDisposeRequests.get(i);
                    if ((this.traceFlags & 0x10) != 0) {
                        this.printTrace("Disposing object " + ref.key() + " (ref count = " + ref.count() + ")");
                    }
                    requests[i] = new JDWP.VirtualMachine.DisposeObjects.Request(new ObjectReferenceImpl(this, ref.key()), ref.count());
                }
                this.batchedDisposeRequests.clear();
            }
        }
        if (requests != null) {
            try {
                JDWP.VirtualMachine.DisposeObjects.process(this.vm, requests);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
    }

    private void batchForDispose(SoftObjectReference ref) {
        if ((this.traceFlags & 0x10) != 0) {
            this.printTrace("Batching object " + ref.key() + " for dispose (ref count = " + ref.count() + ")");
        }
        this.batchedDisposeRequests.add(ref);
    }

    private void processQueue() {
        Reference<ObjectReferenceImpl> ref;
        while ((ref = this.referenceQueue.poll()) != null) {
            SoftObjectReference softRef = (SoftObjectReference)ref;
            this.removeObjectMirror(softRef);
            this.batchForDispose(softRef);
        }
    }

    synchronized ObjectReferenceImpl objectMirror(long id, int tag) {
        this.processQueue();
        if (id == 0L) {
            return null;
        }
        ObjectReferenceImpl object = null;
        Long key = id;
        SoftObjectReference ref = this.objectsByID.get(key);
        if (ref != null) {
            object = ref.object();
        }
        if (object == null) {
            switch (tag) {
                case 76: {
                    object = new ObjectReferenceImpl(this.vm, id);
                    break;
                }
                case 115: {
                    object = new StringReferenceImpl(this.vm, id);
                    break;
                }
                case 91: {
                    object = new ArrayReferenceImpl(this.vm, id);
                    break;
                }
                case 116: {
                    ThreadReferenceImpl thread = new ThreadReferenceImpl(this.vm, id);
                    thread.addListener(this);
                    object = thread;
                    break;
                }
                case 103: {
                    object = new ThreadGroupReferenceImpl(this.vm, id);
                    break;
                }
                case 108: {
                    object = new ClassLoaderReferenceImpl(this.vm, id);
                    break;
                }
                case 99: {
                    object = new ClassObjectReferenceImpl(this.vm, id);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid object tag: " + tag);
                }
            }
            ref = new SoftObjectReference(key, object, this.referenceQueue);
            this.objectsByID.put(key, ref);
            if ((this.traceFlags & 0x10) != 0) {
                this.printTrace("Creating new " + object.getClass().getName() + " (id = " + id + ")");
            }
        } else {
            ref.incrementCount();
        }
        return object;
    }

    synchronized void removeObjectMirror(ObjectReferenceImpl object) {
        this.processQueue();
        SoftObjectReference ref = this.objectsByID.remove(object.ref());
        if (ref == null) {
            throw new InternalException("ObjectReference " + object.ref() + " not found in object cache");
        }
        this.batchForDispose(ref);
    }

    synchronized void removeObjectMirror(SoftObjectReference ref) {
        this.objectsByID.remove(ref.key());
    }

    ObjectReferenceImpl objectMirror(long id) {
        return this.objectMirror(id, 76);
    }

    StringReferenceImpl stringMirror(long id) {
        return (StringReferenceImpl)this.objectMirror(id, 115);
    }

    ArrayReferenceImpl arrayMirror(long id) {
        return (ArrayReferenceImpl)this.objectMirror(id, 91);
    }

    ThreadReferenceImpl threadMirror(long id) {
        return (ThreadReferenceImpl)this.objectMirror(id, 116);
    }

    ThreadGroupReferenceImpl threadGroupMirror(long id) {
        return (ThreadGroupReferenceImpl)this.objectMirror(id, 103);
    }

    ClassLoaderReferenceImpl classLoaderMirror(long id) {
        return (ClassLoaderReferenceImpl)this.objectMirror(id, 108);
    }

    ClassObjectReferenceImpl classObjectMirror(long id) {
        return (ClassObjectReferenceImpl)this.objectMirror(id, 99);
    }

    private JDWP.VirtualMachine.ClassPaths getClasspath() {
        if (this.pathInfo == null) {
            try {
                this.pathInfo = JDWP.VirtualMachine.ClassPaths.process(this.vm);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.pathInfo;
    }

    @Override
    public List<String> classPath() {
        return Arrays.asList(this.getClasspath().classpaths);
    }

    @Override
    public List<String> bootClassPath() {
        return Collections.emptyList();
    }

    @Override
    public String baseDirectory() {
        return this.getClasspath().baseDir;
    }

    @Override
    public void setDefaultStratum(String stratum) {
        this.defaultStratum = stratum;
        if (stratum == null) {
            stratum = "";
        }
        try {
            JDWP.VirtualMachine.SetDefaultStratum.process(this.vm, stratum);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public String getDefaultStratum() {
        return this.defaultStratum;
    }

    ThreadGroup threadGroupForJDI() {
        return this.threadGroupForJDI;
    }

    public int getSentPacketsNumber() {
        return this.sentPackets.get();
    }

    public int getWaitPacketsNumber() {
        return this.waitPackets.get();
    }

    public boolean isIdle() {
        return this.target.isIdle();
    }

    public CompletableFuture<Long> measureLatency() {
        return this.target.measureLatency();
    }

    TargetVM targetVM() {
        return this.target;
    }

    private static class SoftObjectReference
    extends SoftReference<ObjectReferenceImpl> {
        int count = 1;
        final Long key;

        SoftObjectReference(Long key, ObjectReferenceImpl mirror, ReferenceQueue<ObjectReferenceImpl> queue) {
            super(mirror, queue);
            this.key = key;
        }

        int count() {
            return this.count;
        }

        void incrementCount() {
            ++this.count;
        }

        Long key() {
            return this.key;
        }

        ObjectReferenceImpl object() {
            return (ObjectReferenceImpl)this.get();
        }
    }
}

