/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.execution.ExecutionHandler;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.BuildTask;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTarget
implements AntBuildTargetBase {
    private final AntBuildFileBase myBuildFile;
    private final List<String> myTargets;
    @Nls
    private final String myName;
    @Nls
    private final String myDescription;

    public MetaTarget(AntBuildFileBase buildFile, @Nls String displayName, List<String> targets) {
        this.myBuildFile = buildFile;
        this.myTargets = targets;
        this.myName = displayName;
        this.myDescription = AntBundle.message("meta.target.build.sequence.name.display.name", displayName);
    }

    @Override
    public Project getProject() {
        return this.myBuildFile.getProject();
    }

    public AntBuildFile getBuildFile() {
        return this.myBuildFile;
    }

    @Override
    public @NotNull List<@NlsSafe String> getTargetNames() {
        List<String> list = this.myTargets;
        if (list == null) {
            MetaTarget.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NlsSafe
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    @NlsSafe
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getNotEmptyDescription() {
        return this.myDescription;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    @NonNls
    public String getActionId() {
        String modelName = this.myBuildFile.getModel().getName();
        if (modelName == null || modelName.length() == 0) {
            return null;
        }
        return AntConfiguration.getActionIdPrefix(this.myBuildFile.getProject()) + "_" + modelName + "_" + this.getName();
    }

    @Override
    public AntBuildModelBase getModel() {
        return this.myBuildFile.getModel();
    }

    @Override
    @Nullable
    public Navigatable getOpenFileDescriptor() {
        return null;
    }

    @Override
    @Nullable
    public BuildTask findTask(String taskName) {
        return null;
    }

    @Override
    public void run(DataContext dataContext, List<BuildFileProperty> additionalProperties, AntBuildListener buildListener) {
        ExecutionHandler.runBuild(this.myBuildFile, this.myTargets, null, dataContext, additionalProperties, buildListener);
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        return this.myBuildFile.getVirtualFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaTarget that = (MetaTarget)o;
        if (!this.myBuildFile.equals(that.myBuildFile)) {
            return false;
        }
        return Comparing.equal(this.myTargets, that.myTargets);
    }

    public int hashCode() {
        int code = this.myBuildFile.hashCode();
        for (String name : this.myTargets) {
            code += name.hashCode();
        }
        return code;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/impl/MetaTarget", "getTargetNames"));
    }
}

