/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.xml.util.XmlStringUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.highlighter.Diagnostic2Annotation$WhenMappings;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/Diagnostic2Annotation;", "", "()V", "createAnnotation", "Lcom/intellij/lang/annotation/Annotation;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "range", "Lcom/intellij/openapi/util/TextRange;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "nonDefaultMessage", "", "textAttributes", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "renderMessage", "Lkotlin/Function1;", "getDefaultMessage", "getHtmlMessage", "kotlin.fir.frontend-independent"})
public final class Diagnostic2Annotation {
    public static final Diagnostic2Annotation INSTANCE;

    @NotNull
    public final String getHtmlMessage(@NotNull Diagnostic diagnostic, @NotNull Function1<? super Diagnostic, String> renderMessage) {
        String message;
        block8: {
            String string;
            block7: {
                Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                Intrinsics.checkNotNullParameter(renderMessage, (String)"renderMessage");
                message = (String)renderMessage.invoke((Object)diagnostic);
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isInternal()) break block7;
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
                if (!application2.isUnitTestMode()) break block8;
            }
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            Intrinsics.checkNotNullExpressionValue((Object)diagnosticFactory, (String)"diagnostic.factory");
            String string2 = diagnosticFactory.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"diagnostic.factory.name");
            String factoryName = string2;
            if (StringsKt.startsWith$default((String)message, (String)"<html>", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append("<html>[").append(factoryName).append("] ");
                String string3 = message;
                int n = "<html>".length();
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                string = stringBuilder.append(string5).toString();
            } else {
                string = message = '[' + factoryName + "] " + message;
            }
        }
        if (!StringsKt.startsWith$default((String)message, (String)"<html>", (boolean)false, (int)2, null)) {
            message = "<html><body>" + XmlStringUtil.escapeString((String)message) + "</body></html>";
        }
        return message;
    }

    @NotNull
    public final String getDefaultMessage(@NotNull Diagnostic diagnostic) {
        String message;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                String string = DefaultErrorMessages.render((Diagnostic)diagnostic);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DefaultErrorMessages.render(diagnostic)");
                message = string;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isInternal()) break block2;
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
                if (!application2.isUnitTestMode()) break block3;
            }
            StringBuilder stringBuilder = new StringBuilder().append('[');
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            Intrinsics.checkNotNullExpressionValue((Object)diagnosticFactory, (String)"diagnostic.factory");
            return stringBuilder.append(diagnosticFactory.getName()).append("] ").append(message).toString();
        }
        return message;
    }

    @NotNull
    public final Annotation createAnnotation(@NotNull Diagnostic diagnostic, @NotNull TextRange range, @NotNull AnnotationHolder holder, @Nullable String nonDefaultMessage, @Nullable TextAttributesKey textAttributes, @Nullable ProblemHighlightType highlightType, @NotNull Function1<? super Diagnostic, String> renderMessage) {
        Annotation annotation;
        Annotation annotation2;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter(renderMessage, (String)"renderMessage");
        String string = nonDefaultMessage;
        if (string == null) {
            string = this.getDefaultMessage(diagnostic);
        }
        String defaultMessage = string;
        switch (Diagnostic2Annotation$WhenMappings.$EnumSwitchMapping$0[diagnostic.getSeverity().ordinal()]) {
            case 1: {
                annotation2 = holder.createErrorAnnotation(range, defaultMessage);
                break;
            }
            case 2: {
                if (highlightType == ProblemHighlightType.WEAK_WARNING) {
                    annotation2 = holder.createWeakWarningAnnotation(range, defaultMessage);
                    break;
                }
                annotation2 = holder.createWarningAnnotation(range, defaultMessage);
                break;
            }
            case 3: {
                annotation2 = holder.createInfoAnnotation(range, defaultMessage);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Annotation annotation3 = annotation = annotation2;
        Intrinsics.checkNotNullExpressionValue((Object)annotation3, (String)"annotation");
        annotation3.setTooltip(this.getHtmlMessage(diagnostic, renderMessage));
        if (highlightType != null) {
            annotation.setHighlightType(highlightType);
        }
        if (textAttributes != null) {
            annotation.setTextAttributes(textAttributes);
        }
        return annotation;
    }

    private Diagnostic2Annotation() {
    }

    static {
        Diagnostic2Annotation diagnostic2Annotation;
        INSTANCE = diagnostic2Annotation = new Diagnostic2Annotation();
    }
}

