/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.references.AbstractKtReference;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtDestructuringDeclarationReference;", "Lorg/jetbrains/kotlin/idea/references/AbstractKtReference;", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "element", "(Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;)V", "resolvesByNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getResolvesByNames", "()Ljava/util/Collection;", "canRename", "", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "handleElementRename", "Lcom/intellij/psi/PsiElement;", "newElementName", "", "kotlin.fir.frontend-independent"})
public abstract class KtDestructuringDeclarationReference
extends AbstractKtReference<KtDestructuringDeclarationEntry> {
    @NotNull
    public TextRange getRangeInElement() {
        KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = (KtDestructuringDeclarationEntry)this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktDestructuringDeclarationEntry, (String)"element");
        return new TextRange(0, ktDestructuringDeclarationEntry.getTextLength());
    }

    @Override
    public abstract boolean canRename();

    @Override
    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        if (this.canRename()) {
            return (PsiElement)this.getExpression();
        }
        throw (Throwable)new IncorrectOperationException();
    }

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = (KtDestructuringDeclarationEntry)this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktDestructuringDeclarationEntry, (String)"element");
        PsiElement psiElement = ktDestructuringDeclarationEntry.getParent();
        if (!(psiElement instanceof KtDestructuringDeclaration)) {
            psiElement = null;
        }
        KtDestructuringDeclaration ktDestructuringDeclaration = (KtDestructuringDeclaration)psiElement;
        if (ktDestructuringDeclaration == null) {
            return CollectionsKt.emptyList();
        }
        KtDestructuringDeclaration destructuringParent = ktDestructuringDeclaration;
        int componentIndex = destructuringParent.getEntries().indexOf(this.getElement()) + 1;
        Name name = Name.identifier((String)("component" + componentIndex));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"component$componentIndex\")");
        return CollectionsKt.listOf((Object)name);
    }

    public KtDestructuringDeclarationReference(@NotNull KtDestructuringDeclarationEntry element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        super((KtElement)element2);
    }
}

