/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Description;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.ToString;

public final class Formatting {
    private static final String EMPTY_MESSAGE = "";

    private Formatting() {
    }

    @Nonnull
    static String createMessageFrom(@Nullable Description description, @Nonnull Object[] message) {
        return Formatting.format(description, Strings.concat((Object[])message));
    }

    @Nonnull
    public static String format(@Nullable Description description, @Nonnull String message) {
        Preconditions.checkNotNull((Object)message);
        String s = Formatting.valueOf(description);
        return Formatting.format(s) + message;
    }

    @Nullable
    public static String valueOf(@Nullable Description description) {
        return description == null ? null : description.value();
    }

    @Nonnull
    public static String format(@Nullable String message) {
        if (Strings.isNullOrEmpty((String)message)) {
            return EMPTY_MESSAGE;
        }
        return String.format("[%s] ", message);
    }

    @Nonnull
    public static String inBrackets(@Nullable Object o) {
        return Formatting.doBracketAround(ToString.toStringOf((Object)o));
    }

    @Nonnull
    private static String doBracketAround(@Nullable String s) {
        return String.format("<%s>", s);
    }

    @Nonnull
    public static String format(@Nonnull String format, Object ... args) {
        Object[] argsAsText = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            argsAsText[i] = ToString.toStringOf((Object)args[i]);
        }
        return String.format(format, argsAsText);
    }
}

