/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret.InterpreterUtil;
import org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret.ValuesOrder;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J0\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\u0013\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/FilterTraceInterpreter;", "Lcom/intellij/debugger/streams/trace/CallTraceInterpreter;", "predicateValueToAccept", "", "(Z)V", "extractPredicateValues", "", "", "filteringMap", "Lcom/sun/jdi/Value;", "resolve", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "call", "Lcom/intellij/debugger/streams/wrapper/StreamCall;", "value", "resolveValuesAfter", "Lcom/intellij/debugger/streams/trace/TraceElement;", "before", "resolveValuesBefore", "map", "kotlin.jvm-debugger.sequence"})
public final class FilterTraceInterpreter
implements CallTraceInterpreter {
    private final boolean predicateValueToAccept;

    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call, @NotNull Value value) {
        Value filteringMap;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof ArrayReference)) {
            throw (Throwable)new UnexpectedValueTypeException("array reference excepted, but actual: " + value.type().name());
        }
        Value value2 = ((ArrayReference)value).getValue(0);
        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value.getValue(0)");
        Map<Integer, TraceElement> before = this.resolveValuesBefore(value2);
        Value value3 = filteringMap = ((ArrayReference)value).getValue(1);
        Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"filteringMap");
        Map<Integer, TraceElement> after = this.resolveValuesAfter(before, value3);
        return new ValuesOrder(call, before, after);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, TraceElement> resolveValuesBefore(Value map2) {
        void keys;
        InterpreterUtil.MapRepresentation mapRepresentation = InterpreterUtil.INSTANCE.extractMap(map2);
        ArrayReference arrayReference = mapRepresentation.component1();
        ArrayReference objects = mapRepresentation.component2();
        int n = 0;
        List result = new ArrayList();
        n = 0;
        int n2 = keys.length();
        while (n < n2) {
            void i;
            Value time = keys.getValue((int)i);
            Value value = objects.getValue((int)i);
            if (!(time instanceof IntegerValue)) {
                throw (Throwable)new UnexpectedValueTypeException("time should be represented by integer value");
            }
            result.add(new TraceElementImpl(((IntegerValue)time).value(), value));
            ++i;
        }
        return InterpreterUtil.INSTANCE.createIndexByTime(result);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, TraceElement> resolveValuesAfter(Map<Integer, ? extends TraceElement> before, Value filteringMap) {
        Map<Integer, Boolean> predicateValues = this.extractPredicateValues(filteringMap);
        boolean bl = false;
        LinkedHashMap result = new LinkedHashMap();
        Map<Integer, ? extends TraceElement> map2 = before;
        boolean bl2 = false;
        Iterator<Map.Entry<Integer, ? extends TraceElement>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void beforeTime;
            Map.Entry<Integer, ? extends TraceElement> entry;
            Map.Entry<Integer, ? extends TraceElement> entry2 = entry = iterator.next();
            boolean bl3 = false;
            int n = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            bl3 = false;
            TraceElement element = entry2.getValue();
            Boolean predicateValue = predicateValues.get((int)beforeTime);
            if (!Intrinsics.areEqual((Object)predicateValue, (Object)this.predicateValueToAccept)) continue;
            ((Map)result).put((int)(beforeTime + true), new TraceElementImpl((int)(beforeTime + true), element.getValue()));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, Boolean> extractPredicateValues(Value filteringMap) {
        void keys;
        InterpreterUtil.MapRepresentation mapRepresentation = InterpreterUtil.INSTANCE.extractMap(filteringMap);
        ArrayReference arrayReference = mapRepresentation.component1();
        ArrayReference values = mapRepresentation.component2();
        int n = 0;
        Map result = new LinkedHashMap();
        n = 0;
        int n2 = keys.length();
        while (n < n2) {
            void i;
            Value time = keys.getValue((int)i);
            Value value = values.getValue((int)i);
            if (!(time instanceof IntegerValue)) {
                throw (Throwable)new UnexpectedValueTypeException("time should be represented by integer value");
            }
            if (!(value instanceof BooleanValue)) {
                throw (Throwable)new UnexpectedValueTypeException("predicate value should be represented by boolean value");
            }
            result.put(((IntegerValue)time).value(), ((BooleanValue)value).value());
            ++i;
        }
        return result;
    }

    public FilterTraceInterpreter(boolean predicateValueToAccept) {
        this.predicateValueToAccept = predicateValueToAccept;
    }
}

