/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.DependencyManager;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFileCache;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildModelContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleDslFileCache myFileCache;
    @NotNull
    private final Map<GradleDslFile, ClassToInstanceMap<BuildModelNotification>> myNotifications;
    @NotNull
    private final DependencyManager myDependencyManager;
    @Nullable
    private GradleDslFile myRootProjectFile;

    public void setRootProjectFile(@NotNull GradleDslFile rootProjectFile) {
        if (rootProjectFile == null) {
            BuildModelContext.$$$reportNull$$$0(0);
        }
        this.myRootProjectFile = rootProjectFile;
    }

    @Nullable
    public GradleDslFile getRootProjectFile() {
        return this.myRootProjectFile;
    }

    @NotNull
    public static BuildModelContext create(@NotNull Project project) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(1);
        }
        return new BuildModelContext(project);
    }

    private BuildModelContext(@NotNull Project project) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(2);
        }
        this.myNotifications = new HashMap<GradleDslFile, ClassToInstanceMap<BuildModelNotification>>();
        this.myProject = project;
        this.myFileCache = new GradleDslFileCache(project);
        this.myDependencyManager = DependencyManager.create();
        this.myRootProjectFile = null;
    }

    @NotNull
    public DependencyManager getDependencyManager() {
        DependencyManager dependencyManager = this.myDependencyManager;
        if (dependencyManager == null) {
            BuildModelContext.$$$reportNull$$$0(3);
        }
        return dependencyManager;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications(@NotNull GradleDslFile file) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(5);
        }
        return new ArrayList<BuildModelNotification>(this.myNotifications.getOrDefault(file, (ClassToInstanceMap<BuildModelNotification>)MutableClassToInstanceMap.create()).values());
    }

    @NotNull
    public <T extends BuildModelNotification> T getNotificationForType(@NotNull GradleDslFile file, @NotNull NotificationTypeReference<T> type) {
        ClassToInstanceMap notificationMap;
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(6);
        }
        if (type == null) {
            BuildModelContext.$$$reportNull$$$0(7);
        }
        if ((notificationMap = this.myNotifications.computeIfAbsent(file, f -> MutableClassToInstanceMap.create())).containsKey(type.getClazz())) {
            BuildModelNotification buildModelNotification = (BuildModelNotification)notificationMap.getInstance(type.getClazz());
            if (buildModelNotification == null) {
                BuildModelContext.$$$reportNull$$$0(8);
            }
            return (T)buildModelNotification;
        }
        BuildModelNotification notification = (BuildModelNotification)type.getConstructor().produce();
        notificationMap.putInstance(type.getClazz(), (Object)notification);
        BuildModelNotification buildModelNotification = notification;
        if (buildModelNotification == null) {
            BuildModelContext.$$$reportNull$$$0(9);
        }
        return (T)buildModelNotification;
    }

    @Nullable
    public VirtualFile getCurrentParsingRoot() {
        return this.myFileCache.getCurrentParsingRoot();
    }

    public void reset() {
        this.myFileCache.clearAllFiles();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, @NotNull String name, boolean isApplied) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(10);
        }
        if (name == null) {
            BuildModelContext.$$$reportNull$$$0(11);
        }
        GradleBuildFile gradleBuildFile = this.myFileCache.getOrCreateBuildFile(file, name, this, isApplied);
        if (gradleBuildFile == null) {
            BuildModelContext.$$$reportNull$$$0(12);
        }
        return gradleBuildFile;
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, boolean isApplied) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(13);
        }
        GradleBuildFile gradleBuildFile = this.getOrCreateBuildFile(file, file.getName(), isApplied);
        if (gradleBuildFile == null) {
            BuildModelContext.$$$reportNull$$$0(14);
        }
        return gradleBuildFile;
    }

    @Nullable
    public GradleSettingsFile getSettingsFile(@NotNull Project project) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(15);
        }
        return this.myFileCache.getSettingsFile(project);
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile) {
        if (settingsFile == null) {
            BuildModelContext.$$$reportNull$$$0(16);
        }
        GradleSettingsFile gradleSettingsFile = this.myFileCache.getOrCreateSettingsFile(settingsFile, this);
        if (gradleSettingsFile == null) {
            BuildModelContext.$$$reportNull$$$0(17);
        }
        return gradleSettingsFile;
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file, @NotNull String moduleName) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(18);
        }
        if (moduleName == null) {
            BuildModelContext.$$$reportNull$$$0(19);
        }
        return this.myFileCache.getOrCreatePropertiesFile(file, moduleName, this);
    }

    public void putBuildFile(@NotNull String name, @NotNull GradleDslFile buildFile) {
        if (name == null) {
            BuildModelContext.$$$reportNull$$$0(20);
        }
        if (buildFile == null) {
            BuildModelContext.$$$reportNull$$$0(21);
        }
        this.myFileCache.putBuildFile(name, buildFile);
    }

    @NotNull
    public List<GradleDslFile> getAllRequestedFiles() {
        List<GradleDslFile> list = this.myFileCache.getAllFiles();
        if (list == null) {
            BuildModelContext.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectFile";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/BuildModelContext";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/BuildModelContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationForType";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateBuildFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSettingsFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRequestedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRootProjectFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPublicNotifications";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationForType";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateBuildFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateSettingsFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreatePropertiesFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putBuildFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

