/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.intellij.util.containers.HashSetQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DependencyManager {
    @NotNull
    private final LinkedHashMap<GradleDslFile, List<GradleReferenceInjection>> myUnresolvedReferences = new LinkedHashMap();

    public static DependencyManager create() {
        return new DependencyManager();
    }

    private DependencyManager() {
    }

    public void registerUnresolvedReference(@NotNull GradleReferenceInjection injection) {
        if (injection == null) {
            DependencyManager.$$$reportNull$$$0(0);
        }
        assert (!injection.isResolved());
        GradleDslFile originFile = injection.getOriginElement().getDslFile();
        List injections = this.myUnresolvedReferences.getOrDefault(originFile, new ArrayList());
        injections.add(injection);
        this.myUnresolvedReferences.put(originFile, injections);
    }

    public void unregisterUnresolvedReference(@NotNull GradleReferenceInjection injection) {
        if (injection == null) {
            DependencyManager.$$$reportNull$$$0(1);
        }
        assert (!injection.isResolved());
        GradleDslFile originFile = injection.getOriginElement().getDslFile();
        List<GradleReferenceInjection> injections = this.myUnresolvedReferences.get(originFile);
        injections.remove(injection);
    }

    public void resolveWith(@NotNull GradleDslElement element) {
        GradleDslFile dslFile;
        if (element == null) {
            DependencyManager.$$$reportNull$$$0(2);
        }
        HashSetQueue queue = new HashSetQueue();
        HashSet<GradleDslFile> seen = new HashSet<GradleDslFile>();
        GradleDslFile thisFile = element.getDslFile();
        queue.add(element.getDslFile());
        while ((dslFile = (GradleDslFile)queue.peek()) != null) {
            queue.remove();
            if (seen.contains(dslFile)) continue;
            seen.add(dslFile);
            this.resolveAllIn(dslFile, true);
            queue.addAll(dslFile.getChildModuleDslFiles());
        }
        for (GradleDslFile buildFile : this.myUnresolvedReferences.keySet()) {
            if (seen.contains(buildFile) || !buildFile.getApplyDslElement().contains(thisFile)) continue;
            this.resolveAllIn(buildFile, true);
        }
    }

    public void resolveAllIn(@NotNull GradleDslFile dslFile, boolean appliedFiles) {
        if (dslFile == null) {
            DependencyManager.$$$reportNull$$$0(3);
        }
        List injections = this.myUnresolvedReferences.getOrDefault(dslFile, new ArrayList());
        Iterator it = injections.iterator();
        while (it.hasNext()) {
            GradleReferenceInjection injection = (GradleReferenceInjection)it.next();
            GradleDslElement newElement = injection.getOriginElement().resolveReference(injection.getName(), true);
            if (newElement == null) continue;
            injection.resolveWith(newElement);
            newElement.registerDependent(injection);
            it.remove();
        }
        if (injections.isEmpty()) {
            this.myUnresolvedReferences.remove(dslFile);
        }
        if (appliedFiles) {
            for (GradleDslFile appliedFile : dslFile.getApplyDslElement()) {
                this.resolveAllIn(appliedFile, true);
            }
        }
    }

    public void resolveAll() {
        for (GradleDslFile dslFile : this.myUnresolvedReferences.keySet()) {
            this.resolveAllIn(dslFile, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslFile";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/DependencyManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerUnresolvedReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterUnresolvedReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveWith";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveAllIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

