/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtil;
import com.theoryinpractice.testng.DataProviderReference;
import com.theoryinpractice.testng.TestNGFramework;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.testng.annotations.DataProvider;

public class TestNGDataProviderInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            TestNGDataProviderInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiAnnotationMemberValue provider;
                if (TestNGUtil.TEST_ANNOTATION_FQN.equals(annotation.getQualifiedName()) && (provider = annotation.findDeclaredAttributeValue("dataProvider")) != null && !TestNGUtil.isDisabled(annotation)) {
                    for (PsiReference reference : provider.getReferences()) {
                        if (!(reference instanceof DataProviderReference)) continue;
                        PsiElement dataProviderMethod = reference.resolve();
                        PsiElement element = reference.getElement();
                        PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)element);
                        PsiClass providerClass = TestNGUtil.getProviderClass(element, topLevelClass);
                        if (!(dataProviderMethod instanceof PsiMethod)) {
                            LocalQuickFix[] fixes = isOnTheFly && providerClass != null ? new LocalQuickFix[]{TestNGDataProviderInspection.createMethodFix(provider, providerClass, topLevelClass)} : LocalQuickFix.EMPTY_ARRAY;
                            holder.registerProblem((PsiElement)provider, TestngBundle.message("inspection.testng.data.provider.does.not.exist.problem", new Object[0]), fixes);
                            break;
                        }
                        Version version = TestNGUtil.detectVersion(holder.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)providerClass));
                        if (version != null && version.isOrGreaterThan(Integer.valueOf(6), Integer.valueOf(9), Integer.valueOf(13))) break;
                        PsiMethod providerMethod = (PsiMethod)dataProviderMethod;
                        if (providerClass == topLevelClass || providerMethod.hasModifierProperty("static")) break;
                        holder.registerProblem((PsiElement)provider, TestngBundle.message("inspection.testng.data.provider.need.to.be.static", new Object[0]), new LocalQuickFix[0]);
                        break;
                    }
                }
            }
        };
    }

    private static CreateMethodQuickFix createMethodFix(PsiAnnotationMemberValue provider, @NotNull PsiClass providerClass, PsiClass topLevelClass) {
        if (providerClass == null) {
            TestNGDataProviderInspection.$$$reportNull$$$0(1);
        }
        String name = StringUtil.unquoteString((String)provider.getText());
        FileTemplateDescriptor templateDesc = new TestNGFramework().getParametersMethodFileTemplateDescriptor();
        assert (templateDesc != null);
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)provider.getProject()).getCodeTemplate(templateDesc.getFileName());
        String body = "";
        try {
            Properties attributes = FileTemplateManager.getInstance((Project)provider.getProject()).getDefaultProperties();
            attributes.setProperty("NAME", name);
            body = fileTemplate.getText(attributes);
            body = body.replace("${BODY}\n", "");
            PsiMethod methodFromTemplate = JavaPsiFacade.getElementFactory((Project)providerClass.getProject()).createMethodFromText(body, (PsiElement)providerClass);
            PsiCodeBlock methodBody = methodFromTemplate.getBody();
            body = methodBody != null ? StringUtil.trimEnd((String)StringUtil.trimStart((String)methodBody.getText(), (String)"{"), (String)"}") : "";
        }
        catch (Exception attributes) {
            // empty catch block
        }
        if (StringUtil.isEmptyOrSpaces((String)body)) {
            body = "return new Object[][]{};";
        }
        String signature = "@" + DataProvider.class.getName() + " public ";
        if (providerClass == topLevelClass) {
            signature = signature + "static ";
        }
        signature = signature + "Object[][] " + name + "()";
        return CreateMethodQuickFix.createFix((PsiClass)providerClass, (String)signature, (String)body);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
        }
        objectArray2[1] = "com/theoryinpractice/testng/inspection/TestNGDataProviderInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createMethodFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

