/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.GError;
import com.intellij.credentialStore.GErrorByRef;
import com.intellij.credentialStore.LinuxSecretLibraryKt;
import com.intellij.credentialStore.SecretCredentialStore;
import com.intellij.credentialStore.SecretLibrary;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.jna.DisposableMemory;
import com.intellij.util.text.StringKt;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J?\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\u00032!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u0002H\u00140\u0017H\u0082\b\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0002J\u0013\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0096\u0002J\u001b\u0010%\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010\"H\u0096\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0011\u0010\b\u00a8\u0006("}, d2={"Lcom/intellij/credentialStore/SecretCredentialStore;", "Lcom/intellij/credentialStore/CredentialStore;", "schemeName", "", "(Ljava/lang/String;)V", "accountAttributeNamePointer", "Lcom/intellij/util/io/jna/DisposableMemory;", "getAccountAttributeNamePointer", "()Lcom/intellij/util/io/jna/DisposableMemory;", "accountAttributeNamePointer$delegate", "Lkotlin/Lazy;", "schema", "Lcom/sun/jna/Pointer;", "getSchema", "()Lcom/sun/jna/Pointer;", "schema$delegate", "serviceAttributeNamePointer", "getServiceAttributeNamePointer", "serviceAttributeNamePointer$delegate", "checkError", "T", "method", "task", "Lkotlin/Function1;", "Lcom/intellij/credentialStore/GErrorByRef;", "Lkotlin/ParameterName;", "name", "errorRef", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "clearPassword", "", "serviceNamePointer", "accountName", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "set", "credentials", "Companion", "intellij.platform.credentialStore"})
public final class SecretCredentialStore
implements CredentialStore {
    private final Lazy serviceAttributeNamePointer$delegate = LazyKt.lazy((Function0)serviceAttributeNamePointer.2.INSTANCE);
    private final Lazy accountAttributeNamePointer$delegate = LazyKt.lazy((Function0)accountAttributeNamePointer.2.INSTANCE);
    private final Lazy schema$delegate;
    private static final SecretLibrary library;
    private static final int DBUS_ERROR;
    private static final int SECRET_ERROR;
    public static final Companion Companion;

    private final DisposableMemory getServiceAttributeNamePointer() {
        Lazy lazy = this.serviceAttributeNamePointer$delegate;
        SecretCredentialStore secretCredentialStore = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DisposableMemory)lazy.getValue();
    }

    private final DisposableMemory getAccountAttributeNamePointer() {
        Lazy lazy = this.accountAttributeNamePointer$delegate;
        SecretCredentialStore secretCredentialStore = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DisposableMemory)lazy.getValue();
    }

    private final Pointer getSchema() {
        Lazy lazy = this.schema$delegate;
        SecretCredentialStore secretCredentialStore = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Pointer)lazy.getValue();
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        long start = System.currentTimeMillis();
        try {
            Credentials credentials2 = (Credentials)CompletableFuture.supplyAsync((Supplier)new Supplier<Credentials>(this, attributes){
                final /* synthetic */ SecretCredentialStore this$0;
                final /* synthetic */ CredentialAttributes $attributes;

                /*
                 * Enabled aggressive block sorting
                 */
                @Nullable
                public final Credentials get() {
                    Object v3;
                    GErrorByRef errorRef$iv;
                    String userName = StringKt.nullize$default((String)this.$attributes.getUserName(), (boolean)false, (int)1, null);
                    SecretCredentialStore secretCredentialStore = this.this$0;
                    String method$iv = "secret_password_lookup_sync";
                    boolean $i$f$checkError = false;
                    GErrorByRef errorRef = errorRef$iv = new GErrorByRef();
                    boolean bl = false;
                    String string = this.$attributes.getServiceName();
                    Charset charset = Charsets.UTF_8;
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    DisposableMemory serviceNamePointer = LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
                    if (userName == null) {
                        String string3 = SecretCredentialStore.access$getLibrary$cp().secret_password_lookup_sync(SecretCredentialStore.access$getSchema$p(this.this$0), null, errorRef, (Pointer)SecretCredentialStore.access$getServiceAttributeNamePointer$p(this.this$0), (Pointer)serviceNamePointer, null);
                        if (string3 != null) {
                            string = string3;
                            boolean bl3 = false;
                            bl2 = false;
                            String it = string;
                            return CredentialStoreKt.splitData(it);
                        }
                        v3 = null;
                    } else {
                        SecretLibrary secretLibrary = SecretCredentialStore.access$getLibrary$cp();
                        Pointer pointer = SecretCredentialStore.access$getSchema$p(this.this$0);
                        Pointer[] pointerArray = new Pointer[5];
                        pointerArray[0] = (Pointer)SecretCredentialStore.access$getServiceAttributeNamePointer$p(this.this$0);
                        pointerArray[1] = (Pointer)serviceNamePointer;
                        pointerArray[2] = (Pointer)SecretCredentialStore.access$getAccountAttributeNamePointer$p(this.this$0);
                        string = userName;
                        charset = Charsets.UTF_8;
                        bl2 = false;
                        byte[] byArray2 = string.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                        pointerArray[3] = (Pointer)LinuxSecretLibraryKt.stringPointer$default(byArray2, false, 2, null);
                        pointerArray[4] = null;
                        String string4 = secretLibrary.secret_password_lookup_sync(pointer, null, errorRef, pointerArray);
                        if (string4 != null) {
                            string = string4;
                            boolean bl4 = false;
                            bl2 = false;
                            String it = string;
                            return CredentialStoreKt.splitData(it);
                        }
                        v3 = null;
                    }
                    Object result$iv = v3;
                    GError error$iv = errorRef$iv.getValue();
                    if (error$iv == null) return result$iv;
                    if (com.intellij.credentialStore.SecretCredentialStore$Companion.access$isNoSecretService(SecretCredentialStore.Companion, error$iv)) {
                        CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
                    }
                    Integer n = error$iv.domain;
                    int n2 = SecretCredentialStore.access$getSECRET_ERROR$cp();
                    if (n != null && n == n2) {
                        Integer n3 = error$iv.code;
                        n2 = 2;
                        if (n3 != null && n3 == n2) {
                            CredentialStoreKt.getLOG().warn("Cancelled storage unlock: " + error$iv.message);
                            return result$iv;
                        }
                    }
                    CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
                    return result$iv;
                }
                {
                    this.this$0 = secretCredentialStore;
                    this.$attributes = credentialAttributes;
                }
            }, AppExecutorUtil.getAppExecutorService()).get(30L, TimeUnit.SECONDS);
            long end = System.currentTimeMillis();
            if (credentials2 == null && end - start > (long)300) {
                return CredentialStoreKt.getACCESS_TO_KEY_CHAIN_DENIED();
            }
            return credentials2;
        }
        catch (TimeoutException e) {
            CredentialStoreKt.getLOG().warn("storage unlock timeout");
            return CredentialStoreKt.getCANNOT_UNLOCK_KEYCHAIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials2) {
        GErrorByRef errorRef$iv;
        String lookupName;
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        String string = attributes.getServiceName();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        DisposableMemory serviceNamePointer = LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
        String string3 = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
        if (string3 == null) {
            Credentials credentials3 = credentials2;
            string3 = credentials3 != null ? credentials3.getUserName() : null;
        }
        String accountName = string3;
        String string4 = lookupName = Intrinsics.areEqual((Object)attributes.getServiceName(), (Object)"IntelliJ Platform") ? accountName : null;
        if (CredentialAttributesKt.isEmpty((Credentials)credentials2)) {
            this.clearPassword(serviceNamePointer, lookupName);
            return;
        }
        Credentials credentials4 = credentials2;
        Intrinsics.checkNotNull((Object)credentials4);
        DisposableMemory passwordPointer = LinuxSecretLibraryKt.stringPointer(CredentialStoreKt.serialize(credentials4, !attributes.isPasswordMemoryOnly()), true);
        SecretCredentialStore secretCredentialStore = this;
        String method$iv = "secret_password_store_sync";
        boolean $i$f$checkError = false;
        GErrorByRef errorRef = errorRef$iv = new GErrorByRef();
        boolean bl2 = false;
        try {
            this.clearPassword(serviceNamePointer, null);
            if (accountName == null) {
                library.secret_password_store_sync(this.getSchema(), null, (Pointer)serviceNamePointer, (Pointer)passwordPointer, null, errorRef, (Pointer)this.getServiceAttributeNamePointer(), (Pointer)serviceNamePointer, null);
            } else {
                Pointer pointer = this.getSchema();
                Pointer pointer2 = (Pointer)serviceNamePointer;
                Pointer pointer3 = (Pointer)passwordPointer;
                Pointer[] pointerArray = new Pointer[5];
                pointerArray[0] = (Pointer)this.getServiceAttributeNamePointer();
                pointerArray[1] = (Pointer)serviceNamePointer;
                pointerArray[2] = (Pointer)this.getAccountAttributeNamePointer();
                String string5 = accountName;
                Charset charset2 = Charsets.UTF_8;
                boolean bl3 = false;
                byte[] byArray2 = string5.getBytes(charset2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                pointerArray[3] = (Pointer)LinuxSecretLibraryKt.stringPointer$default(byArray2, false, 2, null);
                pointerArray[4] = null;
                library.secret_password_store_sync(pointer, null, pointer2, pointer3, null, errorRef, pointerArray);
            }
        }
        finally {
            passwordPointer.dispose();
        }
        Unit result$iv = Unit.INSTANCE;
        GError error$iv = errorRef$iv.getValue();
        if (error$iv == null) return;
        if (SecretCredentialStore.Companion.isNoSecretService(error$iv)) {
            CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
        }
        Integer n = error$iv.domain;
        int n2 = SecretCredentialStore.SECRET_ERROR;
        if (n != null && n == n2) {
            Integer n3 = error$iv.code;
            n2 = 2;
            if (n3 != null && n3 == n2) {
                CredentialStoreKt.getLOG().warn("Cancelled storage unlock: " + error$iv.message);
                return;
            }
        }
        CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void clearPassword(DisposableMemory serviceNamePointer, String accountName) {
        GErrorByRef errorRef$iv;
        SecretCredentialStore secretCredentialStore = this;
        String method$iv = "secret_password_clear_sync";
        boolean $i$f$checkError = false;
        GErrorByRef errorRef = errorRef$iv = new GErrorByRef();
        boolean bl = false;
        if (accountName == null) {
            library.secret_password_clear_sync(this.getSchema(), null, errorRef, (Pointer)this.getServiceAttributeNamePointer(), (Pointer)serviceNamePointer, null);
        } else {
            Pointer pointer = this.getSchema();
            Pointer[] pointerArray = new Pointer[5];
            pointerArray[0] = (Pointer)this.getServiceAttributeNamePointer();
            pointerArray[1] = (Pointer)serviceNamePointer;
            pointerArray[2] = (Pointer)this.getAccountAttributeNamePointer();
            String string = accountName;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            pointerArray[3] = (Pointer)LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
            pointerArray[4] = null;
            library.secret_password_clear_sync(pointer, null, errorRef, pointerArray);
        }
        Unit result$iv = Unit.INSTANCE;
        GError error$iv = errorRef$iv.getValue();
        if (error$iv == null) return;
        if (SecretCredentialStore.Companion.isNoSecretService(error$iv)) {
            CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
        }
        Integer n = error$iv.domain;
        int n2 = SecretCredentialStore.SECRET_ERROR;
        if (n != null && n == n2) {
            Integer n3 = error$iv.code;
            n2 = 2;
            if (n3 != null && n3 == n2) {
                CredentialStoreKt.getLOG().warn("Cancelled storage unlock: " + error$iv.message);
                return;
            }
        }
        CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <T> T checkError(String method, Function1<? super GErrorByRef, ? extends T> task) {
        int $i$f$checkError = 0;
        GErrorByRef errorRef = new GErrorByRef();
        Object result = task.invoke((Object)errorRef);
        GError error = errorRef.getValue();
        if (error == null) return (T)result;
        if (SecretCredentialStore.Companion.isNoSecretService(error)) {
            CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method + " error code " + error.code + ", error message " + error.message);
        }
        Integer n = error.domain;
        int n2 = SecretCredentialStore.SECRET_ERROR;
        if (n != null && n == n2) {
            Integer n3 = error.code;
            n2 = 2;
            if (n3 != null && n3 == n2) {
                CredentialStoreKt.getLOG().warn("Cancelled storage unlock: " + error.message);
                return (T)result;
            }
        }
        CredentialStoreKt.getLOG().error(method + " error code " + error.code + ", error message " + error.message);
        return (T)result;
    }

    private SecretCredentialStore(String schemeName) {
        this.schema$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pointer>(this, schemeName){
            final /* synthetic */ SecretCredentialStore this$0;
            final /* synthetic */ String $schemeName;

            @NotNull
            public final Pointer invoke() {
                return SecretCredentialStore.access$getLibrary$cp().secret_schema_new(this.$schemeName, 2, SecretCredentialStore.access$getServiceAttributeNamePointer$p(this.this$0), 0, SecretCredentialStore.access$getAccountAttributeNamePointer$p(this.this$0), 0, null);
            }
            {
                this.this$0 = secretCredentialStore;
                this.$schemeName = string;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        library = (SecretLibrary)Native.load((String)"secret-1", SecretLibrary.class);
        DBUS_ERROR = library.g_dbus_error_quark();
        SECRET_ERROR = library.secret_error_get_quark();
    }

    public static final /* synthetic */ Object access$checkError(SecretCredentialStore $this, String method, Function1 task) {
        return $this.checkError(method, task);
    }

    public static final /* synthetic */ Pointer access$getSchema$p(SecretCredentialStore $this) {
        return $this.getSchema();
    }

    public static final /* synthetic */ DisposableMemory access$getServiceAttributeNamePointer$p(SecretCredentialStore $this) {
        return $this.getServiceAttributeNamePointer();
    }

    public static final /* synthetic */ DisposableMemory access$getAccountAttributeNamePointer$p(SecretCredentialStore $this) {
        return $this.getAccountAttributeNamePointer();
    }

    public /* synthetic */ SecretCredentialStore(String schemeName, DefaultConstructorMarker $constructor_marker) {
        this(schemeName);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/credentialStore/SecretCredentialStore$Companion;", "", "()V", "DBUS_ERROR", "", "SECRET_ERROR", "library", "Lcom/intellij/credentialStore/SecretLibrary;", "kotlin.jvm.PlatformType", "create", "Lcom/intellij/credentialStore/SecretCredentialStore;", "schemeName", "", "isNoSecretService", "", "error", "Lcom/intellij/credentialStore/GError;", "pingService", "intellij.platform.credentialStore"})
    public static final class Companion {
        @Nullable
        public final SecretCredentialStore create(@NotNull String schemeName) {
            Intrinsics.checkNotNullParameter((Object)schemeName, (String)"schemeName");
            if (!this.pingService()) {
                return null;
            }
            return new SecretCredentialStore(schemeName, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean pingService() {
            DisposableMemory attr = null;
            Pointer dummySchema = null;
            try {
                String string = "ij-dummy-attribute";
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                attr = LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
                dummySchema = library.secret_schema_new("IJ.dummy.ping.schema", 2, attr, 0, null);
                GErrorByRef errorRef = new GErrorByRef();
                library.secret_password_lookup_sync(dummySchema, null, errorRef, (Pointer)attr, (Pointer)attr);
                GError error = errorRef.getValue();
                if (error == null) {
                    bl = true;
                    return bl;
                }
                if (this.isNoSecretService(error)) {
                    bl = false;
                    return bl;
                }
            }
            finally {
                DisposableMemory disposableMemory = attr;
                if (disposableMemory != null) {
                    disposableMemory.dispose();
                }
                Pointer pointer = dummySchema;
                if (pointer != null) {
                    Pointer pointer2 = pointer;
                    boolean bl = false;
                    boolean bl2 = false;
                    Pointer it = pointer2;
                    boolean bl3 = false;
                    library.secret_schema_unref(it);
                }
            }
            return true;
        }

        private final boolean isNoSecretService(GError error) {
            boolean bl;
            Integer n;
            Integer n2 = n = error.domain;
            int n3 = DBUS_ERROR;
            if (n2 != null && n2 == n3) {
                Integer n4 = error.code;
                n3 = 2;
                bl = n4 != null && n4 == n3;
            } else {
                bl = false;
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

