/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.artifact.repository.layout;

import org.gradle.internal.impldep.org.apache.maven.artifact.Artifact;
import org.gradle.internal.impldep.org.apache.maven.artifact.handler.ArtifactHandler;
import org.gradle.internal.impldep.org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.ArtifactRepository;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;

@Component(role=ArtifactRepositoryLayout.class, hint="flat")
public class FlatRepositoryLayout
implements ArtifactRepositoryLayout {
    private static final char ARTIFACT_SEPARATOR = '-';
    private static final char GROUP_SEPARATOR = '.';

    public String getId() {
        return "flat";
    }

    public String pathOf(Artifact artifact) {
        ArtifactHandler artifactHandler = artifact.getArtifactHandler();
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (artifact.hasClassifier()) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifactHandler.getExtension() != null && artifactHandler.getExtension().length() > 0) {
            path.append('.').append(artifactHandler.getExtension());
        }
        return path.toString();
    }

    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.pathOfRepositoryMetadata(metadata.getLocalFilename(repository));
    }

    private String pathOfRepositoryMetadata(String filename) {
        StringBuilder path = new StringBuilder(128);
        path.append(filename);
        return path.toString();
    }

    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata metadata) {
        return this.pathOfRepositoryMetadata(metadata.getRemoteFilename());
    }

    public String toString() {
        return this.getId();
    }
}

