/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.Metadata;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.io.MetadataParseException;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.util.IOUtil;
import org.gradle.internal.impldep.org.codehaus.plexus.util.ReaderFactory;
import org.gradle.internal.impldep.org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MetadataReader.class)
public class DefaultMetadataReader
implements MetadataReader {
    @Override
    public Metadata read(File input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input file missing");
        }
        Metadata metadata = this.read(ReaderFactory.newXmlReader(input), options);
        return metadata;
    }

    @Override
    public Metadata read(Reader input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input reader missing");
        }
        try {
            MetadataXpp3Reader r = new MetadataXpp3Reader();
            Metadata metadata = r.read(input, this.isStrict(options));
            return metadata;
        }
        catch (XmlPullParserException e) {
            throw new MetadataParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input);
        }
    }

    @Override
    public Metadata read(InputStream input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input stream missing");
        }
        try {
            MetadataXpp3Reader r = new MetadataXpp3Reader();
            Metadata metadata = r.read(input, this.isStrict(options));
            return metadata;
        }
        catch (XmlPullParserException e) {
            throw new MetadataParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

