/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.repository.internal;

import org.gradle.internal.impldep.org.apache.maven.model.Repository;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;
import org.gradle.internal.impldep.org.sonatype.aether.repository.RemoteRepository;
import org.gradle.internal.impldep.org.sonatype.aether.repository.RepositoryPolicy;
import org.gradle.internal.impldep.org.sonatype.aether.util.artifact.DefaultArtifact;

public class ArtifactDescriptorUtils {
    public static Artifact toPomArtifact(Artifact artifact) {
        Artifact pomArtifact = artifact;
        if (pomArtifact.getClassifier().length() > 0 || !"pom".equals(pomArtifact.getExtension())) {
            pomArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
        }
        return pomArtifact;
    }

    public static RemoteRepository toRemoteRepository(Repository repository) {
        RemoteRepository result = new RemoteRepository(repository.getId(), repository.getLayout(), repository.getUrl());
        result.setPolicy(true, ArtifactDescriptorUtils.toRepositoryPolicy(repository.getSnapshots()));
        result.setPolicy(false, ArtifactDescriptorUtils.toRepositoryPolicy(repository.getReleases()));
        return result;
    }

    public static RepositoryPolicy toRepositoryPolicy(org.gradle.internal.impldep.org.apache.maven.model.RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new RepositoryPolicy(enabled, updates, checksums);
    }
}

