/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.wagon.observers;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.internal.impldep.org.apache.maven.wagon.events.TransferEvent;
import org.gradle.internal.impldep.org.apache.maven.wagon.events.TransferListener;

public class ChecksumObserver
implements TransferListener {
    private MessageDigest digester = null;
    private String actualChecksum;

    public ChecksumObserver() throws NoSuchAlgorithmException {
        this("MD5");
    }

    public ChecksumObserver(String algorithm) throws NoSuchAlgorithmException {
        this.digester = MessageDigest.getInstance(algorithm);
    }

    @Override
    public void transferInitiated(TransferEvent transferEvent) {
    }

    @Override
    public void transferStarted(TransferEvent transferEvent) {
        this.actualChecksum = null;
        this.digester.reset();
    }

    @Override
    public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        this.digester.update(buffer, 0, length);
    }

    @Override
    public void transferCompleted(TransferEvent transferEvent) {
        this.actualChecksum = this.encode(this.digester.digest());
    }

    @Override
    public void transferError(TransferEvent transferEvent) {
        this.digester.reset();
        this.actualChecksum = null;
    }

    @Override
    public void debug(String message) {
    }

    public String getActualChecksum() {
        return this.actualChecksum;
    }

    protected String encode(byte[] binaryData) {
        if (binaryData.length != 16 && binaryData.length != 20) {
            int bitLength = binaryData.length * 8;
            throw new IllegalArgumentException("Unrecognised length for binary data: " + bitLength + " bits");
        }
        StringBuilder retValue = new StringBuilder();
        for (byte b : binaryData) {
            String t = Integer.toHexString(b & 0xFF);
            if (t.length() == 1) {
                retValue.append('0').append(t);
                continue;
            }
            retValue.append(t);
        }
        return retValue.toString().trim();
    }
}

