/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.util.Date;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.gradle.internal.impldep.org.bouncycastle.asn1.DEROctetString;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x9.X9ECParameters;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x9.X9ECPoint;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.BCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.BCPGObject;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.PublicKeyPacket;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.DSAParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECDomainParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ElGamalParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.RSAKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPKdfParameters;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPrivateKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcUtil;

public class BcPGPKeyConverter {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PGPPublicKey getPGPPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricKeyParameter asymmetricKeyParameter, Date date) throws PGPException {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        void var5_15;
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
            RSAPublicBCPGKey rSAPublicBCPGKey = new RSAPublicBCPGKey(rSAKeyParameters.getModulus(), rSAKeyParameters.getExponent());
            return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        }
        if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)asymmetricKeyParameter;
            DSAParameters dSAParameters = dSAPublicKeyParameters.getParameters();
            DSAPublicBCPGKey dSAPublicBCPGKey = new DSAPublicBCPGKey(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG(), dSAPublicKeyParameters.getY());
            return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        }
        if (asymmetricKeyParameter instanceof ElGamalPublicKeyParameters) {
            ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)asymmetricKeyParameter;
            ElGamalParameters elGamalParameters = elGamalPublicKeyParameters.getParameters();
            ElGamalPublicBCPGKey elGamalPublicBCPGKey = new ElGamalPublicBCPGKey(elGamalParameters.getP(), elGamalParameters.getG(), elGamalPublicKeyParameters.getY());
            return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        }
        if (!(asymmetricKeyParameter instanceof ECPublicKeyParameters)) throw new PGPException("unknown key class");
        try {
            subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymmetricKeyParameter);
        }
        catch (IOException iOException) {
            throw new PGPException("Unable to encode key: " + iOException.getMessage(), iOException);
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
        X9ECParameters x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        DEROctetString dEROctetString = new DEROctetString(subjectPublicKeyInfo.getPublicKeyData().getBytes());
        X9ECPoint x9ECPoint = new X9ECPoint(x9ECParameters.getCurve(), dEROctetString);
        if (n == 18) {
            PGPKdfParameters pGPKdfParameters = (PGPKdfParameters)pGPAlgorithmParameters;
            if (pGPKdfParameters == null) {
                pGPKdfParameters = new PGPKdfParameters(8, 7);
            }
            ECDHPublicBCPGKey eCDHPublicBCPGKey = new ECDHPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint(), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
            return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        } else {
            if (n != 19) throw new PGPException("unknown EC algorithm");
            ECDSAPublicBCPGKey eCDSAPublicBCPGKey = new ECDSAPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint());
        }
        return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
    }

    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pGPPublicKey, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        BCPGObject bCPGObject;
        switch (pGPPublicKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricKeyParameter;
                bCPGObject = new RSASecretBCPGKey(rSAPrivateCrtKeyParameters.getExponent(), rSAPrivateCrtKeyParameters.getP(), rSAPrivateCrtKeyParameters.getQ());
                break;
            }
            case 17: {
                DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)asymmetricKeyParameter;
                bCPGObject = new DSASecretBCPGKey(dSAPrivateKeyParameters.getX());
                break;
            }
            case 16: 
            case 20: {
                ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)asymmetricKeyParameter;
                bCPGObject = new ElGamalSecretBCPGKey(elGamalPrivateKeyParameters.getX());
                break;
            }
            case 18: 
            case 19: {
                ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
                bCPGObject = new ECSecretBCPGKey(eCPrivateKeyParameters.getD());
                break;
            }
            default: {
                throw new PGPException("unknown key class");
            }
        }
        return new PGPPrivateKey(pGPPublicKey.getKeyID(), pGPPublicKey.getPublicKeyPacket(), (BCPGKey)((Object)bCPGObject));
    }

    public AsymmetricKeyParameter getPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new RSAKeyParameters(false, rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new DSAPublicKeyParameters(dSAPublicBCPGKey.getY(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    return new ElGamalPublicKeyParameters(elGamalPublicBCPGKey.getY(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
                case 18: 
                case 19: {
                    ECPublicBCPGKey eCPublicBCPGKey = (ECPublicBCPGKey)publicKeyPacket.getKey();
                    X9ECParameters x9ECParameters = BcUtil.getX9Parameters(eCPublicBCPGKey.getCurveOID());
                    return new ECPublicKeyParameters(BcUtil.decodePoint(eCPublicBCPGKey.getEncodedPoint(), x9ECParameters.getCurve()), (ECDomainParameters)new ECNamedDomainParameters(eCPublicBCPGKey.getCurveOID(), x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH()));
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    public AsymmetricKeyParameter getPrivateKey(PGPPrivateKey pGPPrivateKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        BCPGKey bCPGKey = pGPPrivateKey.getPrivateKeyDataPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)bCPGKey;
                    return new RSAPrivateCrtKeyParameters(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)bCPGKey;
                    return new DSAPrivateKeyParameters(dSASecretBCPGKey.getX(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)bCPGKey;
                    return new ElGamalPrivateKeyParameters(elGamalSecretBCPGKey.getX(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
                case 18: 
                case 19: {
                    ECPublicBCPGKey eCPublicBCPGKey = (ECPublicBCPGKey)publicKeyPacket.getKey();
                    ECSecretBCPGKey eCSecretBCPGKey = (ECSecretBCPGKey)bCPGKey;
                    X9ECParameters x9ECParameters = BcUtil.getX9Parameters(eCPublicBCPGKey.getCurveOID());
                    return new ECPrivateKeyParameters(eCSecretBCPGKey.getX(), (ECDomainParameters)new ECNamedDomainParameters(eCPublicBCPGKey.getCurveOID(), x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH()));
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }
}

