/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus.component.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gradle.internal.impldep.org.codehaus.plexus.MutablePlexusContainer;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.gradle.internal.impldep.org.codehaus.plexus.component.builder.AbstractComponentBuildListener;
import org.gradle.internal.impldep.org.codehaus.plexus.component.builder.ComponentBuilder;
import org.gradle.internal.impldep.org.codehaus.plexus.component.builder.XBeanComponentBuilder;
import org.gradle.internal.impldep.org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.manager.ComponentManager;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.gradle.internal.impldep.org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;
import org.gradle.internal.impldep.org.codehaus.plexus.personality.plexus.lifecycle.phase.PhaseExecutionException;

public abstract class AbstractComponentManager<T>
implements ComponentManager<T> {
    protected final MutablePlexusContainer container;
    private final ClassRealm realm;
    protected final ComponentDescriptor<T> componentDescriptor;
    private final Class<? extends T> type;
    private final String role;
    private final String roleHint;
    protected final ComponentBuilder<T> builder = new XBeanComponentBuilder(this);
    private final LifecycleHandler lifecycleHandler;
    protected final Map<Object, ClassRealm> componentContextRealms = Collections.synchronizedMap(new HashMap());
    private int connections;
    private long startId;

    public AbstractComponentManager(MutablePlexusContainer container, LifecycleHandler lifecycleHandler, ComponentDescriptor<T> componentDescriptor, String role, String roleHint) {
        if (container == null) {
            throw new NullPointerException("container is null");
        }
        this.container = container;
        if (lifecycleHandler == null) {
            throw new NullPointerException("lifecycleHandler is null");
        }
        this.lifecycleHandler = lifecycleHandler;
        if (componentDescriptor == null) {
            throw new NullPointerException("componentDescriptor is null");
        }
        this.componentDescriptor = componentDescriptor;
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        this.role = role;
        if (roleHint == null) {
            throw new NullPointerException("roleHint is null");
        }
        this.roleHint = roleHint;
        this.realm = componentDescriptor.getRealm();
        this.type = componentDescriptor.getImplementationClass();
    }

    @Override
    public ComponentDescriptor<T> getComponentDescriptor() {
        return this.componentDescriptor;
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public ClassRealm getRealm() {
        return this.realm;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public String getRoleHint() {
        return this.roleHint;
    }

    @Override
    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    protected void incrementConnectionCount() {
        ++this.connections;
    }

    protected void decrementConnectionCount() {
        --this.connections;
    }

    protected boolean connected() {
        return this.connections > 0;
    }

    @Override
    public int getConnections() {
        return this.connections;
    }

    @Override
    public void start(Object component) throws PhaseExecutionException {
        this.startId = NEXT_START_ID.getAndIncrement();
        this.getLifecycleHandler().start(component, this, this.componentDescriptor.getRealm());
    }

    @Override
    public long getStartId() {
        return this.startId;
    }

    protected T createComponentInstance() throws ComponentInstantiationException, ComponentLifecycleException {
        return this.builder.build(this.componentDescriptor, this.realm, new AbstractComponentBuildListener(){

            @Override
            public void componentCreated(ComponentDescriptor<?> componentDescriptor, Object component, ClassRealm realm) {
                AbstractComponentManager.this.componentContextRealms.put(component, realm);
            }
        });
    }

    protected void endComponentLifecycle(Object component) throws ComponentLifecycleException {
        ClassRealm contextRealm = this.componentContextRealms.remove(component);
        if (contextRealm == null) {
            contextRealm = this.container.getLookupRealm(component);
        }
        try {
            this.getLifecycleHandler().end(component, this, contextRealm);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error ending component lifecycle", e);
        }
    }

    @Override
    public MutablePlexusContainer getContainer() {
        return this.container;
    }

    public Logger getLogger() {
        return this.container.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dissociateComponentRealm(ClassRealm realm) throws ComponentLifecycleException {
        Map<Object, ClassRealm> map = this.componentContextRealms;
        synchronized (map) {
            Iterator<Map.Entry<Object, ClassRealm>> iterator = this.componentContextRealms.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, ClassRealm> entry = iterator.next();
                ClassRealm componentRealm = entry.getValue();
                if (!componentRealm.getId().equals(realm.getId())) continue;
                iterator.remove();
            }
        }
    }
}

