/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch;

import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.KetchLeader;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.KetchSystem;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;

public class KetchLeaderCache {
    private final KetchSystem system;
    private final ConcurrentMap<String, KetchLeader> leaders;
    private final Lock startLock;

    public KetchLeaderCache(KetchSystem system) {
        this.system = system;
        this.leaders = new ConcurrentHashMap<String, KetchLeader>();
        this.startLock = new ReentrantLock(true);
    }

    public KetchLeader get(Repository repo) throws URISyntaxException {
        String key = KetchLeaderCache.computeKey(repo);
        KetchLeader leader = (KetchLeader)this.leaders.get(key);
        if (leader != null) {
            return leader;
        }
        return this.startLeader(key, repo);
    }

    private KetchLeader startLeader(String key, Repository repo) throws URISyntaxException {
        this.startLock.lock();
        try {
            KetchLeader leader = (KetchLeader)this.leaders.get(key);
            if (leader != null) {
                KetchLeader ketchLeader = leader;
                return ketchLeader;
            }
            leader = this.system.createLeader(repo);
            this.leaders.put(key, leader);
            KetchLeader ketchLeader = leader;
            return ketchLeader;
        }
        finally {
            this.startLock.unlock();
        }
    }

    private static String computeKey(Repository repo) {
        if (repo instanceof DfsRepository) {
            DfsRepository dfs = (DfsRepository)repo;
            return dfs.getDescription().getRepositoryName();
        }
        if (repo.getDirectory() != null) {
            return repo.getDirectory().toURI().toString();
        }
        throw new IllegalArgumentException();
    }
}

