/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.core;

import java.util.LinkedHashSet;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.PreconditionViolationException;
import org.gradle.internal.impldep.org.junit.platform.commons.util.Preconditions;
import org.gradle.internal.impldep.org.junit.platform.engine.TestEngine;
import org.gradle.internal.impldep.org.junit.platform.launcher.Launcher;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.DefaultLauncher;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.LauncherConfig;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.ServiceLoaderTestEngineRegistry;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.ServiceLoaderTestExecutionListenerRegistry;

@API(status=API.Status.STABLE, since="1.0")
public class LauncherFactory {
    private LauncherFactory() {
    }

    public static Launcher create() throws PreconditionViolationException {
        return LauncherFactory.create(LauncherConfig.builder().build());
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3")
    public static Launcher create(LauncherConfig config) throws PreconditionViolationException {
        Preconditions.notNull(config, "LauncherConfig must not be null");
        LinkedHashSet<TestEngine> engines = new LinkedHashSet<TestEngine>();
        if (config.isTestEngineAutoRegistrationEnabled()) {
            new ServiceLoaderTestEngineRegistry().loadTestEngines().forEach(engines::add);
        }
        engines.addAll(config.getAdditionalTestEngines());
        DefaultLauncher launcher = new DefaultLauncher(engines);
        if (config.isTestExecutionListenerAutoRegistrationEnabled()) {
            new ServiceLoaderTestExecutionListenerRegistry().loadListeners().forEach(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
        }
        config.getAdditionalTestExecutionListeners().forEach(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
        return launcher;
    }
}

