/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import org.gradle.internal.impldep.org.simpleframework.http.ContentType;
import org.gradle.internal.impldep.org.simpleframework.http.core.BodyConsumer;
import org.gradle.internal.impldep.org.simpleframework.http.core.ChunkedConsumer;
import org.gradle.internal.impldep.org.simpleframework.http.core.EmptyConsumer;
import org.gradle.internal.impldep.org.simpleframework.http.core.FixedConsumer;
import org.gradle.internal.impldep.org.simpleframework.http.core.PartListConsumer;
import org.gradle.internal.impldep.org.simpleframework.http.core.Segment;
import org.gradle.internal.impldep.org.simpleframework.util.buffer.Allocator;

class ConsumerFactory {
    protected Allocator allocator;
    protected Segment segment;

    public ConsumerFactory(Allocator allocator, Segment segment) {
        this.allocator = allocator;
        this.segment = segment;
    }

    public BodyConsumer getInstance() {
        int length = this.getContentLength();
        if (length < 0) {
            return this.getInstance(8192);
        }
        return this.getInstance(length);
    }

    public BodyConsumer getInstance(int length) {
        byte[] boundary = this.getBoundary(this.segment);
        if (this.isPart(this.segment)) {
            return new PartListConsumer(this.allocator, boundary, length);
        }
        if (this.isChunked(this.segment)) {
            return new ChunkedConsumer(this.allocator);
        }
        if (this.isFixed(this.segment)) {
            return new FixedConsumer(this.allocator, length);
        }
        return new EmptyConsumer();
    }

    protected byte[] getBoundary(Segment header) {
        String token;
        ContentType type = header.getContentType();
        if (type != null && (token = type.getParameter("boundary")) != null) {
            return token.getBytes();
        }
        return null;
    }

    protected boolean isPart(Segment segment) {
        String token;
        ContentType type = segment.getContentType();
        return type != null && (token = type.getPrimary()).equals("multipart");
    }

    protected boolean isChunked(Segment segment) {
        String encoding = segment.getTransferEncoding();
        return encoding != null && encoding.equals("chunked");
    }

    protected boolean isFixed(Segment segment) {
        int length = segment.getContentLength();
        return length > 0;
    }

    protected int getContentLength() {
        return this.segment.getContentLength();
    }
}

