/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import org.gradle.internal.impldep.org.simpleframework.http.core.Channel;
import org.gradle.internal.impldep.org.simpleframework.http.core.Entity;
import org.gradle.internal.impldep.org.simpleframework.http.core.Initiator;
import org.gradle.internal.impldep.org.simpleframework.http.core.Monitor;
import org.gradle.internal.impldep.org.simpleframework.http.core.Sender;

class FlushMonitor
implements Monitor {
    private Initiator reactor;
    private Channel channel;
    private boolean closed;
    private boolean error;

    public FlushMonitor(Initiator reactor, Entity entity) {
        this.channel = entity.getChannel();
        this.reactor = reactor;
    }

    public void close(Sender sender) {
        try {
            if (!this.isClosed()) {
                this.closed = true;
                sender.close();
            }
        }
        catch (Exception e) {
            this.fail(sender);
        }
    }

    public void error(Sender sender) {
        try {
            if (!this.isClosed()) {
                this.error = true;
                sender.close();
            }
        }
        catch (Exception e) {
            this.fail(sender);
        }
    }

    public void ready(Sender sender) {
        try {
            if (!this.isClosed()) {
                this.closed = true;
                sender.flush();
                this.reactor.start(this.channel);
            }
        }
        catch (Exception e) {
            this.fail(sender);
        }
    }

    private void fail(Sender sender) {
        try {
            sender.close();
        }
        catch (Exception e) {
            return;
        }
    }

    public boolean isClosed() {
        return this.closed || this.error;
    }

    public boolean isError() {
        return this.error;
    }
}

