/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.session;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.org.simpleframework.http.session.Composer;
import org.gradle.internal.impldep.org.simpleframework.http.session.Observer;
import org.gradle.internal.impldep.org.simpleframework.http.session.Session;
import org.gradle.internal.impldep.org.simpleframework.http.session.SessionProvider;
import org.gradle.internal.impldep.org.simpleframework.util.lease.LeaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager<T>
implements SessionProvider<T> {
    private final Composer<T> composer;

    public SessionManager() {
        this(null);
    }

    public SessionManager(Observer<T> observer) {
        this(observer, 1200L, TimeUnit.SECONDS);
    }

    public SessionManager(long duration, TimeUnit unit) {
        this(null, duration, unit);
    }

    public SessionManager(Observer<T> observer, long duration, TimeUnit unit) {
        this.composer = new Composer<T>(observer, duration, unit);
    }

    @Override
    public Session open(T key) throws LeaseException {
        return this.open(key, true);
    }

    @Override
    public Session open(T key, boolean create) throws LeaseException {
        Session<T> session = this.composer.lookup(key);
        if (session != null) {
            return session;
        }
        if (!create) {
            return null;
        }
        return this.composer.compose(key);
    }

    @Override
    public void close() throws LeaseException {
        this.composer.close();
    }
}

