/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.util.lease;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.org.simpleframework.util.lease.Cleaner;
import org.gradle.internal.impldep.org.simpleframework.util.lease.ContractLease;
import org.gradle.internal.impldep.org.simpleframework.util.lease.Controller;
import org.gradle.internal.impldep.org.simpleframework.util.lease.Entry;
import org.gradle.internal.impldep.org.simpleframework.util.lease.Lease;
import org.gradle.internal.impldep.org.simpleframework.util.lease.LeaseProvider;
import org.gradle.internal.impldep.org.simpleframework.util.lease.Maintainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeaseManager<T>
implements LeaseProvider<T> {
    private Controller<T> handler;

    public LeaseManager(Cleaner<T> cleaner) {
        this.handler = new Maintainer<T>(cleaner);
    }

    @Override
    public Lease<T> lease(T key, long duration, TimeUnit unit) {
        Entry<T> contract = new Entry<T>(key, duration, unit);
        try {
            this.handler.issue(contract);
        }
        catch (Exception e) {
            return null;
        }
        return new ContractLease<T>(this.handler, contract);
    }

    @Override
    public void close() {
        try {
            this.handler.close();
        }
        catch (Exception e) {
            return;
        }
    }
}

