/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.AbstractLogEnabled;
import org.gradle.internal.impldep.org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.gradle.internal.impldep.org.sonatype.plexus.components.cipher.PlexusCipher;
import org.gradle.internal.impldep.org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.PasswordDecryptor;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.gradle.internal.impldep.org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class DefaultSecDispatcher
extends AbstractLogEnabled
implements SecDispatcher {
    public static final String SYSTEM_PROPERTY_SEC_LOCATION = "settings.security";
    public static final String TYPE_ATTR = "type";
    public static final char ATTR_START = '[';
    public static final char ATTR_STOP = ']';
    protected PlexusCipher _cipher;
    protected Map _decryptors;
    protected String _configurationFile = "~/.settings-security.xml";

    public String decrypt(String str) throws SecDispatcherException {
        if (!this.isEncryptedString(str)) {
            return str;
        }
        String bare = null;
        try {
            bare = this._cipher.unDecorate(str);
        }
        catch (PlexusCipherException e1) {
            throw new SecDispatcherException(e1);
        }
        try {
            Map attr = this.stripAttributes(bare);
            String res = null;
            SettingsSecurity sec = this.getSec();
            if (attr != null && attr.get(TYPE_ATTR) != null) {
                String type = (String)attr.get(TYPE_ATTR);
                if (this._decryptors == null) {
                    throw new SecDispatcherException("plexus container did not supply any required dispatchers - cannot lookup " + type);
                }
                Map conf = SecUtil.getConfig(sec, type);
                PasswordDecryptor dispatcher = (PasswordDecryptor)this._decryptors.get(type);
                if (dispatcher == null) {
                    throw new SecDispatcherException("no dispatcher for hint " + type);
                }
                String pass = attr == null ? bare : this.strip(bare);
                return dispatcher.decrypt(pass, attr, conf);
            }
            String master = this.getMaster(sec);
            res = this._cipher.decrypt(bare, master);
            return res;
        }
        catch (Exception e) {
            throw new SecDispatcherException(e);
        }
    }

    private String strip(String str) {
        int pos = str.indexOf(93);
        if (pos == str.length()) {
            return null;
        }
        if (pos != -1) {
            return str.substring(pos + 1);
        }
        return str;
    }

    private Map stripAttributes(String str) {
        int start = str.indexOf(91);
        int stop = str.indexOf(93);
        if (start != -1 && stop != -1 && stop > start) {
            if (stop == start + 1) {
                return null;
            }
            String attrs = str.substring(start + 1, stop).trim();
            if (attrs == null || attrs.length() < 1) {
                return null;
            }
            HashMap<String, String> res = null;
            StringTokenizer st = new StringTokenizer(attrs, ", ");
            while (st.hasMoreTokens()) {
                String pair;
                int pos;
                if (res == null) {
                    res = new HashMap<String, String>(st.countTokens());
                }
                if ((pos = (pair = st.nextToken()).indexOf(61)) == -1) continue;
                String key = pair.substring(0, pos).trim();
                if (pos == pair.length()) {
                    res.put(key, null);
                    continue;
                }
                String val = pair.substring(pos + 1);
                res.put(key, val.trim());
            }
            return res;
        }
        return null;
    }

    private boolean isEncryptedString(String str) {
        if (str == null) {
            return false;
        }
        return this._cipher.isEncryptedString(str);
    }

    private SettingsSecurity getSec() throws SecDispatcherException {
        String location = System.getProperty(SYSTEM_PROPERTY_SEC_LOCATION, this.getConfigurationFile());
        String realLocation = location.charAt(0) == '~' ? System.getProperty("user.home") + location.substring(1) : location;
        SettingsSecurity sec = SecUtil.read(realLocation, true);
        if (sec == null) {
            throw new SecDispatcherException("cannot retrieve master password. Please check that " + realLocation + " exists and has data");
        }
        return sec;
    }

    private String getMaster(SettingsSecurity sec) throws SecDispatcherException {
        String master = sec.getMaster();
        if (master == null) {
            throw new SecDispatcherException("master password is not set");
        }
        try {
            return this._cipher.decryptDecorated(master, SYSTEM_PROPERTY_SEC_LOCATION);
        }
        catch (PlexusCipherException e) {
            throw new SecDispatcherException(e);
        }
    }

    public String getConfigurationFile() {
        return this._configurationFile;
    }

    public void setConfigurationFile(String file) {
        this._configurationFile = file;
    }

    private static boolean propertyExists(String[] values, String[] av) {
        if (values != null) {
            int i;
            for (i = 0; i < values.length; ++i) {
                String p = System.getProperty(values[i]);
                if (p == null) continue;
                return true;
            }
            if (av != null) {
                for (i = 0; i < values.length; ++i) {
                    for (int j = 0; j < av.length; ++j) {
                        if (!("--" + values[i]).equals(av[j])) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static final void usage() {
        System.out.println("usage: java -jar ...jar [-m|-p]\n-m: encrypt master password\n-p: encrypt password");
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 1) {
            DefaultSecDispatcher.usage();
            return;
        }
        if ("-m".equals(args[0]) || DefaultSecDispatcher.propertyExists(SYSTEM_PROPERTY_MASTER_PASSWORD, args)) {
            DefaultSecDispatcher.show(true);
        } else if ("-p".equals(args[0]) || DefaultSecDispatcher.propertyExists(SYSTEM_PROPERTY_SERVER_PASSWORD, args)) {
            DefaultSecDispatcher.show(false);
        } else {
            DefaultSecDispatcher.usage();
        }
    }

    private static void show(boolean showMaster) throws Exception {
        if (showMaster) {
            System.out.print("\nsettings master password\n");
        } else {
            System.out.print("\nsettings server password\n");
        }
        System.out.print("enter password: ");
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        String pass = r.readLine();
        System.out.println("\n");
        DefaultPlexusCipher dc = new DefaultPlexusCipher();
        DefaultSecDispatcher dd = new DefaultSecDispatcher();
        dd._cipher = dc;
        if (showMaster) {
            System.out.println(dc.encryptAndDecorate(pass, SYSTEM_PROPERTY_SEC_LOCATION));
        } else {
            SettingsSecurity sec = dd.getSec();
            System.out.println(dc.encryptAndDecorate(pass, dd.getMaster(sec)));
        }
    }
}

