/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.schema.YamlPropertyAdapter;

public class YamlObjectAdapter
implements JsonObjectValueAdapter {
    @NotNull
    private final YAMLMapping myObject;
    @NotNull
    private final NotNullLazyValue<List<JsonPropertyAdapter>> myChildAdapters;

    public YamlObjectAdapter(@NotNull YAMLMapping object) {
        if (object == null) {
            YamlObjectAdapter.$$$reportNull$$$0(0);
        }
        this.myChildAdapters = new NotNullLazyValue<List<JsonPropertyAdapter>>(){

            @NotNull
            protected List<JsonPropertyAdapter> compute() {
                List<JsonPropertyAdapter> list = YamlObjectAdapter.this.computeChildAdapters();
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/schema/YamlObjectAdapter$1", "compute"));
            }
        };
        this.myObject = object;
    }

    public boolean isObject() {
        PsiElement tag = this.myObject.getTag();
        return tag == null || "!!map".equals(tag.getText());
    }

    public boolean isArray() {
        return false;
    }

    public boolean isStringLiteral() {
        return false;
    }

    public boolean isNumberLiteral() {
        return false;
    }

    public boolean isBooleanLiteral() {
        return false;
    }

    @NotNull
    public PsiElement getDelegate() {
        YAMLMapping yAMLMapping = this.myObject;
        if (yAMLMapping == null) {
            YamlObjectAdapter.$$$reportNull$$$0(1);
        }
        return yAMLMapping;
    }

    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return this;
    }

    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return null;
    }

    public boolean shouldCheckIntegralRequirements() {
        return true;
    }

    @NotNull
    public List<JsonPropertyAdapter> getPropertyList() {
        List list = (List)this.myChildAdapters.getValue();
        if (list == null) {
            YamlObjectAdapter.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private List<JsonPropertyAdapter> computeChildAdapters() {
        Collection<YAMLKeyValue> keyValues = this.myObject.getKeyValues();
        ArrayList<JsonPropertyAdapter> adapters = new ArrayList<JsonPropertyAdapter>(keyValues.size());
        for (YAMLKeyValue value : keyValues) {
            if (this.addPropertiesFromReferencedObject(adapters, value)) continue;
            adapters.add(new YamlPropertyAdapter((PsiElement)value));
        }
        ArrayList<JsonPropertyAdapter> arrayList = adapters;
        if (arrayList == null) {
            YamlObjectAdapter.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private boolean addPropertiesFromReferencedObject(List<JsonPropertyAdapter> adapters, YAMLKeyValue value) {
        String keyText = value.getKeyText();
        if (!"<<".equals(keyText)) {
            return false;
        }
        YAMLValue yamlValue = value.getValue();
        PsiElement resolved = YamlObjectAdapter.resolveYamlAlias(yamlValue);
        if (resolved != null) {
            YAMLMapping mapping = (YAMLMapping)ObjectUtils.tryCast((Object)resolved, YAMLMapping.class);
            if (mapping == null) {
                return false;
            }
            List propertyAdapters = (List)RecursionManager.doPreventingRecursion((Object)this.myObject, (boolean)false, () -> new YamlObjectAdapter(mapping).getPropertyList());
            if (propertyAdapters != null) {
                adapters.addAll(propertyAdapters);
                return true;
            }
        }
        if (yamlValue instanceof YAMLMapping) {
            if (PsiTreeUtil.getChildOfType((PsiElement)yamlValue, YAMLAnchor.class) == null) {
                return false;
            }
            adapters.addAll(new YamlObjectAdapter((YAMLMapping)yamlValue).getPropertyList());
            return true;
        }
        return false;
    }

    @Nullable
    static PsiElement resolveYamlAlias(YAMLValue yamlValue) {
        PsiReference reference = yamlValue instanceof YAMLAlias ? yamlValue.getReference() : null;
        PsiElement resolved = reference == null ? null : reference.resolve();
        resolved = resolved == null ? null : resolved.getParent();
        return resolved;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/schema/YamlObjectAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/schema/YamlObjectAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeChildAdapters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

