/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisActionUtils;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAnalysisAction
extends AnAction {
    private static final String DIMENSION_KEY_PREFIX = "ANALYSIS_DLG_";
    private final Supplier<@NlsContexts.DialogTitle String> myTitle;
    private final Supplier<String> myAnalysisNoun;

    protected BaseAnalysisAction(@NlsContexts.DialogTitle String title, @Nls(capitalization=Nls.Capitalization.Title) String analysisNoun) {
        this.myTitle = () -> title;
        this.myAnalysisNoun = () -> analysisNoun;
    }

    protected BaseAnalysisAction(Supplier<String> title, Supplier<String> analysisNoun) {
        this.myTitle = title;
        this.myAnalysisNoun = analysisNoun;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseAnalysisAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && !DumbService.isDumb((Project)project) && this.getInspectionScope(e.getDataContext(), project) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            BaseAnalysisAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        DataContext dataContext = e.getDataContext();
        AnalysisScope scope = this.getInspectionScope(dataContext, project);
        if (scope == null) {
            return;
        }
        String title = this.getDialogTitle();
        String scopeTitle = CodeInsightBundle.message((String)"analysis.scope.title", (Object[])new Object[]{this.myAnalysisNoun.get()});
        Module module = BaseAnalysisAction.getModuleFromContext(dataContext);
        boolean rememberScope = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace());
        AnalysisUIOptions uiOptions = AnalysisUIOptions.getInstance(project);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        List<ModelScopeItem> items = BaseAnalysisActionDialog.standardItems(project, scope, module, element2);
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(title, scopeTitle, project, items, uiOptions, rememberScope){

            protected String getDimensionServiceKey() {
                return BaseAnalysisAction.DIMENSION_KEY_PREFIX + ((Object)((Object)this)).getClass().getName();
            }

            @Override
            protected JComponent getAdditionalActionSettings(Project project) {
                return BaseAnalysisAction.this.getAdditionalActionSettings(project, this);
            }

            protected String getHelpId() {
                return BaseAnalysisAction.this.getHelpTopic();
            }
        };
        if (!dlg.showAndGet()) {
            this.canceled();
            return;
        }
        int oldScopeType = uiOptions.SCOPE_TYPE;
        scope = dlg.getScope(scope);
        if (!rememberScope) {
            uiOptions.SCOPE_TYPE = oldScopeType;
        }
        uiOptions.ANALYZE_TEST_SOURCES = dlg.isInspectTestSources();
        FileDocumentManager.getInstance().saveAllDocuments();
        this.analyze(project, scope);
    }

    @NotNull
    @NlsContexts.DialogTitle
    protected String getDialogTitle() {
        String string = CodeInsightBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{this.myTitle.get()});
        if (string == null) {
            BaseAnalysisAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected String getHelpTopic() {
        return "reference.dialogs.analyzeDependencies.scope";
    }

    protected void canceled() {
    }

    protected abstract void analyze(@NotNull Project var1, @NotNull AnalysisScope var2);

    @Nullable
    private AnalysisScope getInspectionScope(@NotNull DataContext dataContext, @NotNull Project project) {
        if (dataContext == null) {
            BaseAnalysisAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            BaseAnalysisAction.$$$reportNull$$$0(4);
        }
        return AnalysisActionUtils.getInspectionScope(dataContext, project, this.acceptNonProjectDirectories());
    }

    protected boolean acceptNonProjectDirectories() {
        return false;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog2) {
        return null;
    }

    @Nullable
    private static Module getModuleFromContext(@NotNull DataContext dataContext) {
        AnalysisScope scope;
        InspectionResultsView inspectionView;
        if (dataContext == null) {
            BaseAnalysisAction.$$$reportNull$$$0(5);
        }
        if ((inspectionView = (InspectionResultsView)dataContext.getData(InspectionResultsView.DATA_KEY)) != null && (scope = inspectionView.getScope()).getScopeType() == 4 && scope.isValid()) {
            return scope.getModule();
        }
        return (Module)dataContext.getData(LangDataKeys.MODULE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/BaseAnalysisAction";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/BaseAnalysisAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleFromContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

