/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.ExcludeListDialog;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.PopupActionsKt;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J!\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeInsight/hints/BlacklistCurrentMethodIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "isMethodHintAtOffset", "showHint", "language", "Lcom/intellij/lang/Language;", "info", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "showSettings", "startInWriteAction", "undo", "intellij.platform.lang.impl"})
public final class BlacklistCurrentMethodIntention
implements IntentionAction,
LowPriorityAction {
    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"inlay.hints.blacklist.method", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeInsightBundle.messag\u2026.hints.blacklist.method\")");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"inlay.hints.intention.family.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeInsightBundle.messag\u2026s.intention.family.name\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
        Language language2 = language;
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language2);
        if (inlayParameterHintsProvider == null) {
            return false;
        }
        InlayParameterHintsProvider hintsProvider = inlayParameterHintsProvider;
        return hintsProvider.isBlackListSupported() && PopupActionsKt.access$hasEditorParameterHintAtOffset(editor, file2) && this.isMethodHintAtOffset(editor, file2);
    }

    private final boolean isMethodHintAtOffset(Editor editor, PsiFile file2) {
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        return PopupActionsKt.access$getHintInfoFromProvider(offset, file2, editor) instanceof HintInfo.MethodInfo;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        HintInfo hintInfo = PopupActionsKt.access$getHintInfoFromProvider(offset, file2, editor);
        if (!(hintInfo instanceof HintInfo.MethodInfo)) {
            hintInfo = null;
        }
        HintInfo.MethodInfo methodInfo = (HintInfo.MethodInfo)hintInfo;
        if (methodInfo == null) {
            return;
        }
        HintInfo.MethodInfo info = methodInfo;
        Language language = info.getLanguage();
        if (language == null) {
            Language language2 = file2.getLanguage();
            language = language2;
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"file.language");
        }
        Language language3 = language;
        ParameterNameHintsSettings.Companion.getInstance().addIgnorePattern(HintUtilsKt.getLanguageForSettingKey(language3), PopupActionsKt.toPattern(info));
        PopupActionsKt.access$refreshAllOpenEditors();
        this.showHint(project, language3, info);
    }

    private final void showHint(Project project, Language language, HintInfo.MethodInfo info) {
        String methodName = info.getMethodName();
        NotificationListener listener2 = new NotificationListener(this, language, info){
            final /* synthetic */ BlacklistCurrentMethodIntention this$0;
            final /* synthetic */ Language $language;
            final /* synthetic */ HintInfo.MethodInfo $info;

            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = event.getDescription();
                if (string != null) {
                    switch (string) {
                        case "settings": {
                            BlacklistCurrentMethodIntention.access$showSettings(this.this$0, this.$language);
                            break;
                        }
                        case "undo": {
                            BlacklistCurrentMethodIntention.access$undo(this.this$0, this.$language, this.$info);
                            break;
                        }
                    }
                }
                notification2.expire();
            }
            {
                this.this$0 = blacklistCurrentMethodIntention;
                this.$language = language;
                this.$info = methodInfo;
            }
        };
        Notification notification2 = new Notification("Parameter Name Hints", CodeInsightBundle.message((String)"notification.inlay.method.added.to.blacklist", (Object[])new Object[]{methodName}), CodeInsightBundle.message((String)"notification.show.parameter.hints.settings.or.undo.label", (Object[])new Object[0]), NotificationType.INFORMATION, listener2);
        notification2.notify(project);
    }

    private final void showSettings(Language language) {
        new ExcludeListDialog(language, null, 2, null).show();
    }

    private final void undo(Language language, HintInfo.MethodInfo info) {
        ParameterNameHintsSettings settings = ParameterNameHintsSettings.Companion.getInstance();
        Language languageForSettings = HintUtilsKt.getLanguageForSettingKey(language);
        Diff diff = settings.getBlackListDiff(languageForSettings);
        Set set2 = CollectionsKt.toMutableSet((Iterable)diff.getAdded());
        boolean bl = false;
        boolean bl2 = false;
        Set $this$apply = set2;
        boolean bl3 = false;
        $this$apply.remove(PopupActionsKt.toPattern(info));
        Set updated = set2;
        settings.setBlackListDiff(languageForSettings, new Diff(updated, diff.getRemoved()));
        PopupActionsKt.access$refreshAllOpenEditors();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static final /* synthetic */ void access$showSettings(BlacklistCurrentMethodIntention $this, Language language) {
        $this.showSettings(language);
    }

    public static final /* synthetic */ void access$undo(BlacklistCurrentMethodIntention $this, Language language, HintInfo.MethodInfo info) {
        $this.undo(language, info);
    }
}

