/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionGroup;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedIntentions {
    private static final Logger LOG = Logger.getInstance(CachedIntentions.class);
    private final Set<IntentionActionWithTextCaching> myIntentions;
    private final Set<IntentionActionWithTextCaching> myErrorFixes;
    private final Set<IntentionActionWithTextCaching> myInspectionFixes;
    private final Set<IntentionActionWithTextCaching> myGutters;
    private final Set<IntentionActionWithTextCaching> myNotifications;
    private int myOffset;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Project myProject;
    private static final TObjectHashingStrategy<IntentionActionWithTextCaching> ACTION_TEXT_AND_CLASS_EQUALS = new TObjectHashingStrategy<IntentionActionWithTextCaching>(){

        public int computeHashCode(IntentionActionWithTextCaching object) {
            return object.getText().hashCode();
        }

        public boolean equals(IntentionActionWithTextCaching o1, IntentionActionWithTextCaching o2) {
            return this.getActionClass(o1) == this.getActionClass(o2) && o1.getText().equals(o2.getText());
        }

        private Class<? extends IntentionAction> getActionClass(IntentionActionWithTextCaching o1) {
            return IntentionActionDelegate.unwrap((IntentionAction)o1.getAction()).getClass();
        }
    };

    public CachedIntentions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(1);
        }
        this.myIntentions = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myErrorFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myInspectionFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myGutters = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myNotifications = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myProject = project;
        this.myFile = file2;
        this.myEditor = editor;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getIntentions() {
        Set<IntentionActionWithTextCaching> set2 = this.myIntentions;
        if (set2 == null) {
            CachedIntentions.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getErrorFixes() {
        Set<IntentionActionWithTextCaching> set2 = this.myErrorFixes;
        if (set2 == null) {
            CachedIntentions.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getInspectionFixes() {
        Set<IntentionActionWithTextCaching> set2 = this.myInspectionFixes;
        if (set2 == null) {
            CachedIntentions.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getGutters() {
        Set<IntentionActionWithTextCaching> set2 = this.myGutters;
        if (set2 == null) {
            CachedIntentions.$$$reportNull$$$0(5);
        }
        return set2;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getNotifications() {
        Set<IntentionActionWithTextCaching> set2 = this.myNotifications;
        if (set2 == null) {
            CachedIntentions.$$$reportNull$$$0(6);
        }
        return set2;
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            CachedIntentions.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(8);
        }
        return project;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public static CachedIntentions create(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(10);
        }
        if (intentions == null) {
            CachedIntentions.$$$reportNull$$$0(11);
        }
        CachedIntentions res2 = new CachedIntentions(project, file2, editor);
        res2.wrapAndUpdateActions(intentions, false);
        CachedIntentions cachedIntentions = res2;
        if (cachedIntentions == null) {
            CachedIntentions.$$$reportNull$$$0(12);
        }
        return cachedIntentions;
    }

    @NotNull
    public static CachedIntentions createAndUpdateActions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(14);
        }
        if (intentions == null) {
            CachedIntentions.$$$reportNull$$$0(15);
        }
        CachedIntentions res2 = new CachedIntentions(project, file2, editor);
        res2.wrapAndUpdateActions(intentions, true);
        CachedIntentions cachedIntentions = res2;
        if (cachedIntentions == null) {
            CachedIntentions.$$$reportNull$$$0(16);
        }
        return cachedIntentions;
    }

    public boolean wrapAndUpdateActions(@NotNull ShowIntentionsPass.IntentionsInfo newInfo, boolean callUpdate) {
        if (newInfo == null) {
            CachedIntentions.$$$reportNull$$$0(17);
        }
        this.myOffset = newInfo.getOffset();
        boolean changed2 = this.wrapActionsTo(newInfo.errorFixesToShow, this.myErrorFixes, callUpdate);
        changed2 |= this.wrapActionsTo(newInfo.inspectionFixesToShow, this.myInspectionFixes, callUpdate);
        changed2 |= this.wrapActionsTo(newInfo.intentionsToShow, this.myIntentions, callUpdate);
        changed2 |= this.wrapActionsTo(newInfo.guttersToShow, this.myGutters, callUpdate);
        return changed2 |= this.wrapActionsTo(newInfo.notificationActionsToShow, this.myNotifications, callUpdate);
    }

    public boolean addActions(@NotNull ShowIntentionsPass.IntentionsInfo info) {
        if (info == null) {
            CachedIntentions.$$$reportNull$$$0(18);
        }
        boolean changed2 = this.addActionsTo(info.errorFixesToShow, this.myErrorFixes);
        changed2 |= this.addActionsTo(info.inspectionFixesToShow, this.myInspectionFixes);
        changed2 |= this.addActionsTo(info.intentionsToShow, this.myIntentions);
        changed2 |= this.addActionsTo(info.guttersToShow, this.myGutters);
        return changed2 |= this.addActionsTo(info.notificationActionsToShow, this.myNotifications);
    }

    private boolean addActionsTo(@NotNull List<? extends HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull Set<? super IntentionActionWithTextCaching> cachedActions) {
        if (newDescriptors == null) {
            CachedIntentions.$$$reportNull$$$0(19);
        }
        if (cachedActions == null) {
            CachedIntentions.$$$reportNull$$$0(20);
        }
        boolean changed2 = false;
        for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : newDescriptors) {
            changed2 |= cachedActions.add(this.wrapAction(intentionActionDescriptor, (PsiElement)this.myFile, this.myFile, this.myEditor));
        }
        return changed2;
    }

    private boolean wrapActionsTo(@NotNull List<? extends HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull Set<IntentionActionWithTextCaching> cachedActions, boolean shouldCallIsAvailable) {
        Editor injectedEditor;
        PsiFile injectedFile;
        PsiElement element2;
        PsiFile hostElement;
        int n;
        if (newDescriptors == null) {
            CachedIntentions.$$$reportNull$$$0(21);
        }
        if (cachedActions == null) {
            CachedIntentions.$$$reportNull$$$0(22);
        }
        if (cachedActions.isEmpty() && newDescriptors.isEmpty()) {
            return false;
        }
        boolean changed2 = false;
        if (this.myEditor == null) {
            LOG.assertTrue(!shouldCallIsAvailable);
            for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : newDescriptors) {
                changed2 |= cachedActions.add(this.wrapAction(intentionActionDescriptor, (PsiElement)this.myFile, this.myFile, null));
            }
            return changed2;
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        int n2 = n = caretOffset > 0 && caretOffset == this.myFile.getTextLength() ? caretOffset - 1 : caretOffset;
        if (this.myFile instanceof PsiCompiledElement) {
            PsiFile element22;
            hostElement = element22 = this.myFile;
        } else if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
            FileViewProvider viewProvider = this.myFile.getViewProvider();
            element2 = viewProvider.findElementAt(n, viewProvider.getBaseLanguage());
            hostElement = element2;
        } else {
            hostElement = this.myFile.getViewProvider().findElementAt(n, this.myFile.getLanguage());
            element2 = InjectedLanguageUtil.findElementAtNoCommit(this.myFile, n);
        }
        if (element2 == null || element2 == hostElement) {
            injectedFile = this.myFile;
            injectedEditor = this.myEditor;
        } else {
            injectedFile = element2.getContainingFile();
            injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
        }
        if (shouldCallIsAvailable) {
            Iterator<IntentionActionWithTextCaching> iterator2 = cachedActions.iterator();
            while (iterator2.hasNext()) {
                IntentionActionWithTextCaching cachedAction = iterator2.next();
                IntentionAction intentionAction = cachedAction.getAction();
                Pair<PsiFile, Editor> applicableIn = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(this.myFile, this.myEditor, injectedFile, (PairProcessor<? super PsiFile, ? super Editor>)((PairProcessor)(f, e) -> ShowIntentionActionsHandler.availableFor(f, e, action2)));
                if (applicableIn != null) continue;
                iterator2.remove();
                changed2 = true;
            }
        }
        THashSet wrappedNew = new THashSet(newDescriptors.size(), ACTION_TEXT_AND_CLASS_EQUALS);
        for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : newDescriptors) {
            IntentionActionWithTextCaching cachedAction;
            IntentionAction action3 = intentionActionDescriptor.getAction();
            if (element2 != null && element2 != hostElement && (!shouldCallIsAvailable || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action3))) {
                cachedAction = this.wrapAction(intentionActionDescriptor, element2, injectedFile, injectedEditor);
                wrappedNew.add(cachedAction);
                changed2 |= cachedActions.add(cachedAction);
                continue;
            }
            if (hostElement == null || shouldCallIsAvailable && !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action3)) continue;
            cachedAction = this.wrapAction(intentionActionDescriptor, (PsiElement)hostElement, this.myFile, this.myEditor);
            wrappedNew.add(cachedAction);
            changed2 |= cachedActions.add(cachedAction);
        }
        Iterator<IntentionActionWithTextCaching> iterator3 = cachedActions.iterator();
        while (iterator3.hasNext()) {
            IntentionActionWithTextCaching intentionActionWithTextCaching = iterator3.next();
            if (wrappedNew.contains(intentionActionWithTextCaching)) continue;
            iterator3.remove();
            changed2 = true;
        }
        return changed2;
    }

    @NotNull
    IntentionActionWithTextCaching wrapAction(@NotNull HighlightInfo.IntentionActionDescriptor descriptor2, @NotNull PsiElement element2, @NotNull PsiFile containingFile, @Nullable Editor containingEditor) {
        if (descriptor2 == null) {
            CachedIntentions.$$$reportNull$$$0(23);
        }
        if (element2 == null) {
            CachedIntentions.$$$reportNull$$$0(24);
        }
        if (containingFile == null) {
            CachedIntentions.$$$reportNull$$$0(25);
        }
        IntentionActionWithTextCaching cachedAction = new IntentionActionWithTextCaching(descriptor2, (cached, action2) -> {
            if (action2 instanceof QuickFixWrapper) {
                this.removeActionFromCached((IntentionActionWithTextCaching)cached);
                this.markInvoked((IntentionAction)action2);
            }
        });
        List<IntentionAction> options2 = descriptor2.getOptions(element2, containingEditor);
        if (options2 == null) {
            IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
            if (intentionActionWithTextCaching == null) {
                CachedIntentions.$$$reportNull$$$0(26);
            }
            return intentionActionWithTextCaching;
        }
        for (IntentionAction option2 : options2) {
            boolean isInspectionFix;
            Pair<PsiFile, Editor> availableIn;
            Editor editor = (Editor)ObjectUtils.chooseNotNull((Object)this.myEditor, (Object)containingEditor);
            if (editor == null || (availableIn = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(this.myFile, editor, containingFile, (PairProcessor<? super PsiFile, ? super Editor>)((PairProcessor)(f, e) -> ShowIntentionActionsHandler.availableFor(f, e, option2)))) == null) continue;
            IntentionActionWithTextCaching textCaching = new IntentionActionWithTextCaching(option2);
            boolean isErrorFix = this.myErrorFixes.contains(textCaching);
            if (isErrorFix) {
                cachedAction.addErrorFix(option2);
            }
            if (isInspectionFix = this.myInspectionFixes.contains(textCaching)) {
                cachedAction.addInspectionFix(option2);
                continue;
            }
            cachedAction.addIntention(option2);
        }
        IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
        if (intentionActionWithTextCaching == null) {
            CachedIntentions.$$$reportNull$$$0(27);
        }
        return intentionActionWithTextCaching;
    }

    private void markInvoked(@NotNull IntentionAction action2) {
        if (action2 == null) {
            CachedIntentions.$$$reportNull$$$0(28);
        }
        if (this.myEditor != null) {
            ShowIntentionsPass.markActionInvoked(this.myFile.getProject(), this.myEditor, action2);
        }
    }

    private void removeActionFromCached(@NotNull IntentionActionWithTextCaching action2) {
        if (action2 == null) {
            CachedIntentions.$$$reportNull$$$0(29);
        }
        this.myErrorFixes.remove(action2);
        this.myGutters.remove(action2);
        this.myInspectionFixes.remove(action2);
        this.myIntentions.remove(action2);
        this.myNotifications.remove(action2);
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getAllActions() {
        List<IntentionActionWithTextCaching> result2 = new ArrayList<IntentionActionWithTextCaching>(this.myErrorFixes);
        result2.addAll(this.myInspectionFixes);
        result2.addAll(this.myIntentions);
        result2.addAll(this.myGutters);
        result2.addAll(this.myNotifications);
        result2 = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(result2);
        result2.sort((o1, o2) -> {
            int weight2;
            int weight1 = this.getWeight((IntentionActionWithTextCaching)o1);
            if (weight1 != (weight2 = this.getWeight((IntentionActionWithTextCaching)o2))) {
                return weight2 - weight1;
            }
            return o1.compareTo((IntentionActionWithTextCaching)o2);
        });
        List<IntentionActionWithTextCaching> list2 = result2;
        if (list2 == null) {
            CachedIntentions.$$$reportNull$$$0(30);
        }
        return list2;
    }

    private int getWeight(@NotNull IntentionActionWithTextCaching action2) {
        if (action2 == null) {
            CachedIntentions.$$$reportNull$$$0(31);
        }
        IntentionAction a = action2.getAction();
        int group2 = this.getGroup(action2).getPriority();
        while (a instanceof IntentionActionDelegate) {
            a = ((IntentionActionDelegate)a).getDelegate();
        }
        if (a instanceof PriorityAction) {
            return group2 + CachedIntentions.getPriorityWeight(((PriorityAction)a).getPriority());
        }
        if (a instanceof SuppressIntentionActionFromFix && ((SuppressIntentionActionFromFix)a).isShouldBeAppliedToInjectionHost() == ThreeState.NO) {
            return group2 - 1;
        }
        return group2;
    }

    private static int getPriorityWeight(PriorityAction.Priority priority) {
        switch (priority) {
            case TOP: {
                return 20;
            }
            case HIGH: {
                return 3;
            }
            case LOW: {
                return -3;
            }
        }
        return 0;
    }

    @NotNull
    public IntentionGroup getGroup(@NotNull IntentionActionWithTextCaching action2) {
        if (action2 == null) {
            CachedIntentions.$$$reportNull$$$0(32);
        }
        if (this.myErrorFixes.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.ERROR;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(33);
            }
            return intentionGroup;
        }
        if (this.myInspectionFixes.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.INSPECTION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(34);
            }
            return intentionGroup;
        }
        if (this.myNotifications.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.NOTIFICATION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(35);
            }
            return intentionGroup;
        }
        if (this.myGutters.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.GUTTER;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(36);
            }
            return intentionGroup;
        }
        if (action2.getAction() instanceof EmptyIntentionAction) {
            IntentionGroup intentionGroup = IntentionGroup.EMPTY_ACTION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(37);
            }
            return intentionGroup;
        }
        IntentionGroup intentionGroup = IntentionGroup.OTHER;
        if (intentionGroup == null) {
            CachedIntentions.$$$reportNull$$$0(38);
        }
        return intentionGroup;
    }

    @NotNull
    public Icon getIcon(@NotNull IntentionActionWithTextCaching value2) {
        Icon icon2;
        if (value2 == null) {
            CachedIntentions.$$$reportNull$$$0(39);
        }
        if (value2.getIcon() != null) {
            Icon icon3 = value2.getIcon();
            if (icon3 == null) {
                CachedIntentions.$$$reportNull$$$0(40);
            }
            return icon3;
        }
        IntentionAction action2 = value2.getAction();
        while (action2 instanceof IntentionActionDelegate) {
            action2 = ((IntentionActionDelegate)action2).getDelegate();
        }
        IntentionAction iconable = action2;
        if (action2 instanceof QuickFixWrapper) {
            iconable = ((QuickFixWrapper)action2).getFix();
        }
        if (iconable instanceof Iconable && (icon2 = ((Iconable)iconable).getIcon(0)) != null) {
            Icon icon4 = icon2;
            if (icon4 == null) {
                CachedIntentions.$$$reportNull$$$0(41);
            }
            return icon4;
        }
        if (IntentionManagerSettings.getInstance().isShowLightBulb(action2)) {
            Icon icon5 = this.myErrorFixes.contains(value2) ? AllIcons.Actions.QuickfixBulb : (this.myInspectionFixes.contains(value2) ? AllIcons.Actions.IntentionBulb : AllIcons.Actions.RealIntentionBulb);
            if (icon5 == null) {
                CachedIntentions.$$$reportNull$$$0(42);
            }
            return icon5;
        }
        if (this.myErrorFixes.contains(value2)) {
            Icon icon6 = AllIcons.Actions.QuickfixOffBulb;
            if (icon6 == null) {
                CachedIntentions.$$$reportNull$$$0(43);
            }
            return icon6;
        }
        Icon icon7 = IconLoader.getDisabledIcon((Icon)AllIcons.Actions.RealIntentionBulb);
        if (icon7 == null) {
            CachedIntentions.$$$reportNull$$$0(44);
        }
        return icon7;
    }

    public boolean showBulb() {
        return ContainerUtil.exists(this.getAllActions(), info -> IntentionManagerSettings.getInstance().isShowLightBulb(info.getAction()));
    }

    public String toString() {
        return "CachedIntentions{myIntentions=" + this.myIntentions + ", myErrorFixes=" + this.myErrorFixes + ", myInspectionFixes=" + this.myInspectionFixes + ", myGutters=" + this.myGutters + ", myNotifications=" + this.myNotifications + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/CachedIntentions";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDescriptors";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedActions";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/CachedIntentions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorFixes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionFixes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGutters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndUpdateActions";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAction";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllActions";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createAndUpdateActions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndUpdateActions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addActionsTo";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "wrapActionsTo";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "wrapAction";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "markInvoked";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeActionFromCached";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

