/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoImplementationHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.implementation";
    }

    @Override
    @Nullable
    public GotoTargetHandler.GotoData getSourceAndTargetElements(@NotNull Editor editor, PsiFile file2) {
        if (editor == null) {
            GotoImplementationHandler.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
        if (source == null && (offset = GotoImplementationHandler.tryGetNavigationSourceOffsetFromGutterIcon(editor, "GotoImplementation")) >= 0) {
            source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
        }
        if (source == null) {
            return null;
        }
        return this.createDataForSource(editor, offset, source);
    }

    @NotNull
    private GotoTargetHandler.GotoData createDataForSource(@NotNull Editor editor, int offset, PsiElement source) {
        TargetElementUtil instance;
        PsiReference reference2;
        PsiElement[] targets2;
        if (editor == null) {
            GotoImplementationHandler.$$$reportNull$$$0(1);
        }
        if ((targets2 = new ImplementationSearcher.FirstImplementationsSearcher(reference2 = TargetElementUtil.findReference(editor, offset), instance = TargetElementUtil.getInstance()){
            final /* synthetic */ PsiReference val$reference;
            final /* synthetic */ TargetElementUtil val$instance;
            {
                this.val$reference = psiReference;
                this.val$instance = targetElementUtil;
            }

            @Override
            protected boolean accept(PsiElement element2) {
                if (this.val$reference != null && !this.val$reference.getElement().isValid()) {
                    return false;
                }
                return this.val$instance.acceptImplementationForReference(this.val$reference, element2);
            }

            @Override
            protected boolean canShowPopupWithOneItem(PsiElement element2) {
                return false;
            }
        }.searchImplementations(editor, source, offset)) == null) {
            GotoTargetHandler.GotoData data2 = new GotoTargetHandler.GotoData(source, PsiElement.EMPTY_ARRAY, Collections.emptyList());
            data2.isCanceled = true;
            GotoTargetHandler.GotoData gotoData = data2;
            if (gotoData == null) {
                GotoImplementationHandler.$$$reportNull$$$0(2);
            }
            return gotoData;
        }
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, targets2, Collections.emptyList());
        gotoData.listUpdaterTask = new ImplementationsUpdaterTask(gotoData, editor, offset, reference2){

            @Override
            public void onSuccess() {
                super.onSuccess();
                PsiElement oneElement = this.getTheOnlyOneElement();
                if (oneElement != null && GotoImplementationHandler.this.navigateToElement(oneElement)) {
                    this.myPopup.cancel();
                }
            }
        };
        GotoTargetHandler.GotoData gotoData2 = gotoData;
        if (gotoData2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(3);
        }
        return gotoData2;
    }

    public static int tryGetNavigationSourceOffsetFromGutterIcon(@NotNull Editor editor, String actionId) {
        if (editor == null) {
            GotoImplementationHandler.$$$reportNull$$$0(4);
        }
        int line = editor.getCaretModel().getVisualPosition().line;
        List<GutterMark> renderers = ((EditorGutterComponentEx)editor.getGutter()).getGutterRenderers(line);
        ArrayList<PsiElement> elementCandidates = new ArrayList<PsiElement>();
        for (GutterMark renderer2 : renderers) {
            if (!(renderer2 instanceof LineMarkerInfo.LineMarkerGutterIconRenderer)) continue;
            LineMarkerInfo.LineMarkerGutterIconRenderer lineMarkerRenderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)renderer2;
            AnAction clickAction = ((LineMarkerInfo.LineMarkerGutterIconRenderer)renderer2).getClickAction();
            if (!(clickAction instanceof NavigateAction) || !actionId.equals(((NavigateAction)clickAction).getOriginalActionId())) continue;
            elementCandidates.add(lineMarkerRenderer.getLineMarkerInfo().getElement());
        }
        if (elementCandidates.size() == 1) {
            return ((PsiElement)elementCandidates.iterator().next()).getTextRange().getStartOffset();
        }
        return -1;
    }

    @Override
    protected void chooseFromAmbiguousSources(Editor editor, PsiFile file2, Consumer<? super GotoTargetHandler.GotoData> successCallback) {
        int offset = editor.getCaretModel().getOffset();
        PsiElementProcessor navigateProcessor = element2 -> {
            GotoTargetHandler.GotoData data2 = this.createDataForSource(editor, offset, element2);
            successCallback.consume((Object)data2);
            return true;
        };
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        GotoDeclarationAction.chooseAmbiguousTarget(project, editor, offset, (PsiElementProcessor<? super PsiElement>)navigateProcessor, CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0]), null);
    }

    private static PsiElement getContainer(PsiElement refElement) {
        for (ContainerProvider provider2 : (ContainerProvider[])ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider2.getContainer(refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    @Override
    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, @Nullable String name, int length, boolean finished2) {
        Object fullName;
        ItemPresentation presentation2;
        if (sourceElement == null) {
            GotoImplementationHandler.$$$reportNull$$$0(5);
        }
        if ((presentation2 = ((NavigationItem)sourceElement).getPresentation()) == null) {
            fullName = name;
        } else {
            PsiElement container = GotoImplementationHandler.getContainer(sourceElement);
            ItemPresentation containerPresentation = container == null || container instanceof PsiFile ? null : ((NavigationItem)container).getPresentation();
            String containerText = containerPresentation == null ? null : containerPresentation.getPresentableText();
            fullName = (String)(containerText == null ? "" : containerText + ".") + presentation2.getPresentableText();
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.chooserTitle", (Object[])new Object[]{fullName == null ? "unnamed element" : StringUtil.escapeXmlEntities((String)fullName), length, finished2 ? "" : " so far"});
        if (string == null) {
            GotoImplementationHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        if (sourceElement == null) {
            GotoImplementationHandler.$$$reportNull$$$0(7);
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.findUsages.title", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)name), length});
        if (string == null) {
            GotoImplementationHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            GotoImplementationHandler.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            GotoImplementationHandler.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(11);
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.notFound", (Object[])new Object[0]);
        if (string == null) {
            GotoImplementationHandler.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/GotoImplementationHandler";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/GotoImplementationHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataForSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChooserTitle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesTitle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSourceAndTargetElements";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDataForSource";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryGetNavigationSourceOffsetFromGutterIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChooserTitle";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesTitle";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoundMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ImplementationsUpdaterTask
    extends BackgroundUpdaterTask {
        private final Editor myEditor;
        private final int myOffset;
        private final GotoTargetHandler.GotoData myGotoData;
        private final PsiReference myReference;

        ImplementationsUpdaterTask(final @NotNull GotoTargetHandler.GotoData gotoData, Editor editor, int offset, PsiReference reference2) {
            if (gotoData == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(1);
            }
            super(gotoData.source.getProject(), ImplementationSearcher.getSearchingForImplementations(), ImplementationsUpdaterTask.createComparatorWrapper(Comparator.comparing(new Function<PsiElement, Comparable>(){

                @Override
                public Comparable apply(PsiElement e1) {
                    return GotoImplementationHandler.this.getRenderer(e1, gotoData).getComparingObject(e1);
                }
            })));
            this.myEditor = editor;
            this.myOffset = offset;
            this.myGotoData = gotoData;
            this.myReference = reference2;
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(2);
            }
            super.run(indicator);
            for (PsiElement element2 : this.myGotoData.targets) {
                if (this.updateComponent(element2)) continue;
                return;
            }
            new ImplementationSearcher.BackgroundableImplementationSearcher(){

                @Override
                protected void processElement(PsiElement element2) {
                    indicator.checkCanceled();
                    if (!TargetElementUtil.getInstance().acceptImplementationForReference(ImplementationsUpdaterTask.this.myReference, element2)) {
                        return;
                    }
                    if (ImplementationsUpdaterTask.this.myGotoData.addTarget(element2) && !ImplementationsUpdaterTask.this.updateComponent(element2)) {
                        indicator.cancel();
                    }
                }
            }.searchImplementations(this.myEditor, this.myGotoData.source, this.myOffset);
        }

        @Override
        public String getCaption(int size) {
            String name = ElementDescriptionUtil.getElementDescription((PsiElement)this.myGotoData.source, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
            return GotoImplementationHandler.this.getChooserTitle(this.myGotoData.source, name, size, this.isFinished());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gotoData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/GotoImplementationHandler$ImplementationsUpdaterTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

