/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DebugLogManager;
import com.intellij.diagnostic.DebugLogManagerKt;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0003\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\u0011\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J \u0010\u0012\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diagnostic/DebugLogManager;", "", "()V", "applyCategories", "", "categories", "", "Lcom/intellij/diagnostic/DebugLogManager$Category;", "level", "Lcom/intellij/diagnostic/DebugLogManager$DebugLogLevel;", "log4jLevel", "Lorg/apache/log4j/Level;", "clearCategories", "fromString", "text", "", "getSavedCategories", "saveCategories", "toString", "Category", "Companion", "DebugLogLevel", "intellij.platform.ide.impl"})
public final class DebugLogManager {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Category> getSavedCategories() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        List list2 = ContainerUtil.concat(this.fromString(properties.getValue("log.debug.categories"), DebugLogLevel.DEBUG), this.fromString(properties.getValue("log.trace.categories"), DebugLogLevel.TRACE));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ContainerUtil.concat(fro\u2026S), DebugLogLevel.TRACE))");
        return list2;
    }

    public final void clearCategories(@NotNull List<Category> categories) {
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Iterable $this$forEach$iv = categories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Category it = (Category)element$iv;
            boolean bl = false;
            Logger logger = LogManager.getLogger((String)it.getCategory());
            if (logger == null) continue;
            logger.setLevel((Level)null);
        }
    }

    public final void applyCategories(@NotNull List<Category> categories) {
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Level level = Level.DEBUG;
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.DEBUG");
        this.applyCategories(categories, DebugLogLevel.DEBUG, level);
        Level level2 = Level.TRACE;
        Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"Level.TRACE");
        this.applyCategories(categories, DebugLogLevel.TRACE, level2);
    }

    private final void applyCategories(List<Category> categories, DebugLogLevel level, Level log4jLevel) {
        List filtered2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)categories), (Function1)((Function1)new Function1<Category, Boolean>(level){
            final /* synthetic */ DebugLogLevel $level;

            public final boolean invoke(@NotNull Category it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getLevel() == this.$level;
            }
            {
                this.$level = debugLogLevel;
                super(1);
            }
        })), (Function1)applyCategories.filtered.2.INSTANCE));
        Iterable $this$forEach$iv = filtered2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Logger logger = LogManager.getLogger((String)it);
            if (logger == null) continue;
            logger.setLevel(log4jLevel);
        }
        Collection collection = filtered2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            DebugLogManagerKt.access$getLOG$p().info("Set " + level.name() + " for the following categories: " + CollectionsKt.joinToString$default((Iterable)filtered2, null, null, null, (int)0, null, null, (int)63, null));
        }
    }

    public final void saveCategories(@NotNull List<Category> categories) {
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue("log.debug.categories", this.toString(categories, DebugLogLevel.DEBUG), null);
        properties.setValue("log.trace.categories", this.toString(categories, DebugLogLevel.TRACE), null);
    }

    private final List<Category> fromString(String text2, DebugLogLevel level) {
        return text2 != null ? SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)StringsKt.lineSequence((CharSequence)text2), (Function1)((Function1)new Function1<String, Category>(level){
            final /* synthetic */ DebugLogLevel $level;

            @Nullable
            public final Category invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.isBlank((CharSequence)it) ? null : new Category(it, this.$level);
            }
            {
                this.$level = debugLogLevel;
                super(1);
            }
        }))) : CollectionsKt.emptyList();
    }

    private final String toString(List<Category> categories, DebugLogLevel level) {
        List filtered2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)categories), (Function1)((Function1)new Function1<Category, Boolean>(level){
            final /* synthetic */ DebugLogLevel $level;

            public final boolean invoke(@NotNull Category it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getLevel() == this.$level;
            }
            {
                this.$level = debugLogLevel;
                super(1);
            }
        })), (Function1)toString.filtered.2.INSTANCE));
        Collection collection = filtered2;
        boolean bl = false;
        return !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)filtered2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : null;
    }

    public DebugLogManager() {
        boolean bl = false;
        List categories = new ArrayList();
        categories.addAll((Collection)this.getSavedCategories());
        categories.addAll((Collection)this.fromString(System.getProperty("idea.log.debug.categories"), DebugLogLevel.DEBUG));
        categories.addAll((Collection)this.fromString(System.getProperty("idea.log.trace.categories"), DebugLogLevel.TRACE));
        this.applyCategories(categories);
    }

    @JvmStatic
    @NotNull
    public static final DebugLogManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/diagnostic/DebugLogManager$DebugLogLevel;", "", "(Ljava/lang/String;I)V", "DEBUG", "TRACE", "intellij.platform.ide.impl"})
    public static final class DebugLogLevel
    extends Enum<DebugLogLevel> {
        public static final /* enum */ DebugLogLevel DEBUG;
        public static final /* enum */ DebugLogLevel TRACE;
        private static final /* synthetic */ DebugLogLevel[] $VALUES;

        static {
            DebugLogLevel[] debugLogLevelArray = new DebugLogLevel[2];
            DebugLogLevel[] debugLogLevelArray2 = debugLogLevelArray;
            debugLogLevelArray[0] = DEBUG = new DebugLogLevel();
            debugLogLevelArray[1] = TRACE = new DebugLogLevel();
            $VALUES = debugLogLevelArray;
        }

        public static DebugLogLevel[] values() {
            return (DebugLogLevel[])$VALUES.clone();
        }

        public static DebugLogLevel valueOf(String string) {
            return Enum.valueOf(DebugLogLevel.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diagnostic/DebugLogManager$Category;", "", "category", "", "level", "Lcom/intellij/diagnostic/DebugLogManager$DebugLogLevel;", "(Ljava/lang/String;Lcom/intellij/diagnostic/DebugLogManager$DebugLogLevel;)V", "getCategory", "()Ljava/lang/String;", "getLevel", "()Lcom/intellij/diagnostic/DebugLogManager$DebugLogLevel;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    public static final class Category {
        @NotNull
        private final String category;
        @NotNull
        private final DebugLogLevel level;

        @NotNull
        public final String getCategory() {
            return this.category;
        }

        @NotNull
        public final DebugLogLevel getLevel() {
            return this.level;
        }

        public Category(@NotNull String category, @NotNull DebugLogLevel level) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            this.category = category;
            this.level = level;
        }

        @NotNull
        public final String component1() {
            return this.category;
        }

        @NotNull
        public final DebugLogLevel component2() {
            return this.level;
        }

        @NotNull
        public final Category copy(@NotNull String category, @NotNull DebugLogLevel level) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            return new Category(category, level);
        }

        public static /* synthetic */ Category copy$default(Category category, String string, DebugLogLevel debugLogLevel, int n, Object object) {
            if ((n & 1) != 0) {
                string = category.category;
            }
            if ((n & 2) != 0) {
                debugLogLevel = category.level;
            }
            return category.copy(string, debugLogLevel);
        }

        @NotNull
        public String toString() {
            return "Category(category=" + this.category + ", level=" + (Object)((Object)this.level) + ")";
        }

        public int hashCode() {
            String string = this.category;
            DebugLogLevel debugLogLevel = this.level;
            return (string != null ? string.hashCode() : 0) * 31 + (debugLogLevel != null ? ((Object)((Object)debugLogLevel)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Category)) break block3;
                    Category category = (Category)object;
                    if (!Intrinsics.areEqual((Object)this.category, (Object)category.category) || !Intrinsics.areEqual((Object)((Object)this.level), (Object)((Object)category.level))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/diagnostic/DebugLogManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/diagnostic/DebugLogManager;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DebugLogManager getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(DebugLogManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (DebugLogManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

