/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.VMOptions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;

public class EditXmxVMOptionDialog
extends DialogWrapper {
    private static final int MAX_SUGGESTED_HEAP_SIZE = Registry.intValue((String)"max.suggested.heap.size");
    final ApplicationEx app;
    final boolean isRestartCapable;
    private final Action myIgnoreAction;
    private final Action myShutdownAction;
    private JPanel myContentPane;
    private JLabel myMessageLabel;
    private JTextField myHeapSizeField;
    private JBLabel myHeapCurrentValueLabel;
    private JBLabel mySettingsFileHintLabel;

    public EditXmxVMOptionDialog(long unusedMemory, long totalMemory) {
        this();
        this.mySettingsFileHintLabel.setText(DiagnosticBundle.message("change.memory.usage", unusedMemory / 1024L / 1024L, totalMemory / 1024L / 1024L));
    }

    public EditXmxVMOptionDialog() {
        super(false);
        this.$$$setupUI$$$();
        this.app = (ApplicationEx)ApplicationManager.getApplication();
        this.isRestartCapable = this.app.isRestartCapable();
        this.setTitle(DiagnosticBundle.message("change.memory.title", new Object[0]));
        this.mySettingsFileHintLabel.setIcon(AllIcons.General.Warning);
        this.myIgnoreAction = new AbstractAction(CommonBundle.getCloseButtonText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditXmxVMOptionDialog.this.close(0);
            }
        };
        this.myShutdownAction = this.isRestartCapable ? new SaveAction(IdeBundle.message((String)"action.save.restart.text", (Object[])new Object[0])) : new SaveAction(IdeBundle.message((String)"button.save", (Object[])new Object[0]));
        this.myShutdownAction.putValue("DefaultAction", true);
        int currentMemory = VMOptions.readOption(VMOptions.MemoryKind.HEAP, true);
        String formatted = currentMemory == -1 ? DiagnosticBundle.message("diagnostic.out.of.memory.currentValue.unknown", new Object[0]) : String.valueOf(currentMemory);
        this.myHeapCurrentValueLabel.setText(DiagnosticBundle.message("diagnostic.out.of.memory.currentValue", formatted));
        Path file2 = VMOptions.getWriteFile();
        if (file2 != null) {
            this.mySettingsFileHintLabel.setText(DiagnosticBundle.message("diagnostic.out.of.memory.willBeSavedTo", file2.toString()));
            this.myMessageLabel.setText(DiagnosticBundle.message("change.memory.restart", new Object[0]));
            int newMemory = SystemInfo.is64Bit ? Math.min(MAX_SUGGESTED_HEAP_SIZE, Math.round((float)currentMemory * 1.5f)) : Math.min(800, Math.round((float)currentMemory * 1.5f));
            this.myHeapSizeField.setText(String.valueOf(newMemory));
        } else {
            this.myMessageLabel.setText(DiagnosticBundle.message("change.memory.nofile", new Object[0]));
            this.mySettingsFileHintLabel.setVisible(false);
            this.myHeapSizeField.setEnabled(false);
            this.myShutdownAction.setEnabled(false);
        }
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.myShutdownAction, this.myIgnoreAction};
        if (actionArray == null) {
            EditXmxVMOptionDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myHeapSizeField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/EditXmxVMOptionDialog", "createActions"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JLabel jLabel;
        JBLabel jBLabel2;
        JTextField jTextField;
        JPanel jPanel2;
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DiagnosticBundle", EditXmxVMOptionDialog.class).getString("label.maximum.heap.size"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DiagnosticBundle", EditXmxVMOptionDialog.class).getString("label.megabytes"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeapSizeField = jTextField = new JTextField();
        jTextField.setColumns(6);
        jPanel2.add((Component)jTextField, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myHeapCurrentValueLabel = jBLabel2 = new JBLabel();
        Font font = this.$$$getFont$$$(null, 2, -1, jBLabel2.getFont());
        if (font != null) {
            jBLabel2.setFont(font);
        }
        jBLabel2.setText("Label");
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, new Dimension(51, 11), null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(51, 14), null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 6, 8, 0, 0, 0, null, null, null));
        this.mySettingsFileHintLabel = jBLabel = new JBLabel();
        jBLabel.setText("Label");
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 6, 4, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction(String actionName) {
            super(actionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean success = this.save();
            if (success) {
                if (EditXmxVMOptionDialog.this.isRestartCapable) {
                    EditXmxVMOptionDialog.this.app.restart(true);
                } else {
                    EditXmxVMOptionDialog.this.close(0);
                }
            }
        }

        private boolean save() {
            try {
                int heapSize = Integer.parseInt(EditXmxVMOptionDialog.this.myHeapSizeField.getText());
                if (heapSize < 256) {
                    EditXmxVMOptionDialog.this.mySettingsFileHintLabel.setText(DiagnosticBundle.message("change.memory.low", new Object[0]));
                    return false;
                }
                if (heapSize > 800 && !SystemInfo.is64Bit) {
                    EditXmxVMOptionDialog.this.mySettingsFileHintLabel.setText(DiagnosticBundle.message("change.memory.large", new Object[0]));
                    return false;
                }
                VMOptions.writeOption(VMOptions.MemoryKind.HEAP, heapSize);
                return true;
            }
            catch (NumberFormatException ignored) {
                EditXmxVMOptionDialog.this.mySettingsFileHintLabel.setText(DiagnosticBundle.message("change.memory.integer", new Object[0]));
                return false;
            }
        }
    }
}

