/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.ProjectTopics;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ModuleRunConfigurationManager")
public final class ModuleRunConfigurationManager
implements PersistentStateComponent<Element> {
    @NonNls
    @NotNull
    private static final String STORE_LOCAL_REGISTRY_OPTION = "ruby.store.local.run.conf.in.modules";
    private static final String SHARED = "shared";
    private static final String LOCAL = "local";
    private static final Logger LOG = Logger.getInstance(ModuleRunConfigurationManager.class);
    @NotNull
    private final Module myModule;
    @NotNull
    private final Condition<RunnerAndConfigurationSettings> myModuleConfigCondition;

    public ModuleRunConfigurationManager(@NotNull Module module) {
        if (module == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(0);
        }
        this.myModuleConfigCondition = settings -> settings != null && this.usesMyModule((RunnerAndConfigurationSettings)settings);
        this.myModule = module;
        this.myModule.getProject().getMessageBus().connect((Disposable)this.myModule).subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ModuleRunConfigurationManager.this.myModule.equals(module)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("time to remove something from project (" + project + ")");
                    }
                    ModuleRunConfigurationManager.this.getRunManager().removeConfigurations(ModuleRunConfigurationManager.this.getModuleRunConfigurationSettings());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/impl/ModuleRunConfigurationManager$1";
                objectArray[2] = "beforeModuleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public Element getState() {
        try {
            Element element2 = new Element("state").addContent(this.writeExternal(new Element(SHARED), true));
            if (Registry.is((String)STORE_LOCAL_REGISTRY_OPTION)) {
                element2.addContent(this.writeExternal(new Element(LOCAL), false));
            }
            return element2;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(1);
        }
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Collection<? extends RunnerAndConfigurationSettings> getModuleRunConfigurationSettings() {
        List list2 = ContainerUtil.filter(this.getRunManager().getAllSettings(), this.myModuleConfigCondition);
        if (list2 == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    private RunManagerImpl getRunManager() {
        RunManagerImpl runManagerImpl = (RunManagerImpl)RunManager.getInstance((Project)this.myModule.getProject());
        if (runManagerImpl == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(3);
        }
        return runManagerImpl;
    }

    private boolean usesMyModule(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        if (runnerAndConfigurationSettings == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(4);
        }
        if (runnerAndConfigurationSettings.isStoredInArbitraryFileInProject()) {
            return false;
        }
        RunConfiguration config2 = runnerAndConfigurationSettings.getConfiguration();
        return config2 instanceof ModuleBasedConfiguration && this.myModule.equals(((ModuleBasedConfiguration)config2).getConfigurationModule().getModule());
    }

    public Element writeExternal(@NotNull Element element2, boolean isShared) throws WriteExternalException {
        if (element2 == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(5);
        }
        LOG.debug("writeExternal(" + this.myModule + "); shared: " + isShared);
        this.getRunManager().writeConfigurations(element2, ContainerUtil.filter(this.getModuleRunConfigurationSettings(), settings -> settings.isStoredInDotIdeaFolder() == isShared));
        return element2;
    }

    public void readExternal(@NotNull Element element2) {
        Element localElement;
        Element sharedElement;
        if (element2 == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(6);
        }
        if ((sharedElement = element2.getChild(SHARED)) != null) {
            this.doReadExternal(sharedElement, true);
        }
        if ((localElement = element2.getChild(LOCAL)) != null) {
            this.doReadExternal(localElement, false);
        }
    }

    private void doReadExternal(@NotNull Element element2, boolean isShared) {
        if (element2 == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(7);
        }
        LOG.debug("readExternal(" + this.myModule + ");  shared: " + isShared);
        RunManagerImpl runManager = this.getRunManager();
        for (Element child2 : element2.getChildren("configuration")) {
            runManager.loadConfiguration(child2, isShared);
        }
        runManager.requestSort();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ModuleRunConfigurationManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerAndConfigurationSettings";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ModuleRunConfigurationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRunConfigurationSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "usesMyModule";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doReadExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ModuleRunConfigurationManagerStartupActivity
    implements StartupActivity {
        ModuleRunConfigurationManagerStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                ModuleRunConfigurationManagerStartupActivity.$$$reportNull$$$0(0);
            }
            if (!project.isDefault()) {
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    if (module.isDisposed()) continue;
                    module.getService(ModuleRunConfigurationManager.class);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/ModuleRunConfigurationManager$ModuleRunConfigurationManagerStartupActivity", "runActivity"));
        }
    }
}

