/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.execution.impl.RCInArbitraryFileManager;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ErrorKt;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0000\u00a2\u0006\u0002\b\u001eJ\u001d\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b$J)\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\b\b\u0002\u0010&\u001a\u00020\u00102\b\b\u0002\u0010'\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b(J$\u0010)\u001a\u00020\u00102\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002J\r\u0010,\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b-J\u0018\u0010.\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\n2\u0006\u0010/\u001a\u000200H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/execution/impl/RCInArbitraryFileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "filePathToDigests", "", "", "", "", "filePathToRunConfigs", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;", "saving", "", "addRunConfiguration", "", "runConfig", "addRunConfiguration$intellij_platform_execution_impl", "deleteFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findRunConfigsThatAreNotWithinProjectContent", "", "findRunConfigsThatAreNotWithinProjectContent$intellij_platform_execution_impl", "getRunConfigsFromFiles", "", "filePaths", "getRunConfigsFromFiles$intellij_platform_execution_impl", "loadChangedRunConfigsFromFile", "Lcom/intellij/execution/impl/RCInArbitraryFileManager$DeletedAndAddedRunConfigs;", "runManager", "Lcom/intellij/execution/impl/RunManagerImpl;", "filePath", "loadChangedRunConfigsFromFile$intellij_platform_execution_impl", "removeRunConfiguration", "removeRunConfigOnlyIfFileNameChanged", "deleteContainingFile", "removeRunConfiguration$intellij_platform_execution_impl", "sameDigests", "digests1", "digests2", "saveRunConfigs", "saveRunConfigs$intellij_platform_execution_impl", "saveToFile", "byteOut", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "DeletedAndAddedRunConfigs", "intellij.platform.execution.impl"})
public final class RCInArbitraryFileManager {
    private final Logger LOG;
    private boolean saving;
    private final Map<String, List<RunnerAndConfigurationSettingsImpl>> filePathToRunConfigs;
    private final Map<String, List<byte[]>> filePathToDigests;
    private final Project project;

    public final void addRunConfiguration$intellij_platform_execution_impl(@NotNull RunnerAndConfigurationSettingsImpl runConfig) {
        Intrinsics.checkNotNullParameter((Object)runConfig, (String)"runConfig");
        String filePath = runConfig.getPathIfStoredInArbitraryFileInProject();
        if (!runConfig.isStoredInArbitraryFileInProject() || filePath == null) {
            this.LOG.error("Unexpected run configuration, path: " + filePath);
            return;
        }
        List<RunnerAndConfigurationSettingsImpl> runConfigs = this.filePathToRunConfigs.get(filePath);
        if (runConfigs != null) {
            if (!runConfigs.contains(runConfig)) {
                runConfigs.add(runConfig);
            }
        } else {
            this.filePathToRunConfigs.put(filePath, CollectionsKt.mutableListOf((Object[])new RunnerAndConfigurationSettingsImpl[]{runConfig}));
        }
    }

    public final void removeRunConfiguration$intellij_platform_execution_impl(@NotNull RunnerAndConfigurationSettingsImpl runConfig, boolean removeRunConfigOnlyIfFileNameChanged, boolean deleteContainingFile) {
        Iterator<Map.Entry<String, List<RunnerAndConfigurationSettingsImpl>>> fileEntryIterator;
        Intrinsics.checkNotNullParameter((Object)runConfig, (String)"runConfig");
        Map<String, List<RunnerAndConfigurationSettingsImpl>> map2 = this.filePathToRunConfigs;
        boolean bl = false;
        Iterator<Map.Entry<String, List<RunnerAndConfigurationSettingsImpl>>> iterator2 = fileEntryIterator = map2.entrySet().iterator();
        boolean bl2 = false;
        Iterator<Map.Entry<String, List<RunnerAndConfigurationSettingsImpl>>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            VirtualFile runConfigIterator;
            Map.Entry<String, List<RunnerAndConfigurationSettingsImpl>> fileEntry = iterator3.next();
            String filePath = fileEntry.getKey();
            VirtualFile virtualFile = runConfigIterator = fileEntry.getValue().iterator();
            boolean bl3 = false;
            VirtualFile virtualFile2 = virtualFile;
            while (virtualFile2.hasNext()) {
                RunnerAndConfigurationSettingsImpl rc = virtualFile2.next();
                if (!Intrinsics.areEqual((Object)rc, (Object)runConfig) && (!rc.isTemplate() || !runConfig.isTemplate() || !Intrinsics.areEqual((Object)rc.getType(), (Object)runConfig.getType()))) continue;
                if (Intrinsics.areEqual((Object)filePath, (Object)runConfig.getPathIfStoredInArbitraryFileInProject()) ^ true || !removeRunConfigOnlyIfFileNameChanged) {
                    runConfigIterator.remove();
                    if (fileEntry.getValue().isEmpty()) {
                        fileEntryIterator.remove();
                        this.filePathToDigests.remove(filePath);
                        if (deleteContainingFile) {
                            VirtualFile virtualFile3 = LocalFileSystem.getInstance().findFileByPath(filePath);
                            if (virtualFile3 != null) {
                                virtualFile = virtualFile3;
                                bl3 = false;
                                boolean bl4 = false;
                                VirtualFile it = virtualFile;
                                boolean bl5 = false;
                                VirtualFile virtualFile4 = it;
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"it");
                                this.deleteFile(virtualFile4);
                            }
                        }
                    }
                }
                return;
            }
        }
    }

    public static /* synthetic */ void removeRunConfiguration$intellij_platform_execution_impl$default(RCInArbitraryFileManager rCInArbitraryFileManager, RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        rCInArbitraryFileManager.removeRunConfiguration$intellij_platform_execution_impl(runnerAndConfigurationSettingsImpl, bl, bl2);
    }

    private final void deleteFile(VirtualFile file2) {
        GuiUtils.invokeLaterIfNeeded((Runnable)new Runnable(this, file2){
            final /* synthetic */ RCInArbitraryFileManager this$0;
            final /* synthetic */ VirtualFile $file;

            public final void run() {
                boolean $i$f$runWriteAction = false;
                ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                    final /* synthetic */ deleteFile.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        this.this$0.$file.delete((Object)this.this$0.this$0);
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = rCInArbitraryFileManager;
                this.$file = virtualFile;
            }
        }, (ModalityState)ModalityState.NON_MODAL);
    }

    @NotNull
    public final DeletedAndAddedRunConfigs loadChangedRunConfigsFromFile$intellij_platform_execution_impl(@NotNull RunManagerImpl runManager, @NotNull String filePath) {
        List previouslyLoadedDigests;
        Element element2;
        Element e2;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)((Object)runManager), (String)"runManager");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.saving) {
            return new DeletedAndAddedRunConfigs(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        Map<String, List<RunnerAndConfigurationSettingsImpl>> filePathToRunConfigs = this.filePathToRunConfigs;
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file2 == null) {
            this.LOG.warn("It's unexpected that the file doesn't exist at this point (" + filePath + ')');
            List list2 = filePathToRunConfigs.get(filePath);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List rcsToDelete = list2;
            return new DeletedAndAddedRunConfigs(rcsToDelete, CollectionsKt.emptyList());
        }
        if (!ProjectFileIndex.getInstance((Project)this.project).isInContent(file2)) {
            List list3 = filePathToRunConfigs.get(filePath);
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            List rcsToDelete = list3;
            Collection collection = rcsToDelete;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.LOG.warn("It's unexpected that the model contains run configurations for file, which is not within the project content (" + filePath + ')');
            }
            return new DeletedAndAddedRunConfigs(rcsToDelete, CollectionsKt.emptyList());
        }
        List list4 = filePathToRunConfigs.get(filePath);
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        List previouslyLoadedRunConfigs = list4;
        try {
            byArray = VfsUtil.loadBytes((VirtualFile)file2);
        }
        catch (Exception e2) {
            this.LOG.warn("Failed to load file " + filePath + ": " + e2);
            return new DeletedAndAddedRunConfigs(previouslyLoadedRunConfigs, CollectionsKt.emptyList());
        }
        byte[] bytes = byArray;
        try {
            e2 = JDOMUtil.load((InputStream)CharsetToolkit.inputStreamSkippingBOM((InputStream)new ByteArrayInputStream(bytes)));
        }
        catch (Exception e3) {
            this.LOG.info("Failed to parse file " + filePath + ": " + e3);
            return new DeletedAndAddedRunConfigs(previouslyLoadedRunConfigs, CollectionsKt.emptyList());
        }
        Element element3 = element2 = e2;
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"element");
        if (Intrinsics.areEqual((Object)element3.getName(), (Object)"component") ^ true || Intrinsics.areEqual((Object)element2.getAttributeValue("name"), (Object)"ProjectRunConfigurationManager") ^ true) {
            this.LOG.trace("Unexpected root element " + element2.getName() + " with name=" + element2.getAttributeValue("name") + " in " + filePath);
            return new DeletedAndAddedRunConfigs(previouslyLoadedRunConfigs, CollectionsKt.emptyList());
        }
        boolean e3 = false;
        List loadedRunConfigs = new ArrayList();
        boolean bl = false;
        List loadedDigests = new ArrayList();
        for (Element configElement : element2.getChildren("configuration")) {
            try {
                RunnerAndConfigurationSettingsImpl runConfig = new RunnerAndConfigurationSettingsImpl(runManager, null, false, null, 14, null);
                Element element4 = configElement;
                Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"configElement");
                runConfig.readExternal(element4, true);
                runConfig.storeInArbitraryFileInProject(filePath);
                loadedRunConfigs.add(runConfig);
                loadedDigests.add(Scheme_implKt.digest$default(runConfig.writeScheme(), null, 1, null));
            }
            catch (Exception e4) {
                this.LOG.warn("Failed to read run configuration in " + filePath, (Throwable)e4);
            }
        }
        List list5 = this.filePathToDigests.get(filePath);
        if (list5 == null) {
            list5 = previouslyLoadedDigests = CollectionsKt.emptyList();
        }
        if (this.sameDigests(loadedDigests, previouslyLoadedDigests)) {
            return new DeletedAndAddedRunConfigs(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        this.filePathToDigests.put(filePath, loadedDigests);
        return new DeletedAndAddedRunConfigs(previouslyLoadedRunConfigs, loadedRunConfigs);
    }

    @NotNull
    public final List<RunnerAndConfigurationSettingsImpl> findRunConfigsThatAreNotWithinProjectContent$intellij_platform_execution_impl() {
        Map<String, List<RunnerAndConfigurationSettingsImpl>> filePathToRunConfigs = this.filePathToRunConfigs;
        if (filePathToRunConfigs.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex fileIndex = projectFileIndex;
        boolean bl = false;
        List deletedRunConfigs = new ArrayList();
        Map<String, List<RunnerAndConfigurationSettingsImpl>> map2 = filePathToRunConfigs;
        boolean bl2 = false;
        for (Map.Entry<String, List<RunnerAndConfigurationSettingsImpl>> entry : map2.entrySet()) {
            String filePath = entry.getKey();
            List<RunnerAndConfigurationSettingsImpl> runConfigs = entry.getValue();
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(filePath);
            if (file2 == null) {
                deletedRunConfigs.addAll((Collection)runConfigs);
                this.LOG.warn("It's unexpected that the file doesn't exist at this point (" + filePath + ')');
                continue;
            }
            if (fileIndex.isInContent(file2)) continue;
            deletedRunConfigs.addAll((Collection)runConfigs);
        }
        return deletedRunConfigs;
    }

    @NotNull
    public final Collection<RunnerAndConfigurationSettingsImpl> getRunConfigsFromFiles$intellij_platform_execution_impl(@NotNull Collection<String> filePaths) {
        Intrinsics.checkNotNullParameter(filePaths, (String)"filePaths");
        boolean bl = false;
        List result2 = new ArrayList();
        for (String filePath : filePaths) {
            List<RunnerAndConfigurationSettingsImpl> list2;
            if (this.filePathToRunConfigs.get(filePath) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            List<RunnerAndConfigurationSettingsImpl> it = list2;
            boolean bl4 = false;
            result2.addAll((Collection)it);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveRunConfigs$intellij_platform_execution_impl() {
        SmartList errors = new SmartList();
        for (Map.Entry<String, List<RunnerAndConfigurationSettingsImpl>> entry : this.filePathToRunConfigs.entrySet()) {
            String filePath = entry.getKey();
            List<RunnerAndConfigurationSettingsImpl> runConfigs = entry.getValue();
            this.saving = true;
            try {
                List previouslyLoadedDigests;
                Element rootElement = new Element("component").setAttribute("name", "ProjectRunConfigurationManager");
                boolean bl = false;
                List newDigests = new ArrayList();
                for (RunnerAndConfigurationSettingsImpl runConfig : runConfigs) {
                    Element element2 = runConfig.writeScheme();
                    rootElement.addContent(element2);
                    newDigests.add(Scheme_implKt.digest$default(element2, null, 1, null));
                }
                List list2 = this.filePathToDigests.get(filePath);
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                if (this.sameDigests(newDigests, previouslyLoadedDigests = list2)) continue;
                Element element3 = rootElement;
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"rootElement");
                this.saveToFile(filePath, JdomKt.toBufferExposingByteArray$default((Element)element3, null, (int)1, null));
                this.filePathToDigests.put(filePath, newDigests);
            }
            catch (Exception e) {
                errors.add((Object)new RuntimeException("Cannot save run configuration in " + filePath, e));
            }
            finally {
                this.saving = false;
            }
        }
        ErrorKt.throwIfNotEmpty((List)((List)errors));
    }

    private final boolean sameDigests(List<byte[]> digests1, List<byte[]> digests2) {
        if (digests1.size() != digests2.size()) {
            return false;
        }
        Iterator<byte[]> iterator2 = digests2.iterator();
        Iterable $this$forEach$iv = digests1;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] it = (byte[])element$iv;
            boolean bl = false;
            byte[] byArray = it;
            byte[] byArray2 = iterator2.next();
            boolean bl2 = false;
            if (Arrays.equals(byArray, byArray2)) continue;
            return false;
        }
        return true;
    }

    private final void saveToFile(String filePath, BufferExposingByteArrayOutputStream byteOut) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, filePath, byteOut){
            final /* synthetic */ RCInArbitraryFileManager this$0;
            final /* synthetic */ String $filePath$inlined;
            final /* synthetic */ BufferExposingByteArrayOutputStream $byteOut$inlined;
            {
                this.this$0 = rCInArbitraryFileManager;
                this.$filePath$inlined = string;
                this.$byteOut$inlined = bufferExposingByteArrayOutputStream;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final T compute() {
                boolean bl = false;
                VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(this.$filePath$inlined);
                if (file2 == null) {
                    String string = PathUtil.getParentPath((String)this.$filePath$inlined);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getParentPath(filePath)");
                    String parentPath = string;
                    VirtualFile dir = VfsUtil.createDirectoryIfMissing((String)parentPath);
                    if (dir == null) {
                        RCInArbitraryFileManager.access$getLOG$p(this.this$0).error("Failed to create directory " + parentPath);
                        return (T)Unit.INSTANCE;
                    }
                    file2 = dir.createChildData((Object)this.this$0, PathUtil.getFileName((String)this.$filePath$inlined));
                }
                Closeable closeable = file2.getOutputStream((Object)this.this$0);
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    OutputStream it = (OutputStream)closeable;
                    boolean bl4 = false;
                    this.$byteOut$inlined.writeTo(it);
                    Unit unit = Unit.INSTANCE;
                    return (T)Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        });
    }

    public RCInArbitraryFileManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RCInArbitraryFileManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
        boolean bl = false;
        this.filePathToRunConfigs = new LinkedHashMap();
        bl = false;
        this.filePathToDigests = new LinkedHashMap();
    }

    public static final /* synthetic */ Logger access$getLOG$p(RCInArbitraryFileManager $this) {
        return $this.LOG;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/impl/RCInArbitraryFileManager$DeletedAndAddedRunConfigs;", "", "deleted", "", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;", "added", "(Ljava/util/Collection;Ljava/util/Collection;)V", "addedRunConfigs", "getAddedRunConfigs", "()Ljava/util/Collection;", "deletedRunConfigs", "getDeletedRunConfigs", "intellij.platform.execution.impl"})
    public static final class DeletedAndAddedRunConfigs {
        @NotNull
        private final Collection<RunnerAndConfigurationSettingsImpl> deletedRunConfigs;
        @NotNull
        private final Collection<RunnerAndConfigurationSettingsImpl> addedRunConfigs;

        @NotNull
        public final Collection<RunnerAndConfigurationSettingsImpl> getDeletedRunConfigs() {
            return this.deletedRunConfigs;
        }

        @NotNull
        public final Collection<RunnerAndConfigurationSettingsImpl> getAddedRunConfigs() {
            return this.addedRunConfigs;
        }

        public DeletedAndAddedRunConfigs(@NotNull Collection<RunnerAndConfigurationSettingsImpl> deleted, @NotNull Collection<RunnerAndConfigurationSettingsImpl> added) {
            Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
            Intrinsics.checkNotNullParameter(added, (String)"added");
            this.deletedRunConfigs = deleted.isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)new ArrayList<RunnerAndConfigurationSettingsImpl>(deleted);
            this.addedRunConfigs = added.isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)new ArrayList<RunnerAndConfigurationSettingsImpl>(added);
        }
    }
}

