/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator;

import com.intellij.application.Topics;
import com.intellij.execution.process.elevation.ElevationBundle;
import com.intellij.execution.process.elevation.ElevationLogger;
import com.intellij.execution.process.elevation.settings.ElevationSettings;
import com.intellij.execution.process.mediator.ProcessMediatorClientManager;
import com.intellij.execution.process.mediator.client.ProcessMediatorClient;
import com.intellij.execution.process.mediator.daemon.DaemonClientCredentials;
import com.intellij.execution.process.mediator.daemon.ProcessMediatorDaemon;
import com.intellij.execution.process.mediator.daemon.ProcessMediatorServerDaemon;
import com.intellij.execution.process.mediator.daemon.QuotaOptions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.stub.MetadataUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0004H\u0002J\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0004R\u001b\u0010\u0003\u001a\u00020\u00048CX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/execution/process/mediator/ProcessMediatorClientManager;", "Lcom/intellij/openapi/Disposable;", "()V", "activeClient", "Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient;", "getOrCreateClient", "()Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient;", "activeClient$delegate", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "activeClientLazy", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "isDisposed", "", "parkedClients", "", "adjustQuota", "", "quotaOptions", "Lcom/intellij/execution/process/mediator/daemon/QuotaOptions;", "createInProcessDaemonForDebugging", "Lcom/intellij/execution/process/mediator/daemon/ProcessMediatorDaemon;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "dispose", "getActiveClientOrNull", "launchDaemon", "launchDaemonAndConnectClient", "launchDaemonAndConnectClientIfNeeded", "parkClient", "expectedClient", "intellij.platform.elevation"})
public final class ProcessMediatorClientManager
implements Disposable {
    private boolean isDisposed;
    private final List<ProcessMediatorClient> parkedClients;
    private final SynchronizedClearableLazy<ProcessMediatorClient> activeClientLazy;
    private final SynchronizedClearableLazy activeClient$delegate;

    @JvmName(name="getOrCreateClient")
    private final ProcessMediatorClient getOrCreateClient() {
        Lazy lazy = (Lazy)this.activeClient$delegate;
        ProcessMediatorClientManager processMediatorClientManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ProcessMediatorClient)lazy.getValue();
    }

    @NotNull
    public final ProcessMediatorClient launchDaemonAndConnectClientIfNeeded() {
        return this.getOrCreateClient();
    }

    private final ProcessMediatorClient getActiveClientOrNull() {
        return (ProcessMediatorClient)this.activeClientLazy.getValueIfInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parkClient(@NotNull ProcessMediatorClient expectedClient) {
        Intrinsics.checkNotNullParameter((Object)expectedClient, (String)"expectedClient");
        ProcessMediatorClientManager processMediatorClientManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (processMediatorClientManager) {
            boolean bl3 = false;
            if (this.activeClientLazy.compareAndDrop((Object)expectedClient)) {
                this.parkedClients.add(expectedClient);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void adjustQuota(QuotaOptions quotaOptions2) {
        ProcessMediatorClientManager processMediatorClientManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (processMediatorClientManager) {
            Unit unit;
            boolean bl3 = false;
            for (ProcessMediatorClient client : this.parkedClients) {
                try {
                    client.adjustQuotaBlocking(quotaOptions2);
                }
                catch (Exception e) {
                    ElevationLogger.INSTANCE.getLOG().warn("Unable to adjust quota for client " + client);
                }
            }
            ProcessMediatorClient processMediatorClient = this.getActiveClientOrNull();
            if (processMediatorClient != null) {
                processMediatorClient.adjustQuotaBlocking(quotaOptions2);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProcessMediatorClient launchDaemonAndConnectClient() {
        ProcessMediatorClientManager processMediatorClientManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (processMediatorClientManager) {
            boolean bl3 = false;
            boolean bl4 = !this.isDisposed;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Already disposed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)EmptyCoroutineContext.INSTANCE));
            boolean debug = false;
            ProcessMediatorDaemon daemon = this.launchDaemon();
            ManagedChannel channel2 = daemon.createChannel();
            ProcessMediatorClient processMediatorClient = new ProcessMediatorClient(coroutineScope, channel2, ElevationSettings.Companion.getInstance().getQuotaOptions());
            return processMediatorClient;
        }
    }

    private final ProcessMediatorDaemon launchDaemon() {
        Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)launchDaemon.1.INSTANCE, ElevationBundle.message("progress.title.starting.elevation.daemon", new Object[0]), true, null);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ProgressManager.getInsta\u2026ion.daemon\"), true, null)");
        return (ProcessMediatorDaemon)object;
    }

    private final ProcessMediatorDaemon createInProcessDaemonForDebugging(CoroutineScope coroutineScope) {
        String bindName = "testing" + this.parkedClients.size();
        DaemonClientCredentials credentials = DaemonClientCredentials.Companion.generate$default(DaemonClientCredentials.Companion, 0, 1, null);
        AbstractServerImplBuilder abstractServerImplBuilder = InProcessServerBuilder.forName((String)bindName).directExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)abstractServerImplBuilder, (String)"InProcessServerBuilder.f\u2026indName).directExecutor()");
        return new ProcessMediatorServerDaemon(bindName, credentials, coroutineScope, coroutineScope, (ServerBuilder)abstractServerImplBuilder, credentials){
            final /* synthetic */ String $bindName;
            final /* synthetic */ DaemonClientCredentials $credentials;
            final /* synthetic */ CoroutineScope $coroutineScope;

            @NotNull
            public ManagedChannel createChannel() {
                ManagedChannel managedChannel = ((InProcessChannelBuilder)((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.$bindName).intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((io.grpc.Metadata)this.$credentials.asMetadata())})).directExecutor()).build();
                Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"InProcessChannelBuilder.\u2026.directExecutor().build()");
                return managedChannel;
            }
            {
                this.$bindName = $captured_local_variable$0;
                this.$credentials = $captured_local_variable$1;
                this.$coroutineScope = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ProcessMediatorClientManager processMediatorClientManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (processMediatorClientManager) {
            Unit unit;
            boolean bl3 = false;
            if (this.isDisposed) {
                return;
            }
            this.isDisposed = true;
            for (ProcessMediatorClient client : this.parkedClients) {
                client.close();
            }
            ProcessMediatorClient processMediatorClient = (ProcessMediatorClient)this.activeClientLazy.drop();
            if (processMediatorClient != null) {
                processMediatorClient.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    public ProcessMediatorClientManager() {
        boolean bl = false;
        this.parkedClients = new ArrayList();
        this.activeClientLazy = new SynchronizedClearableLazy((Function0)new Function0<ProcessMediatorClient>(this){
            final /* synthetic */ ProcessMediatorClientManager this$0;

            @NotNull
            public final ProcessMediatorClient invoke() {
                return ProcessMediatorClientManager.access$launchDaemonAndConnectClient(this.this$0);
            }
            {
                this.this$0 = processMediatorClientManager;
                super(0);
            }
        });
        this.activeClient$delegate = this.activeClientLazy;
        Topics.subscribe(ElevationSettings.Listener.TOPIC, (Disposable)this, (Object)new ElevationSettings.Listener(){

            @Override
            public void onDaemonQuotaOptionsChanged(@NotNull QuotaOptions oldValue, @NotNull QuotaOptions newValue2) {
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue2, (String)"newValue");
                this.adjustQuota(newValue2);
            }
        });
    }

    public static final /* synthetic */ ProcessMediatorClient access$launchDaemonAndConnectClient(ProcessMediatorClientManager $this) {
        return $this.launchDaemonAndConnectClient();
    }
}

