/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.actions.ConsolePropertiesProvider;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.AbstractProperty;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class AbstractRerunFailedTestsAction
extends AnAction
implements AnAction.TransparentUpdate {
    private static final Logger LOG = Logger.getInstance(AbstractRerunFailedTestsAction.class);
    private TestFrameworkRunningModel myModel;
    private Getter<? extends TestFrameworkRunningModel> myModelProvider;
    protected TestConsoleProperties myConsoleProperties;

    protected AbstractRerunFailedTestsAction(@NotNull ComponentContainer componentContainer) {
        if (componentContainer == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(0);
        }
        ActionUtil.copyFrom((AnAction)this, (String)"RerunFailedTests");
        this.registerCustomShortcutSet(this.getShortcutSet(), componentContainer.getComponent());
    }

    public void init(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void setModel(TestFrameworkRunningModel model2) {
        this.myModel = model2;
    }

    public void setModelProvider(Getter<? extends TestFrameworkRunningModel> modelProvider) {
        this.myModelProvider = modelProvider;
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.isActive(e));
    }

    private boolean isActive(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return false;
        }
        TestFrameworkRunningModel model2 = this.getModel();
        if (model2 == null || model2.getRoot() == null) {
            return false;
        }
        ExecutionEnvironment environment = (ExecutionEnvironment)e.getData(LangDataKeys.EXECUTION_ENVIRONMENT);
        if (environment == null) {
            return false;
        }
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        if (settings != null && !settings.getType().isDumbAware() && DumbService.isDumb((Project)project)) {
            return false;
        }
        Filter<?> filter2 = this.getFailuresFilter();
        for (AbstractTestProxy abstractTestProxy : model2.getRoot().getAllTests()) {
            if (!filter2.shouldAccept(abstractTestProxy)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<AbstractTestProxy> getFailedTests(@NotNull Project project) {
        TestFrameworkRunningModel model2;
        if (project == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(3);
        }
        if ((model2 = this.getModel()) == null) {
            List<AbstractTestProxy> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractRerunFailedTestsAction.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<AbstractTestProxy> list3 = this.getFilter(project, model2.getProperties().getScope()).select(model2.getRoot().getAllTests());
        if (list3 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @NotNull
    protected Filter getFilter(@NotNull Project project, @NotNull GlobalSearchScope searchScope2) {
        if (project == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(6);
        }
        if (searchScope2 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(7);
        }
        Filter<?> filter2 = this.getFailuresFilter();
        if (filter2 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(8);
        }
        return filter2;
    }

    protected Filter<?> getFailuresFilter() {
        return AbstractRerunFailedTestsAction.getFailuresFilter(this.myConsoleProperties);
    }

    @TestOnly
    public static Filter<?> getFailuresFilter(TestConsoleProperties consoleProperties) {
        if (TestConsoleProperties.INCLUDE_NON_STARTED_IN_RERUN_FAILED.value((AbstractProperty.AbstractPropertyContainer)consoleProperties)) {
            return Filter.NOT_PASSED.or(Filter.FAILED_OR_INTERRUPTED).and(Filter.IGNORED.not());
        }
        return Filter.FAILED_OR_INTERRUPTED.and(Filter.IGNORED.not());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ExecutionEnvironment environment;
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(9);
        }
        if ((environment = (ExecutionEnvironment)e.getData(LangDataKeys.EXECUTION_ENVIRONMENT)) == null) {
            return;
        }
        this.execute(e, environment);
    }

    void execute(@NotNull AnActionEvent e, @NotNull ExecutionEnvironment environment) {
        MyRunProfile profile;
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(10);
        }
        if (environment == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(11);
        }
        if ((profile = this.getRunProfile(environment)) == null) {
            return;
        }
        ExecutionEnvironmentBuilder environmentBuilder = new ExecutionEnvironmentBuilder(environment).runProfile((RunProfile)profile);
        InputEvent event = e.getInputEvent();
        if (!(event instanceof MouseEvent) || !event.isShiftDown()) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder);
            return;
        }
        LinkedHashMap<Executor, ProgramRunner> availableRunners = new LinkedHashMap<Executor, ProgramRunner>();
        for (Executor ex : new Executor[]{DefaultRunExecutor.getRunExecutorInstance(), DefaultDebugExecutor.getDebugExecutorInstance()}) {
            ProgramRunner runner = ProgramRunner.getRunner((String)ex.getId(), (RunProfile)profile);
            if (runner == null) continue;
            availableRunners.put(ex, runner);
        }
        if (availableRunners.isEmpty()) {
            LOG.error(environment.getExecutor().getActionName() + " is not available now");
        } else if (availableRunners.size() == 1) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(environment.getExecutor())));
        } else {
            ArrayList model2 = new ArrayList(availableRunners.keySet());
            JBPopupFactory.getInstance().createPopupChooserBuilder(model2).setSelectionMode(0).setSelectedValue((Object)environment.getExecutor(), true).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Component component2 = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                    if (value2 instanceof Executor) {
                        this.setText(((Executor)value2).getActionName());
                        this.setIcon(((Executor)value2).getIcon());
                    }
                    Component component3 = component2;
                    if (component3 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return component3;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }).setTitle(TestRunnerBundle.message("popup.title.restart.failed.tests", new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(value2 -> AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(value2)).executor(value2))).createPopup().showUnderneathOf(event.getComponent());
        }
    }

    private static void performAction(@NotNull ExecutionEnvironmentBuilder builder2) {
        if (builder2 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(12);
        }
        ExecutionEnvironment environment = builder2.build();
        try {
            environment.getRunner().execute(environment);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        finally {
            ((MyRunProfile)environment.getRunProfile()).clear();
        }
    }

    @Deprecated
    public MyRunProfile getRunProfile() {
        return null;
    }

    @Nullable
    protected MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(13);
        }
        return this.getRunProfile();
    }

    @Nullable
    public TestFrameworkRunningModel getModel() {
        if (this.myModel != null) {
            return this.myModel;
        }
        if (this.myModelProvider != null) {
            return (TestFrameworkRunningModel)this.myModelProvider.get();
        }
        return null;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentContainer";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailedTests";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFailedTests";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRunProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class MyRunProfile
    extends RunConfigurationBase<Element>
    implements ModuleRunProfile,
    WrappingRunConfiguration<RunConfigurationBase<?>>,
    ConsolePropertiesProvider {
        private final RunConfigurationBase<?> myConfiguration;

        @Deprecated
        public RunConfigurationBase<?> getConfiguration() {
            return this.getPeer();
        }

        @NotNull
        public RunConfigurationBase<?> getPeer() {
            RunConfigurationBase<?> runConfigurationBase = this.myConfiguration;
            if (runConfigurationBase == null) {
                MyRunProfile.$$$reportNull$$$0(0);
            }
            return runConfigurationBase;
        }

        public MyRunProfile(@NotNull RunConfigurationBase<?> configuration) {
            if (configuration == null) {
                MyRunProfile.$$$reportNull$$$0(1);
            }
            super(configuration.getProject(), configuration.getFactory(), ActionsBundle.message((String)"action.RerunFailedTests.text", (Object[])new Object[0]));
            this.myConfiguration = configuration;
        }

        public void clear() {
        }

        @Override
        @Nullable
        public TestConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
            if (executor == null) {
                MyRunProfile.$$$reportNull$$$0(2);
            }
            return this.myConfiguration instanceof ConsolePropertiesProvider ? ((ConsolePropertiesProvider)this.myConfiguration).createTestConsoleProperties(executor) : null;
        }

        public void readExternal(@NotNull Element element2) throws InvalidDataException {
            if (element2 == null) {
                MyRunProfile.$$$reportNull$$$0(3);
            }
            this.myConfiguration.readExternal(element2);
        }

        public void writeExternal(@NotNull Element element2) throws WriteExternalException {
            if (element2 == null) {
                MyRunProfile.$$$reportNull$$$0(4);
            }
            this.myConfiguration.writeExternal(element2);
        }

        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            SettingsEditor settingsEditor = this.myConfiguration.getConfigurationEditor();
            if (settingsEditor == null) {
                MyRunProfile.$$$reportNull$$$0(5);
            }
            return settingsEditor;
        }

        public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider2) {
            return this.myConfiguration.createRunnerSettings(provider2);
        }

        public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
            return this.myConfiguration.getRunnerSettingsEditor(runner);
        }

        public RunConfiguration clone() {
            return this.myConfiguration.clone();
        }

        public int getUniqueID() {
            return this.myConfiguration.getUniqueID();
        }

        public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
            return this.myConfiguration.getOptionsForPredefinedLogFile(predefinedLogFile);
        }

        @NotNull
        public List<PredefinedLogFile> getPredefinedLogFiles() {
            List list2 = this.myConfiguration.getPredefinedLogFiles();
            if (list2 == null) {
                MyRunProfile.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @NotNull
        public ArrayList<LogFileOptions> getAllLogFiles() {
            ArrayList arrayList = this.myConfiguration.getAllLogFiles();
            if (arrayList == null) {
                MyRunProfile.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        @NotNull
        public List<LogFileOptions> getLogFiles() {
            List list2 = this.myConfiguration.getLogFiles();
            if (list2 == null) {
                MyRunProfile.$$$reportNull$$$0(8);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPeer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPredefinedLogFiles";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllLogFiles";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createTestConsoleProperties";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "readExternal";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "writeExternal";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

