/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLDistribution {
    public static final String DEFAULT_WSL_MNT_ROOT = "/mnt/";
    private static final int RESOLVE_SYMLINK_TIMEOUT = 10000;
    private static final String RUN_PARAMETER = "run";
    public static final String UNC_PREFIX = "\\\\wsl$\\";
    private static final String WSLENV = "WSLENV";
    private static final Key<ProcessListener> SUDO_LISTENER_KEY = Key.create((String)"WSL sudo listener");
    @NotNull
    private final WslDistributionDescriptor myDescriptor;
    @Nullable
    private final Path myExecutablePath;

    protected WSLDistribution(@NotNull WSLDistribution dist) {
        if (dist == null) {
            WSLDistribution.$$$reportNull$$$0(0);
        }
        this(dist.myDescriptor, dist.myExecutablePath);
    }

    WSLDistribution(@NotNull WslDistributionDescriptor descriptor2, @Nullable Path executablePath) {
        if (descriptor2 == null) {
            WSLDistribution.$$$reportNull$$$0(1);
        }
        this.myDescriptor = descriptor2;
        this.myExecutablePath = executablePath;
    }

    public WSLDistribution(@NotNull String msId) {
        if (msId == null) {
            WSLDistribution.$$$reportNull$$$0(2);
        }
        this(new WslDistributionDescriptor(msId, msId, null, msId), null);
    }

    @Nullable
    public Path getExecutablePath() {
        return this.myExecutablePath;
    }

    @Nullable
    @NlsSafe
    public String readReleaseInfo() {
        try {
            String key = "PRETTY_NAME";
            String releaseInfo = "/etc/os-release";
            ProcessOutput output = this.executeOnWsl(10000, "cat", "/etc/os-release");
            if (WSLUtil.LOG.isDebugEnabled()) {
                WSLUtil.LOG.debug("Reading release info: " + this.getId());
            }
            if (!output.checkSuccess(WSLUtil.LOG)) {
                return null;
            }
            for (String line : output.getStdoutLines(true)) {
                if (!line.startsWith("PRETTY_NAME") || line.length() < "PRETTY_NAME".length() + 1) continue;
                String prettyName = line.substring("PRETTY_NAME".length() + 1);
                return StringUtil.nullize((String)StringUtil.unquoteString((String)prettyName));
            }
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.warn((Throwable)e);
        }
        return null;
    }

    @NotNull
    public GeneralCommandLine createWslCommandLine(String ... command) {
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(3);
        }
        GeneralCommandLine generalCommandLine = this.patchCommandLine(new GeneralCommandLine(command), null, new WSLCommandLineOptions());
        if (generalCommandLine == null) {
            WSLDistribution.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    @NotNull
    public ProcessOutput executeOnWsl(@NotNull List<String> command, @NotNull WSLCommandLineOptions options2, int timeout, @Nullable Consumer<? super ProcessHandler> processHandlerConsumer) throws ExecutionException {
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(5);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(6);
        }
        GeneralCommandLine commandLine = this.patchCommandLine(new GeneralCommandLine(command), null, options2);
        CapturingProcessHandler processHandler2 = new CapturingProcessHandler(commandLine);
        if (processHandlerConsumer != null) {
            processHandlerConsumer.consume((Object)processHandler2);
        }
        ProcessOutput processOutput = WSLUtil.addInputCloseListener(processHandler2).runProcess(timeout);
        if (processOutput == null) {
            WSLDistribution.$$$reportNull$$$0(7);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput executeOnWsl(int timeout, String ... command) throws ExecutionException {
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(8);
        }
        ProcessOutput processOutput = this.executeOnWsl(Arrays.asList(command), new WSLCommandLineOptions(), timeout, null);
        if (processOutput == null) {
            WSLDistribution.$$$reportNull$$$0(9);
        }
        return processOutput;
    }

    public ProcessOutput copyFromWsl(@NotNull String wslPath, @NotNull String windowsPath, @Nullable List<String> additionalOptions, @Nullable Consumer<? super ProcessHandler> handlerConsumer) throws ExecutionException {
        if (wslPath == null) {
            WSLDistribution.$$$reportNull$$$0(10);
        }
        if (windowsPath == null) {
            WSLDistribution.$$$reportNull$$$0(11);
        }
        new File(windowsPath).mkdirs();
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("rsync", "-cr"));
        if (additionalOptions != null) {
            command.addAll(additionalOptions);
        }
        command.add(wslPath + "/");
        String targetWslPath = this.getWslPath(windowsPath);
        if (targetWslPath == null) {
            throw new ExecutionException(IdeBundle.message((String)"wsl.rsync.unable.to.copy.files.dialog.message", (Object[])new Object[]{windowsPath}));
        }
        command.add(targetWslPath + "/");
        return this.executeOnWsl(command, new WSLCommandLineOptions(), -1, handlerConsumer);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public <T extends GeneralCommandLine> T patchCommandLine(@NotNull T commandLine, @Nullable Project project, @Nullable String remoteWorkingDir, boolean askForSudo) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(12);
        }
        WSLCommandLineOptions options2 = new WSLCommandLineOptions().setRemoteWorkingDirectory(remoteWorkingDir).setSudo(askForSudo);
        T t = this.patchCommandLine(commandLine, project, options2);
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(13);
        }
        return t;
    }

    @NotNull
    public <T extends GeneralCommandLine> T patchCommandLine(final @NotNull T commandLine, final @Nullable Project project, @NotNull WSLCommandLineOptions options2) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(14);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(15);
        }
        this.logCommandLineBefore(commandLine, options2);
        Path wslExe = WSLDistribution.findWslExe(options2);
        boolean executeCommandInShell = wslExe == null || options2.isExecuteCommandInShell();
        List<String> linuxCommand = WSLDistribution.buildLinuxCommand(commandLine, executeCommandInShell);
        if (options2.isSudo()) {
            WSLDistribution.prependCommand(linuxCommand, "sudo", "-S", "-p", "''");
            SUDO_LISTENER_KEY.set(commandLine, (Object)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    OutputStream input;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((input = event.getProcessHandler().getProcessInput()) == null) {
                        return;
                    }
                    String password = CredentialPromptDialog.askPassword(project, IdeBundle.message((String)"wsl.enter.root.password.dialog.title", (Object[])new Object[0]), IdeBundle.message((String)"wsl.sudo.password.for.root.label", (Object[])new Object[]{WSLDistribution.this.getPresentableName()}), new CredentialAttributes("WSL", "root", WSLDistribution.class), true);
                    if (password != null) {
                        try (PrintWriter pw = new PrintWriter(input, false, commandLine.getCharset());){
                            pw.println(password);
                        }
                    }
                    super.startNotified(event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/wsl/WSLDistribution$1", "startNotified"));
                }
            });
        }
        if (executeCommandInShell && StringUtil.isNotEmpty((String)options2.getRemoteWorkingDirectory())) {
            WSLDistribution.prependCommand(linuxCommand, "cd", CommandLineUtil.posixQuote((String)options2.getRemoteWorkingDirectory()), "&&");
        }
        if (executeCommandInShell && !options2.isPassEnvVarsUsingInterop()) {
            commandLine.getEnvironment().forEach((key, val) -> WSLDistribution.prependCommand(linuxCommand, "export", CommandLineUtil.posixQuote((String)key) + "=" + CommandLineUtil.posixQuote((String)val), "&&"));
            commandLine.getEnvironment().clear();
        } else {
            WSLDistribution.passEnvironmentUsingInterop(commandLine);
        }
        if (executeCommandInShell) {
            for (String command : options2.getInitShellCommands()) {
                WSLDistribution.prependCommand(linuxCommand, command, "&&");
            }
        }
        commandLine.getParametersList().clearAll();
        String linuxCommandStr = StringUtil.join(linuxCommand, (String)" ");
        if (wslExe != null) {
            commandLine.setExePath(wslExe.toString());
            commandLine.addParameters(new String[]{"--distribution", this.getMsId()});
            if (options2.isExecuteCommandInShell()) {
                commandLine.addParameters(new String[]{"--exec", "/bin/sh", "-c", linuxCommandStr});
            } else {
                commandLine.addParameter("--exec");
                commandLine.addParameters(linuxCommand);
            }
        } else {
            commandLine.setExePath(Objects.requireNonNull(this.getExecutablePath()).toString());
            commandLine.addParameter(this.getRunCommandLineParameter());
            commandLine.addParameter(linuxCommandStr);
        }
        this.logCommandLineAfter(commandLine);
        T t = commandLine;
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(16);
        }
        return t;
    }

    private void logCommandLineBefore(@NotNull GeneralCommandLine commandLine, @NotNull WSLCommandLineOptions options2) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(17);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(18);
        }
        if (WSLUtil.LOG.isDebugEnabled()) {
            WSLUtil.LOG.debug("[" + this.getId() + "] Patching: " + commandLine.getCommandLineString() + "; options: " + options2 + "; envs: " + commandLine.getEnvironment());
        }
    }

    private void logCommandLineAfter(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(19);
        }
        if (WSLUtil.LOG.isDebugEnabled()) {
            WSLUtil.LOG.debug("[" + this.getId() + "] Patched as: " + commandLine.getCommandLineList(null));
        }
    }

    @Nullable
    private static Path findWslExe(@NotNull WSLCommandLineOptions options2) {
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(20);
        }
        File file2 = options2.isLaunchWithWslExe() ? PathEnvironmentVariableUtil.findInPath((String)"wsl.exe") : null;
        return file2 != null ? file2.toPath() : null;
    }

    @NotNull
    private static List<String> buildLinuxCommand(@NotNull GeneralCommandLine commandLine, boolean executeCommandInShell) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(21);
        }
        List command = ContainerUtil.concat(Collections.singletonList(commandLine.getExePath()), (List)commandLine.getParametersList().getList());
        return new ArrayList<String>(ContainerUtil.map((Collection)command, (Function)(executeCommandInShell ? CommandLineUtil::posixQuote : Functions.identity())));
    }

    private static void passEnvironmentUsingInterop(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(22);
        }
        StringBuilder builder2 = new StringBuilder();
        for (String envName : commandLine.getEnvironment().keySet()) {
            if (!StringUtil.isNotEmpty((String)envName)) continue;
            if (builder2.length() > 0) {
                builder2.append(":");
            }
            builder2.append(envName).append("/u");
        }
        if (builder2.length() > 0) {
            String prevValue = (String)commandLine.getEnvironment().get(WSLENV);
            if (prevValue == null) {
                prevValue = (String)commandLine.getParentEnvironment().get(WSLENV);
            }
            String value2 = prevValue != null ? StringUtil.trimEnd((String)prevValue, (char)':') + ":" + builder2 : builder2.toString();
            commandLine.getEnvironment().put(WSLENV, value2);
        }
    }

    @NotNull
    @NlsSafe
    protected String getRunCommandLineParameter() {
        return RUN_PARAMETER;
    }

    @NotNull
    @NlsSafe
    public String resolveSymlink(@NotNull String path, int timeoutInMilliseconds) {
        block5: {
            String string;
            if (path == null) {
                WSLDistribution.$$$reportNull$$$0(23);
            }
            try {
                ProcessOutput output = this.executeOnWsl(timeoutInMilliseconds, "readlink", "-f", path);
                if (output.getExitCode() != 0) break block5;
                String stdout = output.getStdout().trim();
                if (output.getExitCode() != 0 || !StringUtil.isNotEmpty((String)stdout)) break block5;
                string = stdout;
            }
            catch (ExecutionException e) {
                WSLUtil.LOG.debug("Error while resolving symlink: " + path, (Throwable)e);
            }
            if (string == null) {
                WSLDistribution.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String resolveSymlink(@NotNull String path) {
        if (path == null) {
            WSLDistribution.$$$reportNull$$$0(26);
        }
        String string = this.resolveSymlink(path, 10000);
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public <T extends ProcessHandler> T patchProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull T processHandler2) {
        ProcessListener listener2;
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(28);
        }
        if (processHandler2 == null) {
            WSLDistribution.$$$reportNull$$$0(29);
        }
        if ((listener2 = (ProcessListener)SUDO_LISTENER_KEY.get((UserDataHolder)commandLine)) != null) {
            processHandler2.addProcessListener(listener2);
            SUDO_LISTENER_KEY.set((UserDataHolder)commandLine, null);
        }
        T t = processHandler2;
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(30);
        }
        return t;
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        HashMap<String, String> hashMap;
        try {
            ProcessOutput processOutput = this.executeOnWsl(5000, "env");
            HashMap<String, String> result2 = new HashMap<String, String>();
            for (String string : processOutput.getStdoutLines()) {
                int assignIndex = string.indexOf(61);
                if (assignIndex == -1) {
                    result2.put(string, "");
                    continue;
                }
                result2.put(string.substring(0, assignIndex), string.substring(assignIndex + 1));
            }
            hashMap = result2;
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.warn((Throwable)e);
            Map<String, String> map2 = Collections.emptyMap();
            if (map2 == null) {
                WSLDistribution.$$$reportNull$$$0(32);
            }
            return map2;
        }
        if (hashMap == null) {
            WSLDistribution.$$$reportNull$$$0(31);
        }
        return hashMap;
    }

    @Nullable
    @NlsSafe
    public String getWindowsPath(@NotNull String wslPath) {
        if (wslPath == null) {
            WSLDistribution.$$$reportNull$$$0(33);
        }
        return WSLUtil.getWindowsPath(wslPath, this.getMntRoot());
    }

    @Nullable
    @NlsSafe
    public String getWslPath(@NotNull String windowsPath) {
        if (windowsPath == null) {
            WSLDistribution.$$$reportNull$$$0(34);
        }
        if (FileUtil.isWindowsAbsolutePath((String)windowsPath)) {
            return this.getMntRoot() + WSLDistribution.convertWindowsPath(windowsPath);
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public final String getMntRoot() {
        String string = this.myDescriptor.getMntRoot();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    static String convertWindowsPath(@NotNull String windowsAbsolutePath) {
        if (windowsAbsolutePath == null) {
            WSLDistribution.$$$reportNull$$$0(36);
        }
        String string = Character.toLowerCase(windowsAbsolutePath.charAt(0)) + FileUtil.toSystemIndependentName((String)windowsAbsolutePath.substring(2));
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getId() {
        String string = this.myDescriptor.getId();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getMsId() {
        String string = this.myDescriptor.getMsId();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        String string = this.myDescriptor.getPresentableName();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(40);
        }
        return string;
    }

    public String toString() {
        return "WSLDistribution{myDescriptor=" + this.myDescriptor + "}";
    }

    private static void prependCommand(@NotNull List<String> command, String ... commandToPrepend) {
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(41);
        }
        if (commandToPrepend == null) {
            WSLDistribution.$$$reportNull$$$0(42);
        }
        command.addAll(0, Arrays.asList(commandToPrepend));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WSLDistribution that = (WSLDistribution)o;
        return this.myDescriptor.equals(that.myDescriptor);
    }

    public int hashCode() {
        return this.myDescriptor.hashCode();
    }

    @ApiStatus.Experimental
    @NotNull
    public File getUNCRoot() {
        return new File(UNC_PREFIX + this.myDescriptor.getMsId());
    }

    @ApiStatus.Experimental
    @Nullable
    public VirtualFile getUNCRootVirtualFile(boolean refreshIfNeed) {
        if (!Experiments.getInstance().isFeatureEnabled("wsl.p9.support")) {
            return null;
        }
        File uncRoot = this.getUNCRoot();
        return uncRoot.exists() ? VfsUtil.findFileByIoFile((File)uncRoot, (boolean)refreshIfNeed) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msId";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLDistribution";
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
            case 11: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsPath";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsAbsolutePath";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandToPrepend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLDistribution";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createWslCommandLine";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnWsl";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommandLine";
                break;
            }
            case 24: 
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlink";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "patchProcessHandler";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getMntRoot";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "convertWindowsPath";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getMsId";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createWslCommandLine";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeOnWsl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyFromWsl";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "logCommandLineBefore";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "logCommandLineAfter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findWslExe";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildLinuxCommand";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "passEnvironmentUsingInterop";
                break;
            }
            case 23: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "patchProcessHandler";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getWindowsPath";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getWslPath";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "convertWindowsPath";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "prependCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

