/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.FindUsagesKt;
import com.intellij.find.actions.ResolverKt;
import com.intellij.find.actions.UsageVariantHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FindUsagesAction
extends AnAction {
    public FindUsagesAction() {
        this.setInjectedContext(true);
    }

    protected boolean toShowDialog() {
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            FindUsagesAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DataContext dataContext = e.getDataContext();
        if (Registry.is((String)"ide.symbol.find.usages")) {
            this.findSymbolUsages(project, dataContext);
        } else {
            this.findUsageTargetUsages(project, dataContext);
        }
    }

    private void findSymbolUsages(final @NotNull Project project, final @NotNull DataContext dataContext) {
        if (project == null) {
            FindUsagesAction.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            FindUsagesAction.$$$reportNull$$$0(2);
        }
        ResolverKt.findShowUsages(project, dataContext, ResolverKt.allTargets(dataContext), FindBundle.message("find.usages.ambiguous.title", new Object[0]), new UsageVariantHandler(){

            @Override
            public void handleTarget(@NotNull SearchTarget target2) {
                if (target2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                SearchScope searchScope2 = FindUsagesOptions.findScopeByName(project, dataContext, FindSettings.getInstance().getDefaultScopeName());
                FindUsagesKt.findUsages(FindUsagesAction.this.toShowDialog(), project, searchScope2, target2);
            }

            @Override
            public void handlePsi(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                FindUsagesAction.this.startFindUsages(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/find/actions/FindUsagesAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleTarget";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePsi";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void findUsageTargetUsages(@NotNull Project project, @NotNull DataContext dataContext) {
        UsageTarget[] usageTargets;
        if (project == null) {
            FindUsagesAction.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            FindUsagesAction.$$$reportNull$$$0(4);
        }
        if ((usageTargets = (UsageTarget[])dataContext.getData(UsageView.USAGE_TARGETS_KEY)) == null) {
            Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project, editor, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element2 -> {
                this.startFindUsages(element2);
                return false;
            }));
        } else {
            UsageTarget target2 = usageTargets[0];
            if (target2 instanceof PsiElementUsageTarget) {
                PsiElement element3 = ((PsiElementUsageTarget)target2).getElement();
                if (element3 != null) {
                    this.startFindUsages(element3);
                }
            } else {
                target2.findUsages();
            }
        }
    }

    protected void startFindUsages(@NotNull PsiElement element2) {
        if (element2 == null) {
            FindUsagesAction.$$$reportNull$$$0(5);
        }
        FindManager.getInstance((Project)element2.getProject()).findUsages(element2);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            FindUsagesAction.$$$reportNull$$$0(6);
        }
        FindUsagesInFileAction.updateFindUsagesAction(event);
    }

    static void chooseAmbiguousTargetAndPerform(@NotNull Project project, Editor editor, @NotNull PsiElementProcessor<? super PsiElement> processor2) {
        if (project == null) {
            FindUsagesAction.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            FindUsagesAction.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            Messages.showMessageDialog((Project)project, (String)FindBundle.message("find.no.usages.at.cursor.error", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        } else {
            int offset = editor.getCaretModel().getOffset();
            boolean chosen = GotoDeclarationAction.chooseAmbiguousTarget(project, editor, offset, processor2, FindBundle.message("find.usages.ambiguous.title", new Object[0]), null);
            if (!chosen) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (editor.isDisposed() || !EditorActivityManager.getInstance().isVisible(editor)) {
                        return;
                    }
                    HintManager.getInstance().showErrorHint(editor, FindBundle.message("find.no.usages.at.cursor.error", new Object[0]));
                }, project.getDisposed());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/actions/FindUsagesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findSymbolUsages";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsageTargetUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startFindUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseAmbiguousTargetAndPerform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ShowSettingsAndFindUsages
    extends FindUsagesAction {
        @Override
        protected void startFindUsages(@NotNull PsiElement element2) {
            if (element2 == null) {
                ShowSettingsAndFindUsages.$$$reportNull$$$0(0);
            }
            FindManager.getInstance((Project)element2.getProject()).findUsages(element2, true);
        }

        @Override
        protected boolean toShowDialog() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/actions/FindUsagesAction$ShowSettingsAndFindUsages", "startFindUsages"));
        }
    }
}

