/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class FileSetProcessor {
    private static final Logger LOG = Logger.getInstance(FileSetProcessor.class);
    private final Set<File> myTopEntries = new HashSet<File>();
    private final Set<String> myFileMasks = new HashSet<String>();
    private int myProcessedFiles;
    private boolean isRecursive;

    public void processFiles() throws IOException {
        for (File topEntry : this.myTopEntries) {
            this.processEntry(topEntry);
        }
    }

    public void setRecursive() {
        this.isRecursive = true;
    }

    public void addFileMask(@NotNull String fileMask) {
        if (fileMask == null) {
            FileSetProcessor.$$$reportNull$$$0(0);
        }
        String fileMaskRegexp = FileSetProcessor.fileMaskToRegexp(fileMask);
        LOG.info("File mask regexp: " + fileMaskRegexp);
        this.myFileMasks.add(fileMaskRegexp);
    }

    private static String fileMaskToRegexp(@NotNull String fileMask) {
        if (fileMask == null) {
            FileSetProcessor.$$$reportNull$$$0(1);
        }
        return fileMask.replace(".", "\\.").replace("*", ".*").replace("?", ".").replace("+", "\\+");
    }

    public void addEntry(@NotNull String filePath) throws IOException {
        File file2;
        if (filePath == null) {
            FileSetProcessor.$$$reportNull$$$0(2);
        }
        if (!(file2 = new File(filePath)).exists()) {
            throw new IOException("File " + filePath + " not found.");
        }
        this.myTopEntries.add(file2);
    }

    private void processEntry(@NotNull File entry) throws IOException {
        if (entry == null) {
            FileSetProcessor.$$$reportNull$$$0(3);
        }
        if (entry.exists()) {
            if (entry.isDirectory()) {
                LOG.info("Scanning directory " + entry.getPath());
                File[] subEntries = entry.listFiles();
                if (subEntries != null) {
                    for (File subEntry : subEntries) {
                        if (subEntry.isDirectory() && !this.isRecursive) continue;
                        this.processEntry(subEntry);
                    }
                }
            } else if (this.matchesFileMask(entry.getName())) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(entry);
                if (virtualFile == null) {
                    throw new IOException("Can not find " + entry.getPath());
                }
                LOG.info("Processing " + virtualFile.getPath());
                if (this.processFile(virtualFile)) {
                    ++this.myProcessedFiles;
                }
            }
        }
    }

    private boolean matchesFileMask(@NotNull String name) {
        if (name == null) {
            FileSetProcessor.$$$reportNull$$$0(4);
        }
        if (this.myFileMasks.isEmpty()) {
            return true;
        }
        for (String fileMask : this.myFileMasks) {
            if (!name.matches(fileMask)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean processFile(@NotNull VirtualFile var1);

    public int getProcessedFiles() {
        return this.myProcessedFiles;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileMask";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/commandLine/FileSetProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileMask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMaskToRegexp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addEntry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processEntry";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesFileMask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

