/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ide.CutElementMarker;
import com.intellij.openapi.ide.KillRingTransferable;
import com.intellij.openapi.ide.Sizeable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.LinkedListWithSum;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.EventListener;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyPasteManagerEx
extends CopyPasteManager
implements ClipboardOwner {
    private static final Logger LOG = Logger.getInstance(CopyPasteManagerEx.class);
    private final LinkedListWithSum<Transferable> myData = new LinkedListWithSum(CopyPasteManagerEx::getSize);
    private final EventDispatcher<CopyPasteManager.ContentChangedListener> myDispatcher = EventDispatcher.create(CopyPasteManager.ContentChangedListener.class);
    private boolean myOwnContent;

    public static CopyPasteManagerEx getInstanceEx() {
        return (CopyPasteManagerEx)CopyPasteManagerEx.getInstance();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.myOwnContent = false;
        ClipboardSynchronizer.getInstance().resetContent();
        this.fireContentChanged(contents, null);
    }

    private void fireContentChanged(@Nullable Transferable oldContent, @Nullable Transferable newContent) {
        ((CopyPasteManager.ContentChangedListener)this.myDispatcher.getMulticaster()).contentChanged(oldContent, newContent);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        if (listener2 == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(0);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(2);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        if (listener2 == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(3);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        if (flavors == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(4);
        }
        return flavors.length > 0 && ClipboardSynchronizer.getInstance().areDataFlavorsAvailable(flavors);
    }

    public void setContents(@NotNull Transferable content2) {
        if (content2 == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(5);
        }
        Transferable oldContent = this.myOwnContent && !this.myData.isEmpty() ? (Transferable)this.myData.get(0) : null;
        Transferable contentToUse = this.addNewContentToStack(content2);
        this.setSystemClipboardContent(contentToUse);
        this.fireContentChanged(oldContent, contentToUse);
    }

    public boolean isCutElement(@Nullable Object element2) {
        for (CutElementMarker marker : CutElementMarker.EP_NAME.getExtensionList()) {
            if (!marker.isCutElement(element2)) continue;
            return true;
        }
        return false;
    }

    public void stopKillRings() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Kill ring reset", new Throwable());
        }
        this.doStopKillRings();
    }

    public void stopKillRings(@NotNull Document document) {
        Transferable top;
        if (document == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(6);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Kill ring reset for " + document, new Throwable());
        }
        if (!this.myData.isEmpty() && (top = (Transferable)this.myData.get(0)) instanceof KillRingTransferable && document == ((KillRingTransferable)top).getDocument()) {
            this.doStopKillRings();
        }
    }

    private void doStopKillRings() {
        for (Transferable data2 : this.myData) {
            if (!(data2 instanceof KillRingTransferable)) continue;
            ((KillRingTransferable)data2).setReadyToCombine(false);
        }
    }

    private void setSystemClipboardContent(Transferable content2) {
        ClipboardSynchronizer.getInstance().setContent(content2, this);
        this.myOwnContent = true;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private Transferable addNewContentToStack(@NotNull Transferable content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addToTheTopOfTheStack(@NotNull Transferable content2) {
        if (content2 == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(13);
        }
        this.myData.add(0, (Object)content2);
        this.deleteAfterAllowedMaximum();
    }

    @Nullable
    private static Transferable merge(@NotNull KillRingTransferable newData, @NotNull KillRingTransferable oldData) throws IOException, UnsupportedFlavorException {
        if (newData == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(14);
        }
        if (oldData == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(15);
        }
        if (!oldData.isReadyToCombine() || !newData.isReadyToCombine()) {
            return null;
        }
        Document document = newData.getDocument();
        if (document == null || document != oldData.getDocument()) {
            return null;
        }
        Object newDataText = newData.getTransferData(DataFlavor.stringFlavor);
        Object oldDataText = oldData.getTransferData(DataFlavor.stringFlavor);
        if (newDataText == null || oldDataText == null) {
            return null;
        }
        if (oldData.isCut() && newData.getStartOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), newData.isCut());
        }
        if (newData.getStartOffset() == oldData.getEndOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), false);
        }
        if (newData.getEndOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(newDataText.toString() + oldDataText, document, newData.getStartOffset(), oldData.getEndOffset(), false);
        }
        return null;
    }

    private static String getStringContent(@NotNull Transferable content2) {
        if (content2 == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(16);
        }
        try {
            return (String)content2.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    private void deleteAfterAllowedMaximum() {
        int maxCount = Math.max(1, Registry.intValue((String)"clipboard.history.max.items"));
        int maxMemory = Math.max(0, Registry.intValue((String)"clipboard.history.max.memory"));
        int smallItemSizeLimit = maxMemory / maxCount / 10;
        if (this.myData.size() > maxCount) {
            this.myData.subList(maxCount, this.myData.size()).clear();
        }
        LinkedListWithSum.ListIterator it = this.myData.listIterator(this.myData.size());
        while (this.myData.getSum() > (long)maxMemory && it.hasPrevious() && it.previousIndex() > 0) {
            it.previous();
            if (it.getValue() <= smallItemSizeLimit) continue;
            it.set((Object)CopyPasteManagerEx.createPurgedItem());
        }
    }

    public Transferable getContents() {
        return ClipboardSynchronizer.getInstance().getContents();
    }

    @Nullable
    public <T> T getContents(@NotNull DataFlavor flavor) {
        if (flavor == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(17);
        }
        if (this.areDataFlavorsAvailable(flavor)) {
            return (T)ClipboardSynchronizer.getInstance().getData(flavor);
        }
        return null;
    }

    public Transferable @NotNull [] getAllContents() {
        String clipString = (String)this.getContents(DataFlavor.stringFlavor);
        if (clipString != null && (this.myData.isEmpty() || !Objects.equals(clipString, CopyPasteManagerEx.getStringContent((Transferable)this.myData.get(0))))) {
            this.addToTheTopOfTheStack(new StringSelection(clipString));
        }
        Transferable[] transferableArray = (Transferable[])this.myData.toArray((Object[])new Transferable[0]);
        if (transferableArray == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(18);
        }
        return transferableArray;
    }

    public void removeContent(Transferable t) {
        Transferable current2 = this.myData.isEmpty() ? null : (Transferable)this.myData.get(0);
        this.myData.remove((Object)t);
        if (Comparing.equal((Object)t, (Object)current2)) {
            Transferable newContent = !this.myData.isEmpty() ? (Transferable)this.myData.get(0) : new StringSelection("");
            this.setSystemClipboardContent(newContent);
            this.fireContentChanged(current2, newContent);
        }
    }

    public void moveContentToStackTop(Transferable t) {
        Transferable current2;
        Transferable transferable = current2 = this.myData.isEmpty() ? null : (Transferable)this.myData.get(0);
        if (!Comparing.equal((Object)t, (Object)current2)) {
            this.myData.remove((Object)t);
            this.myData.add(0, (Object)t);
            this.setSystemClipboardContent(t);
            this.fireContentChanged(current2, t);
        } else {
            this.setSystemClipboardContent(t);
        }
    }

    private static Transferable createPurgedItem() {
        return new StringSelection(UIBundle.message((String)"clipboard.history.purged.item", (Object[])new Object[0]));
    }

    private static int getSize(Transferable t) {
        if (t instanceof StringSelection) {
            try {
                return StringUtil.length((CharSequence)((String)t.getTransferData(DataFlavor.stringFlavor)));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        } else if (t instanceof Sizeable) {
            int size = ((Sizeable)t).getSize();
            if (size >= 0) {
                return size;
            }
            LOG.error("Got negative size (" + size + ") from " + t);
        }
        return 1000;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavors";
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/CopyPasteManagerEx";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldData";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/CopyPasteManagerEx";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewContentToStack";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addContentChangedListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeContentChangedListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "areDataFlavorsAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setContents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "stopKillRings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addNewContentToStack";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addToTheTopOfTheStack";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStringContent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

