/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.util.Alarm;
import com.intellij.util.BitUtil;
import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.HierarchyEvent;
import java.lang.reflect.Field;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public final class SwingCleanuper {
    private final Alarm myAlarm;

    public SwingCleanuper(@NotNull Application application) {
        if (application == null) {
            SwingCleanuper.$$$reportNull$$$0(0);
        }
        this.myAlarm = new Alarm((Disposable)application);
        application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                SwingCleanuper.this.myAlarm.cancelAllRequests();
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                SwingCleanuper.this.myAlarm.cancelAllRequests();
                SwingCleanuper.this.myAlarm.addRequest(() -> {
                    IdeStatusBarImpl statusBar;
                    Application app;
                    ProjectFrameHelper frame = ProjectFrameHelper.getFrameHelper(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow());
                    if (frame != null && (app = ApplicationManager.getApplication()) != null && app.isActive() && (statusBar = frame.getStatusBar()) != null) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)statusBar, true));
                    }
                }, 2500);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/ide/SwingCleanuper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (SystemInfo.isMac) {
            Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
                if (!Registry.is((String)"ide.mac.fix.accessibleLeak")) {
                    return;
                }
                HierarchyEvent he = (HierarchyEvent)event;
                if (BitUtil.isSet((long)he.getChangeFlags(), (long)4L) && he.getComponent() != null && !he.getComponent().isShowing()) {
                    ChangeListener[] changeListeners;
                    Component c = he.getComponent();
                    if (c instanceof JTextComponent) {
                        CaretListener[] carets;
                        JTextComponent textComponent = (JTextComponent)c;
                        for (CaretListener each : carets = (CaretListener[])textComponent.getListeners(CaretListener.class)) {
                            if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                            textComponent.removeCaretListener(each);
                        }
                        Document document = textComponent.getDocument();
                        if (document instanceof AbstractDocument) {
                            DocumentListener[] documentListeners;
                            for (DocumentListener each : documentListeners = ((AbstractDocument)document).getDocumentListeners()) {
                                if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                                document.removeDocumentListener(each);
                            }
                        }
                    } else if (c instanceof JProgressBar) {
                        JProgressBar bar2 = (JProgressBar)c;
                        changeListeners = bar2.getChangeListeners();
                        for (ChangeListener each : changeListeners) {
                            if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                            bar2.removeChangeListener(each);
                        }
                    } else if (c instanceof JSlider) {
                        JSlider slider = (JSlider)c;
                        changeListeners = slider.getChangeListeners();
                        for (ChangeListener each : changeListeners) {
                            if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                            slider.removeChangeListener(each);
                        }
                    }
                    Field nativeAXResource_Field = null;
                    Field accessibleContext_Field = null;
                    try {
                        nativeAXResource_Field = ReflectionUtil.findField(AccessibleContext.class, Object.class, (String)"nativeAXResource");
                        accessibleContext_Field = ReflectionUtil.findField(Component.class, AccessibleContext.class, (String)"accessibleContext");
                    }
                    catch (NoSuchFieldException document) {
                        // empty catch block
                    }
                    if (accessibleContext_Field != null) {
                        try {
                            Object resource;
                            AccessibleContext ac = (AccessibleContext)accessibleContext_Field.get(c);
                            if (ac != null && (ac = c.getAccessibleContext()) != null && (resource = nativeAXResource_Field.get(ac)) != null && SwingCleanuper.isCAccessible(resource)) {
                                Field accessible = ReflectionUtil.findField(resource.getClass(), Accessible.class, (String)"accessible");
                                accessible.set(resource, null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }, 32768L);
        }
    }

    private static boolean isCAccessible(Object resource) {
        String name = resource.getClass().getName();
        return SwingCleanuper.isCAccessible(name);
    }

    static boolean isCAccessible(String name) {
        return name.equals("apple.awt.CAccessible") || name.equals("sun.lwawt.macosx.CAccessible");
    }

    private static boolean isCAccessibleListener(EventListener listener2) {
        return listener2 != null && listener2.toString().contains("AXTextChangeNotifier");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/ide/SwingCleanuper", "<init>"));
    }
}

