/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.searcheverywhere.CalculatorSEContributor;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Processor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\u00110\u0010H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\b\u0010 \u001a\u00020\u001cH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/CalculatorSEContributor;", "Lcom/intellij/ide/actions/searcheverywhere/WeightedSearchEverywhereContributor;", "Lcom/intellij/ide/actions/searcheverywhere/CalculatorSEContributor$EvaluationResult;", "()V", "renderer", "Ljavax/swing/ListCellRenderer;", "evaluate", "", "str", "", "fetchWeightedElements", "", "pattern", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/ide/actions/searcheverywhere/FoundItemDescriptor;", "getDataForItem", "", "element", "dataId", "getElementsRenderer", "getGroupName", "getSearchProviderId", "getSortWeight", "", "processSelectedItem", "", "selected", "modifiers", "searchText", "showInFindResults", "EvaluationResult", "Factory", "intellij.platform.lang.impl"})
public final class CalculatorSEContributor
implements WeightedSearchEverywhereContributor<EvaluationResult> {
    private final ListCellRenderer<EvaluationResult> renderer;

    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.name");
        return string;
    }

    @NotNull
    public String getGroupName() {
        String string = LangBundle.message((String)"search.everywhere.calculator.group.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LangBundle.message(\"sear\u2026e.calculator.group.name\")");
        return string;
    }

    public int getSortWeight() {
        return 0;
    }

    public boolean showInFindResults() {
        return false;
    }

    public void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<EvaluationResult>> consumer2) {
        double d;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        try {
            d = this.evaluate(pattern);
        }
        catch (Throwable _) {
            return;
        }
        double result2 = d;
        consumer2.process((Object)new FoundItemDescriptor((Object)new EvaluationResult(result2), 32768));
    }

    @Nullable
    public Object getDataForItem(@NotNull EvaluationResult element2, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return null;
    }

    public boolean processSelectedItem(@NotNull EvaluationResult selected2, int modifiers, @NotNull String searchText) {
        Intrinsics.checkNotNullParameter((Object)selected2, (String)"selected");
        Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(String.valueOf(selected2.getValue())));
        return true;
    }

    @NotNull
    public ListCellRenderer<EvaluationResult> getElementsRenderer() {
        return this.renderer;
    }

    private final double evaluate(String str) {
        return new Object(str){
            private int pos;
            private char ch;
            final /* synthetic */ String $str;

            public final int getPos() {
                return this.pos;
            }

            public final void setPos(int n) {
                this.pos = n;
            }

            public final char getCh() {
                return this.ch;
            }

            public final void setCh(char c) {
                this.ch = c;
            }

            public final void nextChar() {
                char c;
                evaluate.1 v0 = this;
                CharSequence charSequence = this.$str;
                evaluate.1 v1 = this;
                ++v1.pos;
                int n = v1.pos;
                boolean bl = false;
                if (n >= 0 && n <= StringsKt.getLastIndex((CharSequence)charSequence)) {
                    c = charSequence.charAt(n);
                } else {
                    int n2 = n;
                    evaluate.1 var6_5 = v0;
                    boolean bl2 = false;
                    char c2 = '\u0000';
                    v0 = var6_5;
                    c = c2;
                }
                v0.ch = c;
            }

            public final boolean eat(char charToEat) {
                while (this.ch == ' ') {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            public final double parseExpression() {
                double x = this.parseTerm();
                while (true) {
                    if (this.eat('+')) {
                        x += this.parseTerm();
                        continue;
                    }
                    if (!this.eat('-')) break;
                    x -= this.parseTerm();
                }
                return x;
            }

            public final double parseTerm() {
                double x = this.parseFactor();
                while (true) {
                    if (this.eat('*')) {
                        x *= this.parseFactor();
                        continue;
                    }
                    if (!this.eat('/')) break;
                    x /= this.parseFactor();
                }
                return x;
            }

            public final double parseFactor() {
                return this.eat('+') ? this.parseFactor() : (this.eat('-') ? -this.parseFactor() : this.parsePrimary());
            }

            /*
             * Enabled aggressive block sorting
             */
            public final double parsePrimary() {
                boolean bl;
                double x = 0.0;
                if (this.eat('(')) {
                    x = this.parseExpression();
                    this.eat(')');
                } else if (this.eat('0')) {
                    x = this.eat('x') || this.eat('X') ? this.parseHex() : (this.eat('b') || this.eat('B') ? this.parseBinary() : this.parseDecimalOrOctal());
                } else {
                    int startPos = this.pos;
                    char c = this.ch;
                    if ('1' <= c && '9' >= c || this.ch == '.') {
                        this.nextChar();
                        while ('0' <= (c = this.ch) && '9' >= c || this.ch == '.') {
                            this.nextChar();
                        }
                        String string = this.$str;
                        int n = this.pos;
                        boolean bl2 = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(startPos, n);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        string = string3;
                        n = 0;
                        x = Double.parseDouble(string);
                    } else {
                        double d;
                        c = this.ch;
                        if ('a' > c) {
                            throw (Throwable)new RuntimeException("Unexpected: " + this.ch);
                        }
                        if ('z' < c) throw (Throwable)new RuntimeException("Unexpected: " + this.ch);
                        while ('a' <= (c = this.ch) && 'z' >= c) {
                            this.nextChar();
                        }
                        String string = this.$str;
                        int n = this.pos;
                        bl = false;
                        String string4 = string;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(startPos, n);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String func = string5;
                        x = this.parseFactor();
                        switch (func) {
                            case "sqrt": {
                                n = 0;
                                d = Math.sqrt(x);
                                break;
                            }
                            case "sin": {
                                double d2 = Math.toRadians(x);
                                boolean bl3 = false;
                                d = Math.sin(d2);
                                break;
                            }
                            case "cos": {
                                double d3 = Math.toRadians(x);
                                boolean bl3 = false;
                                d = Math.cos(d3);
                                break;
                            }
                            case "tan": {
                                double d4 = Math.toRadians(x);
                                boolean bl3 = false;
                                d = Math.tan(d4);
                                break;
                            }
                            default: {
                                throw (Throwable)new RuntimeException("Unknown function: " + func);
                            }
                        }
                        x = d;
                    }
                }
                if (!this.eat('^')) return x;
                double d = x;
                double d5 = this.parseFactor();
                bl = false;
                return Math.pow(d, d5);
            }

            private final double parseHex() {
                int startPos = this.pos;
                while (true) {
                    char c;
                    if ('0' > (c = this.ch) || '9' < c) {
                        c = this.ch;
                        if ('a' > c || 'f' < c) {
                            c = this.ch;
                            if ('A' > c || 'F' < c) break;
                        }
                    }
                    this.nextChar();
                }
                String string = this.$str;
                int n = this.pos;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(startPos, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return Long.parseLong(string3, 16);
            }

            private final double parseBinary() {
                int startPos = this.pos;
                while (this.ch == '0' || this.ch == '1') {
                    this.nextChar();
                }
                String string = this.$str;
                int n = this.pos;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(startPos, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return Long.parseLong(string3, 2);
            }

            private final double parseDecimalOrOctal() {
                char c;
                int startPos = this.pos;
                if (this.eat('.')) {
                    while (true) {
                        char c2;
                        if ('0' > (c2 = this.ch) || '9' < c2) {
                            if (this.ch != '.') break;
                        }
                        this.nextChar();
                    }
                    String string = this.$str;
                    int n = this.pos;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(startPos, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = string3;
                    n = 0;
                    return Double.parseDouble(string);
                }
                while ('0' <= (c = this.ch) && '7' >= c) {
                    this.nextChar();
                }
                String string = this.$str;
                int n = this.pos;
                boolean bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(startPos, n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return Long.parseLong(string5, 8);
            }

            public final double parse() {
                this.nextChar();
                double x = this.parseExpression();
                if (this.pos < this.$str.length()) {
                    throw (Throwable)new RuntimeException("Unexpected: " + this.ch);
                }
                return x;
            }
            {
                this.$str = $captured_local_variable$0;
                this.pos = -1;
            }
        }.parse();
    }

    public CalculatorSEContributor() {
        ListCellRenderer listCellRenderer2;
        CalculatorSEContributor calculatorSEContributor = this;
        boolean bl = false;
        boolean bl2 = false;
        CalculatorSEContributor calculatorSEContributor2 = calculatorSEContributor;
        CalculatorSEContributor calculatorSEContributor3 = this;
        boolean bl3 = false;
        JPanel panel2 = new JPanel(new BorderLayout());
        SimpleColoredComponent resultComponent = new SimpleColoredComponent();
        SimpleColoredComponent shortcutComponent = new SimpleColoredComponent();
        panel2.add((Component)resultComponent, "Center");
        panel2.add((Component)shortcutComponent, "East");
        int sideGap = UIUtil.isUnderWin10LookAndFeel() ? 0 : JBUIScale.scale((int)UIUtil.getListCellHPadding());
        panel2.setBorder((Border)JBUI.Borders.empty((int)1, (int)sideGap));
        calculatorSEContributor3.renderer = listCellRenderer2 = (ListCellRenderer)new ListCellRenderer<EvaluationResult>(resultComponent, shortcutComponent, panel2){
            final /* synthetic */ SimpleColoredComponent $resultComponent;
            final /* synthetic */ SimpleColoredComponent $shortcutComponent;
            final /* synthetic */ JPanel $panel;

            public final Component getListCellRendererComponent(JList<? extends EvaluationResult> list2, EvaluationResult item, int $noName_2, boolean isSelected, boolean $noName_4) {
                Color color;
                this.$resultComponent.clear();
                this.$resultComponent.setIcon(AllIcons.Debugger.EvaluateExpression);
                if (isSelected) {
                    JList<? extends EvaluationResult> jList = list2;
                    Intrinsics.checkNotNullExpressionValue(jList, (String)"list");
                    color = jList.getSelectionForeground();
                } else {
                    JList<? extends EvaluationResult> jList = list2;
                    Intrinsics.checkNotNullExpressionValue(jList, (String)"list");
                    color = jList.getForeground();
                }
                Color foreground = color;
                SimpleTextAttributes attributes = new SimpleTextAttributes(0, foreground);
                this.$resultComponent.append(LangBundle.message((String)"search.everywhere.calculator.result.0", (Object[])new Object[]{String.valueOf(item.getValue())}), attributes);
                this.$shortcutComponent.clear();
                String string = KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 0));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KeymapUtil.getKeystrokeT\u2026ke(KeyEvent.VK_ENTER, 0))");
                String shortcutText = string;
                SimpleTextAttributes shortcutAttributes = isSelected ? new SimpleTextAttributes(0, list2.getSelectionForeground()) : SimpleTextAttributes.GRAY_ATTRIBUTES;
                this.$shortcutComponent.append(LangBundle.message((String)"search.everywhere.calculator.shortcut.0", (Object[])new Object[]{shortcutText}), shortcutAttributes);
                this.$panel.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)true));
                this.$panel.setFont(list2.getFont());
                return this.$panel;
            }
            {
                this.$resultComponent = simpleColoredComponent;
                this.$shortcutComponent = simpleColoredComponent2;
                this.$panel = jPanel2;
            }
        };
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/CalculatorSEContributor$Factory;", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributorFactory;", "Lcom/intellij/ide/actions/searcheverywhere/CalculatorSEContributor$EvaluationResult;", "()V", "createContributor", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributor;", "initEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.lang.impl"})
    public static final class Factory
    implements SearchEverywhereContributorFactory<EvaluationResult> {
        @NotNull
        public SearchEverywhereContributor<EvaluationResult> createContributor(@NotNull AnActionEvent initEvent) {
            Intrinsics.checkNotNullParameter((Object)initEvent, (String)"initEvent");
            return (SearchEverywhereContributor)new CalculatorSEContributor();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/CalculatorSEContributor$EvaluationResult;", "", "value", "", "(D)V", "getValue", "()D", "intellij.platform.lang.impl"})
    public static final class EvaluationResult {
        private final double value;

        public final double getValue() {
            return this.value;
        }

        public EvaluationResult(double value2) {
            this.value = value2;
        }
    }
}

