/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CommonCustomizeIDEWizardDialog;
import com.intellij.ide.customize.CustomizeIDEWizardInteractionType;
import com.intellij.ide.customize.CustomizeIDEWizardInteractions;
import com.intellij.ide.customize.CustomizeIDEWizardStepsProvider;
import com.intellij.idea.SplashManager;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizeIDEWizardDialog
extends DialogWrapper
implements CommonCustomizeIDEWizardDialog {
    protected static final String BUTTONS = "BUTTONS";
    protected static final String NO_BUTTONS = "NO_BUTTONS";
    protected final JButton mySkipButton;
    protected final JButton myBackButton;
    protected final JButton myNextButton;
    protected final JBCardLayout myCardLayout;
    protected final List<AbstractCustomizeWizardStep> mySteps;
    protected int myIndex;
    protected final JBLabel myNavigationLabel;
    protected final JBLabel myHeaderLabel;
    protected final JBLabel myFooterLabel;
    protected final CardLayout myButtonWrapperLayout;
    protected final JPanel myButtonWrapper;
    protected JPanel myContentPanel;
    protected final boolean myHideSkipButton;

    public CustomizeIDEWizardDialog(@NotNull CustomizeIDEWizardStepsProvider stepsProvider) {
        if (stepsProvider == null) {
            CustomizeIDEWizardDialog.$$$reportNull$$$0(0);
        }
        this(stepsProvider, null, true, true);
    }

    public CustomizeIDEWizardDialog(@NotNull CustomizeIDEWizardStepsProvider stepsProvider, @Nullable StartupUtil.AppStarter appStarter, boolean beforeSplash, boolean afterSplash) {
        int newIndex;
        if (stepsProvider == null) {
            CustomizeIDEWizardDialog.$$$reportNull$$$0(1);
        }
        super(null, true, true);
        this.mySkipButton = new JButton(IdeBundle.message((String)"button.skip.remaining.and.set.defaults", (Object[])new Object[0]));
        this.myBackButton = new JButton(IdeBundle.message((String)"button.back", (Object[])new Object[0]));
        this.myNextButton = new JButton(IdeBundle.message((String)"button.next", (Object[])new Object[0]));
        this.myCardLayout = new JBCardLayout();
        this.mySteps = new ArrayList<AbstractCustomizeWizardStep>();
        this.myIndex = 0;
        this.myNavigationLabel = new JBLabel();
        this.myHeaderLabel = new JBLabel();
        this.myFooterLabel = new JBLabel();
        this.myButtonWrapperLayout = new CardLayout();
        this.myButtonWrapper = new JPanel(this.myButtonWrapperLayout);
        this.setTitle(IdeBundle.message((String)"dialog.title.customize.0", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
        this.getPeer().setAppIcons();
        if (beforeSplash) {
            stepsProvider.initSteps(this, this.mySteps);
        }
        if (afterSplash) {
            stepsProvider.initStepsAfterSplash(this, this.mySteps);
        }
        if (appStarter != null && (newIndex = appStarter.customizeIdeWizardDialog(this.mySteps)) != -1) {
            this.myIndex = newIndex;
        }
        boolean bl = this.myHideSkipButton = this.mySteps.size() <= 1 || stepsProvider.hideSkipButton();
        if (this.mySteps.isEmpty()) {
            this.close(1);
            return;
        }
        this.mySkipButton.addActionListener(this);
        this.myBackButton.addActionListener(this);
        this.myNextButton.addActionListener(this);
        AbstractCustomizeWizardStep.applyHeaderFooterStyle(this.myNavigationLabel);
        AbstractCustomizeWizardStep.applyHeaderFooterStyle(this.myHeaderLabel);
        AbstractCustomizeWizardStep.applyHeaderFooterStyle(this.myFooterLabel);
        this.init();
        this.initCurrentStep(true);
        this.setSize(400, 300);
        System.setProperty("StartupWizardMode", "true");
    }

    @Override
    public final void show() {
        if (this.mySteps.isEmpty()) {
            throw new IllegalStateException("no steps provided");
        }
        CustomizeIDEWizardInteractions.INSTANCE.record(CustomizeIDEWizardInteractionType.WizardDisplayed);
        SplashManager.executeWithHiddenSplash(this.getWindow(), () -> super.show());
    }

    @Override
    public final boolean showIfNeeded() {
        boolean willBeShown;
        boolean bl = willBeShown = !this.mySteps.isEmpty() && !this.isDisposed();
        if (willBeShown) {
            this.show();
        }
        return willBeShown;
    }

    protected void dispose() {
        System.clearProperty("StartupWizardMode");
        super.dispose();
    }

    protected JComponent createCenterPanel() {
        JPanel result2 = new JPanel(new BorderLayout(5, 5));
        this.myContentPanel = new JPanel((LayoutManager)this.myCardLayout);
        for (AbstractCustomizeWizardStep step : this.mySteps) {
            this.myContentPanel.add((Component)step, step.getTitle());
        }
        JPanel topPanel = new JPanel(new BorderLayout(5, 5));
        if (this.mySteps.size() > 1) {
            topPanel.add((Component)this.myNavigationLabel, "North");
        }
        topPanel.add((Component)this.myHeaderLabel, "Center");
        result2.add((Component)topPanel, "North");
        result2.add((Component)this.myContentPanel, "Center");
        result2.add((Component)this.myFooterLabel, "South");
        result2.setPreferredSize((Dimension)JBUI.size((int)700, (int)600));
        result2.setBorder(AbstractCustomizeWizardStep.createSmallEmptyBorder());
        return result2;
    }

    protected JComponent createSouthPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.right = 5;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        if (!this.myHideSkipButton) {
            buttonPanel.add((Component)this.mySkipButton, gbc);
        }
        ++gbc.gridx;
        buttonPanel.add((Component)this.myBackButton, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        buttonPanel.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        buttonPanel.add((Component)this.myNextButton, gbc);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        this.myButtonWrapper.add((Component)buttonPanel, BUTTONS);
        this.myButtonWrapper.add((Component)new JLabel(), NO_BUTTONS);
        this.myButtonWrapperLayout.show(this.myButtonWrapper, BUTTONS);
        return this.myButtonWrapper;
    }

    void setButtonsVisible(boolean visible) {
        this.myButtonWrapperLayout.show(this.myButtonWrapper, visible ? BUTTONS : NO_BUTTONS);
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        if (e == null) {
            CustomizeIDEWizardDialog.$$$reportNull$$$0(2);
        }
        if (e.getSource() == this.mySkipButton) {
            CustomizeIDEWizardInteractions.INSTANCE.setSkippedOnPage(this.myIndex);
            this.doOKAction();
            return;
        }
        if (e.getSource() == this.myBackButton) {
            --this.myIndex;
            this.initCurrentStep(false);
            return;
        }
        if (e.getSource() == this.myNextButton) {
            if (this.myIndex >= this.mySteps.size() - 1) {
                this.doOKAction();
                return;
            }
            ++this.myIndex;
            this.initCurrentStep(true);
        }
    }

    @Nullable
    protected ActionListener createCancelAction() {
        return null;
    }

    @Override
    public void doCancelAction() {
        this.doOKAction();
    }

    protected void doOKAction() {
        for (AbstractCustomizeWizardStep step : this.mySteps) {
            if (step.beforeOkAction()) continue;
            int index = this.mySteps.indexOf(step);
            if (this.myIndex != index) {
                this.myIndex = index;
                this.initCurrentStep(true);
            }
            return;
        }
        super.doOKAction();
    }

    protected boolean canRecordDialogId() {
        return false;
    }

    protected void initCurrentStep(boolean forward) {
        AbstractCustomizeWizardStep myCurrentStep = this.mySteps.get(this.myIndex);
        myCurrentStep.beforeShown(forward);
        this.myCardLayout.swipe((Container)this.myContentPanel, myCurrentStep.getTitle(), JBCardLayout.SwipeDirection.AUTO, () -> {
            Component component2 = myCurrentStep.getDefaultFocusedComponent();
            if (component2 != null) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component2, true));
            }
        });
        this.myBackButton.setVisible(this.myIndex > 0);
        if (this.myIndex > 0) {
            this.myBackButton.setText(IdeBundle.message((String)"button.back.to.0", (Object[])new Object[]{this.mySteps.get(this.myIndex - 1).getTitle()}));
        }
        this.myNextButton.setText(this.myIndex < this.mySteps.size() - 1 ? IdeBundle.message((String)"button.next.0", (Object[])new Object[]{this.mySteps.get(this.myIndex + 1).getTitle()}) : IdeBundle.message((String)"button.start.using.0", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
        this.myHeaderLabel.setText(CustomizeIDEWizardDialog.ensureHTML(myCurrentStep.getHTMLHeader()));
        this.myFooterLabel.setText(CustomizeIDEWizardDialog.ensureHTML(myCurrentStep.getHTMLFooter()));
        if (this.mySteps.size() > 1) {
            HtmlChunk.Element body = HtmlChunk.body();
            String arrow = this.myNavigationLabel.getFont().canDisplay(8594) ? "&#8594;" : "&gt;";
            for (int i2 = 0; i2 < this.mySteps.size(); ++i2) {
                if (i2 > 0) {
                    body = body.children(new HtmlChunk[]{HtmlChunk.nbsp(), HtmlChunk.raw((String)arrow), HtmlChunk.nbsp()});
                }
                body = i2 == this.myIndex ? body.children(new HtmlChunk[]{HtmlChunk.tag((String)"b").addText(this.mySteps.get(i2).getTitle())}) : body.addText(this.mySteps.get(i2).getTitle());
            }
            String navHtml = new HtmlBuilder().append((HtmlChunk)HtmlChunk.html().child((HtmlChunk)body)).toString();
            this.myNavigationLabel.setText(navHtml);
        }
    }

    @Contract(value="!null->!null", pure=true)
    private static String ensureHTML(@Nullable String s) {
        return s == null ? null : (s.startsWith("<html>") ? s : "<html>" + StringUtil.escapeXmlEntities((String)s) + "</html>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/customize/CustomizeIDEWizardDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

