/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.gdpr.ConsentAttributes;
import com.intellij.ide.gdpr.ConsentBase;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NonNls;

public final class Consent
extends ConsentBase {
    @NlsSafe
    private final String myName;
    @NlsSafe
    private final String myText;
    private final boolean myAccepted;
    private final boolean myDeleted;

    public Consent(ConsentAttributes attributes) {
        this(attributes.consentId, Version.fromString(attributes.version), attributes.printableName, attributes.text, attributes.accepted, attributes.deleted);
    }

    public Consent(String id2, Version version2, @NlsSafe String name, String text2, boolean isAccepted, boolean deleted) {
        super(id2, version2);
        this.myName = name;
        this.myText = text2;
        this.myAccepted = isAccepted;
        this.myDeleted = deleted;
    }

    @NlsSafe
    public String getName() {
        return this.myName;
    }

    @NlsSafe
    public String getText() {
        return this.myText;
    }

    @Override
    public boolean isAccepted() {
        return this.myAccepted;
    }

    public boolean isDeleted() {
        return this.myDeleted;
    }

    public ConsentAttributes toConsentAttributes() {
        ConsentAttributes attributes = new ConsentAttributes();
        attributes.consentId = this.getId();
        attributes.version = this.getVersion().toString();
        attributes.printableName = this.getName();
        attributes.text = this.getText();
        attributes.accepted = this.isAccepted();
        attributes.deleted = this.isDeleted();
        return attributes;
    }

    @Override
    @NonNls
    public String toString() {
        return "Consent{id='" + this.getId() + "', version='" + this.getVersion() + "', name='" + this.myName + "', accepted=" + this.myAccepted + ", deleted=" + this.myDeleted + "}";
    }

    public Consent derive(boolean accepted) {
        return accepted == this.isAccepted() ? this : new Consent(this.getId(), this.getVersion(), this.getName(), this.getText(), accepted, this.isDeleted());
    }
}

