/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.AutoScrollToSourceOptionProvider;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CollapseAllAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.actions.ExpandAllAction;
import com.intellij.ide.actions.ExportToTextFileToolbarAction;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AutoScrollToSourceHandler;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

final class CommonActionsManagerImpl
extends CommonActionsManager {
    CommonActionsManagerImpl() {
    }

    public AnAction createPrevOccurenceAction(OccurenceNavigator navigator) {
        return new PreviousOccurenceToolbarAction(navigator);
    }

    public AnAction createNextOccurenceAction(OccurenceNavigator navigator) {
        return new NextOccurenceToolbarAction(navigator);
    }

    public AnAction createExpandAllAction(TreeExpander expander) {
        return new ExpandAllAction(event -> expander);
    }

    public AnAction createExpandAllAction(TreeExpander expander, JComponent component2) {
        ExpandAllAction expandAllToolbarAction = new ExpandAllAction(event -> expander);
        expandAllToolbarAction.registerCustomShortcutSet(expandAllToolbarAction.getShortcutSet(), component2);
        return expandAllToolbarAction;
    }

    public AnAction createExpandAllHeaderAction(TreeExpander expander, JComponent component2) {
        AnAction action2 = this.createExpandAllAction(expander, component2);
        action2.getTemplatePresentation().setIcon(AllIcons.Actions.Expandall);
        return action2;
    }

    public AnAction createExpandAllHeaderAction(JTree tree) {
        return this.createExpandAllHeaderAction((TreeExpander)new DefaultTreeExpander(tree), tree);
    }

    public AnAction createCollapseAllAction(TreeExpander expander) {
        return new CollapseAllAction(event -> expander);
    }

    public AnAction createCollapseAllAction(TreeExpander expander, JComponent component2) {
        CollapseAllAction collapseAllToolbarAction = new CollapseAllAction(event -> expander);
        collapseAllToolbarAction.registerCustomShortcutSet(collapseAllToolbarAction.getShortcutSet(), component2);
        return collapseAllToolbarAction;
    }

    public AnAction createCollapseAllHeaderAction(TreeExpander expander, JComponent component2) {
        AnAction action2 = this.createCollapseAllAction(expander, component2);
        action2.getTemplatePresentation().setIcon(AllIcons.Actions.Collapseall);
        return action2;
    }

    public AnAction createCollapseAllHeaderAction(JTree tree) {
        return this.createCollapseAllHeaderAction((TreeExpander)new DefaultTreeExpander(tree), tree);
    }

    public AnAction createHelpAction(String helpId) {
        return new ContextHelpAction(helpId);
    }

    public AnAction installAutoscrollToSourceHandler(Project project, JTree tree, final AutoScrollToSourceOptionProvider optionProvider) {
        AutoScrollToSourceHandler handler2 = new AutoScrollToSourceHandler(){

            public boolean isAutoScrollMode() {
                return optionProvider.isAutoScrollMode();
            }

            public void setAutoScrollMode(boolean state) {
                optionProvider.setAutoScrollMode(state);
            }
        };
        handler2.install(tree);
        return handler2.createToggleAction();
    }

    public AnAction createExportToTextFileAction(@NotNull ExporterToTextFile exporter) {
        if (exporter == null) {
            CommonActionsManagerImpl.$$$reportNull$$$0(0);
        }
        return new ExportToTextFileToolbarAction(exporter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exporter", "com/intellij/ide/impl/CommonActionsManagerImpl", "createExportToTextFileAction"));
    }
}

