/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Service
public final class CustomPluginRepositoryService {
    private Collection<IdeaPluginDescriptor> myCustomRepositoryPluginsList;
    private Map<String, List<IdeaPluginDescriptor>> myCustomRepositoryPluginsMap;
    private final Object myRepositoriesLock = new Object();
    private static final Logger LOG = Logger.getInstance(CustomPluginRepositoryService.class);

    public static CustomPluginRepositoryService getInstance() {
        return (CustomPluginRepositoryService)ApplicationManager.getApplication().getService(CustomPluginRepositoryService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Map<String, List<IdeaPluginDescriptor>> getCustomRepositoryPluginMap() {
        Object object = this.myRepositoriesLock;
        // MONITORENTER : object
        if (this.myCustomRepositoryPluginsMap != null) {
            Map<String, List<IdeaPluginDescriptor>> map2 = this.myCustomRepositoryPluginsMap;
            // MONITOREXIT : object
            if (map2 != null) return map2;
            CustomPluginRepositoryService.$$$reportNull$$$0(0);
            return map2;
        }
        // MONITOREXIT : object
        HashMap<PluginId, IdeaPluginDescriptor> latestCustomPluginsAsMap = new HashMap<PluginId, IdeaPluginDescriptor>();
        HashMap<String, List<IdeaPluginDescriptor>> customRepositoryPluginsMap = new HashMap<String, List<IdeaPluginDescriptor>>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            try {
                if (host == null) continue;
                List<IdeaPluginDescriptor> descriptors2 = RepositoryHelper.loadPlugins(host, null);
                for (IdeaPluginDescriptor descriptor2 : descriptors2) {
                    PluginId pluginId = descriptor2.getPluginId();
                    IdeaPluginDescriptor savedDescriptor = (IdeaPluginDescriptor)latestCustomPluginsAsMap.get(pluginId);
                    if (savedDescriptor == null) {
                        latestCustomPluginsAsMap.put(pluginId, descriptor2);
                        continue;
                    }
                    if (StringUtil.compareVersionNumbers((String)descriptor2.getVersion(), (String)savedDescriptor.getVersion()) <= 0) continue;
                    latestCustomPluginsAsMap.put(pluginId, descriptor2);
                }
                customRepositoryPluginsMap.put(host, descriptors2);
            }
            catch (IOException e) {
                LOG.info(host, (Throwable)e);
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> UpdateChecker.updateDescriptorsForInstalledPlugins(InstalledPluginsState.getInstance()));
        Object object2 = this.myRepositoriesLock;
        // MONITORENTER : object2
        if (this.myCustomRepositoryPluginsMap == null) {
            this.myCustomRepositoryPluginsMap = customRepositoryPluginsMap;
            this.myCustomRepositoryPluginsList = latestCustomPluginsAsMap.values();
        }
        Map<String, List<IdeaPluginDescriptor>> map3 = this.myCustomRepositoryPluginsMap;
        // MONITOREXIT : object2
        if (map3 != null) return map3;
        CustomPluginRepositoryService.$$$reportNull$$$0(1);
        return map3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Collection<IdeaPluginDescriptor> getCustomRepositoryPlugins() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            if (this.myCustomRepositoryPluginsList != null) {
                Collection<IdeaPluginDescriptor> collection = this.myCustomRepositoryPluginsList;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                if (collection == null) {
                    CustomPluginRepositoryService.$$$reportNull$$$0(2);
                }
                return collection;
            }
        }
        this.getCustomRepositoryPluginMap();
        Collection<IdeaPluginDescriptor> collection = this.myCustomRepositoryPluginsList;
        if (collection == null) {
            CustomPluginRepositoryService.$$$reportNull$$$0(3);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            this.myCustomRepositoryPluginsList = null;
            this.myCustomRepositoryPluginsMap = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/plugins/CustomPluginRepositoryService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomRepositoryPluginMap";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomRepositoryPlugins";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

